/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.basedriver.importer.util;

import org.apache.felix.upnp.basedriver.importer.util.StringSplitter;

public class ParseUSN {
    boolean service;
    boolean device;
    String udn;
    String serviceType;

    public ParseUSN(String usn) {
        String[] splited = StringSplitter.split(usn, ':');
        if (splited.length == 5 || splited.length == 2) {
            this.udn = "uuid:" + splited[1];
            this.device = true;
            this.service = false;
        } else if (splited.length == 8) {
            this.udn = "uuid:" + splited[1];
            if (splited[5].equals("device")) {
                this.device = true;
                this.service = false;
            } else {
                this.serviceType = splited[3] + ":" + splited[4] + ":" + splited[5] + ":" + splited[6] + ":" + splited[7];
                this.device = false;
                this.service = true;
            }
        }
    }

    public boolean isService() {
        return this.service;
    }

    public boolean isDevice() {
        return this.device;
    }

    public String getUDN() {
        return this.udn;
    }

    public String getServiceType() {
        return this.serviceType;
    }
}

