/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.basedriver.importer.core.event.thread;

import org.apache.felix.upnp.basedriver.importer.core.event.message.StateChanged;
import org.apache.felix.upnp.basedriver.importer.core.event.structs.Monitor;
import org.apache.felix.upnp.basedriver.importer.core.event.structs.NotifierQueue;
import org.apache.felix.upnp.basedriver.importer.core.event.structs.StateVarsToNotify;

public class Notifier
extends Thread {
    private NotifierQueue notifierQueue;
    private Monitor monitor;
    private boolean running = true;

    public Notifier(NotifierQueue notifierQueue, Monitor monitor) {
        super("upnp.basedriver.Notifier");
        this.notifierQueue = notifierQueue;
        this.monitor = monitor;
    }

    public void run() {
        while (this.running) {
            StateChanged msg = (StateChanged)this.notifierQueue.dequeue();
            if (!this.running) continue;
            StateVarsToNotify vars = null;
            if (msg.getSeq() == 0L) {
                vars = new StateVarsToNotify(msg);
                this.monitor.putStateVars(msg.getSid(), vars);
                continue;
            }
            this.monitor.updateStateVars(msg.getSid(), msg.getDictionary());
        }
    }

    public void close() {
        this.running = false;
        this.notifierQueue.close();
    }
}

