/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.deployer.obr;

import aQute.lib.deployer.FileRepo;
import aQute.lib.deployer.obr.AbstractBaseOBR;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBR
extends AbstractBaseOBR {
    public static final String PROP_LOCATIONS = "locations";
    @Deprecated
    public static final String PROP_LOCATION = "location";
    public static final String PROP_CACHE = "cache";
    protected List<URL> locations;
    protected File cacheDir;

    @Override
    public void setProperties(Map<String, String> map) {
        super.setProperties(map);
        String locationsStr = map.get(PROP_LOCATIONS);
        if (locationsStr == null) {
            locationsStr = map.get(PROP_LOCATION);
        }
        try {
            this.locations = locationsStr != null ? OBR.parseLocations(locationsStr) : Collections.emptyList();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(String.format("Invalid location, unable to parse as URL list: %s", locationsStr), e);
        }
        String cacheDirStr = map.get(PROP_CACHE);
        if (cacheDirStr != null) {
            this.cacheDir = new File(cacheDirStr);
        }
    }

    private FileRepo lookupCachedFileRepo() {
        if (this.registry != null) {
            List<FileRepo> repos = this.registry.getPlugins(FileRepo.class);
            for (FileRepo repo : repos) {
                if (!PROP_CACHE.equals(repo.getName())) continue;
                return repo;
            }
        }
        return null;
    }

    public List<URL> getOBRIndexes() {
        return this.locations;
    }

    @Override
    public synchronized File getCacheDirectory() {
        FileRepo cacheRepo;
        if (this.cacheDir == null && (cacheRepo = this.lookupCachedFileRepo()) != null) {
            File temp = new File(cacheRepo.getRoot(), ".obr");
            temp.mkdirs();
            if (temp.exists()) {
                this.cacheDir = temp;
            }
        }
        return this.cacheDir;
    }

    public void setCacheDirectory(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    @Override
    public String getName() {
        if (this.name != null && this.name != this.getClass().getName()) {
            return this.name;
        }
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (URL location : this.locations) {
            if (count++ > 0) {
                builder.append(',');
            }
            builder.append(location);
        }
        return builder.toString();
    }

    public void setLocations(URL[] urls) {
        this.locations = Arrays.asList(urls);
    }
}

