/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.signing;

import aQute.lib.base64.Base64;
import aQute.lib.osgi.EmbeddedResource;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Resource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.regex.Pattern;

public class Signer
extends Processor {
    static Pattern METAINFDIR = Pattern.compile("META-INF/[^/]*");
    String[] digestNames = new String[]{"MD5"};
    File keystoreFile = new File("keystore");
    String password;
    String alias;

    public void signJar(Jar jar) {
        if (this.digestNames == null || this.digestNames.length == 0) {
            this.error("Need at least one digest algorithm name, none are specified", new Object[0]);
        }
        if (this.keystoreFile == null || !this.keystoreFile.getAbsoluteFile().exists()) {
            this.error("No such keystore file: " + this.keystoreFile, new Object[0]);
            return;
        }
        if (this.alias == null) {
            this.error("Private key alias not set for signing", new Object[0]);
            return;
        }
        MessageDigest[] digestAlgorithms = new MessageDigest[this.digestNames.length];
        this.getAlgorithms(this.digestNames, digestAlgorithms);
        try {
            Manifest manifest = jar.getManifest();
            manifest.getMainAttributes().putValue("Signed-By", "Bnd");
            ByteArrayOutputStream o = new ByteArrayOutputStream();
            manifest.write(o);
            this.doManifest(jar, this.digestNames, digestAlgorithms, o);
            o.flush();
            byte[] newManifestBytes = o.toByteArray();
            jar.putResource("META-INF/MANIFEST.MF", new EmbeddedResource(newManifestBytes, 0L));
            byte[] signatureFileBytes = this.doSignatureFile(this.digestNames, digestAlgorithms, newManifestBytes);
            jar.putResource("META-INF/BND.SF", new EmbeddedResource(signatureFileBytes, 0L));
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            KeyStore.PrivateKeyEntry privateKeyEntry = null;
            try {
                FileInputStream keystoreInputStream = new FileInputStream(this.keystoreFile);
                keystore.load(keystoreInputStream, this.password == null ? null : this.password.toCharArray());
                keystoreInputStream.close();
                privateKeyEntry = (KeyStore.PrivateKeyEntry)keystore.getEntry(this.alias, new KeyStore.PasswordProtection(this.password.toCharArray()));
            }
            catch (Exception e) {
                this.error("No able to load the private key from the give keystore(" + this.keystoreFile.getAbsolutePath() + ") with alias " + this.alias + " : " + e, new Object[0]);
                return;
            }
            PrivateKey privateKey = privateKeyEntry.getPrivateKey();
            Signature signature = Signature.getInstance("MD5withRSA");
            signature.initSign(privateKey);
            signature.update(signatureFileBytes);
            signature.sign();
            ByteArrayOutputStream tmpStream = new ByteArrayOutputStream();
            jar.putResource("META-INF/BND.RSA", new EmbeddedResource(tmpStream.toByteArray(), 0L));
        }
        catch (Exception e) {
            this.error("During signing: " + e, new Object[0]);
        }
    }

    private byte[] doSignatureFile(String[] digestNames, MessageDigest[] algorithms, byte[] manbytes) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(out);
        ps.print("Signature-Version: 1.0\r\n");
        int a = 0;
        while (a < algorithms.length) {
            if (algorithms[a] != null) {
                byte[] digest = algorithms[a].digest(manbytes);
                ps.print(String.valueOf(digestNames[a]) + "-Digest-Manifest: ");
                ps.print(new Base64(digest));
                ps.print("\r\n");
            }
            ++a;
        }
        return out.toByteArray();
    }

    private void doManifest(Jar jar, String[] digestNames, MessageDigest[] algorithms, OutputStream out) throws Exception {
        for (Map.Entry<String, Resource> entry : jar.getResources().entrySet()) {
            String name = entry.getKey();
            if (METAINFDIR.matcher(name).matches()) continue;
            out.write("\r\n".getBytes());
            out.write("Name: ".getBytes());
            out.write(name.getBytes());
            out.write("\r\n".getBytes());
            this.digest(algorithms, entry.getValue());
            int a = 0;
            while (a < algorithms.length) {
                if (algorithms[a] != null) {
                    byte[] digest = algorithms[a].digest();
                    String header = String.valueOf(digestNames[a]) + "-Digest: " + new Base64(digest) + "\r\n";
                    out.write(header.getBytes());
                }
                ++a;
            }
        }
    }

    private void digest(MessageDigest[] algorithms, Resource r) throws Exception {
        InputStream in = r.openInputStream();
        byte[] data = new byte[1024];
        int size = in.read(data);
        while (size > 0) {
            int a = 0;
            while (a < algorithms.length) {
                if (algorithms[a] != null) {
                    algorithms[a].update(data, 0, size);
                }
                ++a;
            }
            size = in.read(data);
        }
    }

    private void getAlgorithms(String[] digestNames, MessageDigest[] algorithms) {
        int i = 0;
        while (i < algorithms.length) {
            String name = digestNames[i];
            try {
                algorithms[i] = MessageDigest.getInstance(name);
            }
            catch (NoSuchAlgorithmException e) {
                this.error("Specified digest algorithm " + digestNames[i] + ", but not such algorithm was found: " + e, new Object[0]);
            }
            ++i;
        }
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setKeystore(File keystore) {
        this.keystoreFile = keystore;
    }

    public void setAlias(String string) {
        this.alias = string;
    }
}

