/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.component;

import aQute.bnd.component.ComponentDef;
import aQute.bnd.component.ReferenceDef;
import aQute.lib.collections.MultiMap;
import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Annotation;
import aQute.lib.osgi.ClassDataCollector;
import aQute.lib.osgi.Clazz;
import aQute.lib.osgi.Verifier;
import aQute.libg.version.Version;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

public class AnnotationReader
extends ClassDataCollector {
    static final String[] EMPTY = new String[0];
    static final Pattern PROPERTY_PATTERN = Pattern.compile("([^=]+(:(Boolean|Byte|Char|Short|Integer|Long|Float|Double|String))?)\\s*=(.*)");
    public static final Version V1_1 = new Version("1.1.0");
    public static final Version V1_2 = new Version("1.2.0");
    static Pattern BINDDESCRIPTOR = Pattern.compile("\\(((L([^;]+);)(Ljava/util/Map;)?|Lorg/osgi/framework/ServiceReference;)\\)V");
    static Pattern BINDMETHOD = Pattern.compile("(set|bind|add)?(.*)");
    static Pattern ACTIVATEDESCRIPTOR = Pattern.compile("\\(((Lorg/osgi/service/component/ComponentContext;)|(Lorg/osgi/framework/BundleContext;)|(Ljava/util/Map;))*\\)V");
    static Pattern REFERENCEBINDDESCRIPTOR = Pattern.compile("\\(Lorg/osgi/framework/ServiceReference;\\)V");
    ComponentDef component = new ComponentDef();
    Clazz clazz;
    String[] interfaces;
    String methodDescriptor;
    String method;
    String className;
    int methodAccess;
    Analyzer analyzer;
    MultiMap<String, String> methods = new MultiMap();
    String extendsClass;

    AnnotationReader(Analyzer analyzer, Clazz clazz) {
        this.analyzer = analyzer;
        this.clazz = clazz;
    }

    public static ComponentDef getDefinition(Clazz c, Analyzer analyzer) throws Exception {
        AnnotationReader r = new AnnotationReader(analyzer, c);
        return r.getDef(c, analyzer);
    }

    /*
     * Unable to fully structure code
     */
    private ComponentDef getDef(Clazz c, Analyzer analyzer) throws Exception {
        c.parseClassFileWithCollector(this);
        if (this.component.implementation != null) ** GOTO lbl12
        return null;
        while (!this.extendsClass.startsWith("java/")) {
            ec = analyzer.findClass(this.extendsClass);
            if (ec == null) {
                analyzer.error("Missing super class for DS annotations: " + Clazz.pathToFqn(this.extendsClass) + " from " + c.getFQN(), new Object[0]);
            } else {
                c.parseClassFileWithCollector(this);
            }
lbl12:
            // 3 sources

            if (this.extendsClass != null) continue;
        }
        if (this.component.implementation != null) {
            for (ReferenceDef rdef : this.component.references.values()) {
                rdef.unbind = this.referredMethod(analyzer, rdef, rdef.unbind, new String[]{"add(.*)", "remove$1", "(.*)", "un$1"});
                rdef.modified = this.referredMethod(analyzer, rdef, rdef.modified, new String[]{"(add|set)(.*)", "modified$2", "(.*)", "modified$1"});
            }
            return this.component;
        }
        return null;
    }

    protected String referredMethod(Analyzer analyzer, ReferenceDef rdef, String value, String ... matches) {
        if (value == null) {
            String bind = rdef.bind;
            int i = 0;
            while (i < matches.length) {
                Matcher m = Pattern.compile(matches[i]).matcher(bind);
                if (m.matches()) {
                    value = m.replaceFirst(matches[i + 1]);
                    break;
                }
                i += 2;
            }
        } else if (value.equals("-")) {
            return null;
        }
        if (this.methods.containsKey(value)) {
            for (String descriptor : (Set)this.methods.get(value)) {
                String type;
                Matcher matcher = BINDDESCRIPTOR.matcher(descriptor);
                if (!matcher.matches() || !rdef.interfce.equals(Clazz.objectDescriptorToFQN(type = matcher.group(2))) && !type.equals("Ljava/util/Map;") && !type.equals("Lorg/osgi/framework/ServiceReference;")) continue;
                return value;
            }
            analyzer.error("A related method to %s from the reference %s has no proper prototype for class %s. Expected void %s(%s s [,Map m] | ServiceReference r)", rdef.bind, value, this.component.implementation, value, rdef.interfce);
        }
        return null;
    }

    public void annotation(Annotation annotation) {
        try {
            Object a = annotation.getAnnotation();
            if (a instanceof Component) {
                this.doComponent((Component)a, annotation);
            } else if (a instanceof Activate) {
                this.doActivate();
            } else if (a instanceof Deactivate) {
                this.doDeactivate();
            } else if (a instanceof Modified) {
                this.doModified();
            } else if (a instanceof Reference) {
                this.doReference((Reference)a, annotation);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.analyzer.error("During generation of a component on class %s, exception %s", this.clazz, e);
        }
    }

    protected void doDeactivate() {
        if (!ACTIVATEDESCRIPTOR.matcher(this.methodDescriptor).matches()) {
            this.analyzer.error("Deactivate method for %s does not have an acceptable prototype, only Map, ComponentContext, or BundleContext is allowed. Found: %s", this.clazz, this.methodDescriptor);
        } else {
            this.component.deactivate = this.method;
        }
    }

    protected void doModified() {
        if (!ACTIVATEDESCRIPTOR.matcher(this.methodDescriptor).matches()) {
            this.analyzer.error("Modified method for %s does not have an acceptable prototype, only Map, ComponentContext, or BundleContext is allowed. Found: %s", this.clazz, this.methodDescriptor);
        } else {
            this.component.modified = this.method;
        }
    }

    protected void doReference(Reference reference, Annotation raw) throws Exception {
        Matcher m;
        ReferenceDef def = new ReferenceDef();
        def.name = reference.name();
        if (def.name == null) {
            m = BINDMETHOD.matcher(this.method);
            def.name = m.matches() ? m.group(2) : this.method;
        }
        def.unbind = reference.unbind();
        def.bind = this.method;
        def.interfce = (String)raw.get("service");
        if (def.interfce != null) {
            def.interfce = Clazz.objectDescriptorToFQN(def.interfce);
        } else {
            m = BINDDESCRIPTOR.matcher(this.methodDescriptor);
            if (m.matches()) {
                def.interfce = Clazz.internalToFqn(m.group(3));
            } else {
                throw new IllegalArgumentException("Cannot detect the type of a Component Reference from the descriptor: " + this.methodDescriptor);
            }
        }
        def.target = reference.target();
        if (def.target != null) {
            Verifier.verifyFilter(def.target, 0);
        }
        if (this.component.references.containsKey(def.name)) {
            this.analyzer.error("In component %s, multiple references with the same name: %s. Previous def: %s, this def: %s", this.component.implementation, this.component.references.get(def.name), def.interfce, "");
        } else {
            this.component.references.put(def.name, def);
        }
        def.cardinality = reference.cardinality();
        def.policy = reference.policy();
    }

    protected void doActivate() {
        if (!ACTIVATEDESCRIPTOR.matcher(this.methodDescriptor).matches()) {
            this.analyzer.error("Activate method for %s does not have an acceptable prototype, only Map, ComponentContext, or BundleContext is allowed. Found: %s", this.clazz, this.methodDescriptor);
        } else {
            this.component.activate = this.method;
        }
    }

    protected void doComponent(Component comp, Annotation annotation) throws Exception {
        String[] properties;
        if (this.component.implementation != null) {
            return;
        }
        this.component.version = V1_1;
        this.component.implementation = this.clazz.getFQN();
        this.component.name = comp.name();
        this.component.factory = comp.factory();
        this.component.configurationPolicy = comp.configurationPolicy();
        if (annotation.get("enabled") != null) {
            this.component.enabled = comp.enabled();
        }
        if (annotation.get("factory") != null) {
            this.component.factory = comp.factory();
        }
        if (annotation.get("immediate") != null) {
            this.component.immediate = comp.immediate();
        }
        if (annotation.get("servicefactory") != null) {
            this.component.servicefactory = comp.servicefactory();
        }
        if ((properties = comp.properties()) != null) {
            String[] stringArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                this.component.properties.add(entry);
                ++n2;
            }
        }
        this.doProperties(comp.property());
        Object[] x = (Object[])annotation.get("service");
        if (x == null) {
            if (this.interfaces != null) {
                ArrayList<String> result = new ArrayList<String>();
                int i = 0;
                while (i < this.interfaces.length) {
                    if (!this.interfaces[i].equals("scala/ScalaObject")) {
                        result.add(Clazz.internalToFqn(this.interfaces[i]));
                    }
                    ++i;
                }
                this.component.service = result.toArray(EMPTY);
            }
        } else {
            this.component.service = new String[x.length];
            int i = 0;
            while (i < x.length) {
                this.component.service[i] = Clazz.objectDescriptorToFQN(x[i].toString());
                ++i;
            }
        }
    }

    private void doProperties(String[] properties) {
        if (properties != null) {
            String[] stringArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                Matcher m = PROPERTY_PATTERN.matcher(p);
                if (!m.matches()) {
                    throw new IllegalArgumentException("Malformed property '" + p + "' on component: " + this.className);
                }
                String key = m.group(1);
                String value = m.group(4);
                this.component.property.add(key, value);
                ++n2;
            }
        }
    }

    public void classBegin(int access, String name) {
        this.className = name;
    }

    public void implementsInterfaces(String[] interfaces) {
        this.interfaces = interfaces;
    }

    public void method(int access, String name, String descriptor) {
        if (Modifier.isPrivate(access) || Modifier.isAbstract(access) || Modifier.isStatic(access)) {
            return;
        }
        this.method = name;
        this.methodDescriptor = descriptor;
        this.methodAccess = access;
        this.methods.add(name, descriptor);
    }

    public void extendsClass(String name) {
        this.extendsClass = name;
    }
}

