/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.ext;

import java.util.HashMap;
import java.util.Map;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;

public class TimesyncExtension
extends BayeuxServer.Extension.Adapter {
    public static final String LAG_ATTRIBUTE = "lag";
    private int _accuracyTarget = 25;

    public int getAccuracyTarget() {
        return this._accuracyTarget;
    }

    public void setAccuracyTarget(int target) {
        this._accuracyTarget = target;
    }

    public boolean rcvMeta(ServerSession from, ServerMessage.Mutable message) {
        Map sync;
        Map<String, Object> ext = message.getExt(false);
        if (ext != null && (sync = (Map)ext.get("timesync")) != null) {
            sync.put("ts", System.currentTimeMillis());
            Number lag = (Number)sync.get("l");
            if (lag != null && from != null) {
                from.setAttribute(LAG_ATTRIBUTE, lag);
            }
        }
        return true;
    }

    public boolean sendMeta(ServerSession session, ServerMessage.Mutable message) {
        Map sync;
        Map<String, Object> extIn;
        ServerMessage.Mutable associated = message.getAssociated();
        if (associated != null && (extIn = associated.getExt()) != null && (sync = (Map)extIn.get("timesync")) != null) {
            long tc = ((Number)sync.get("tc")).longValue();
            long ts = ((Number)sync.get("ts")).longValue();
            Number lag = (Number)sync.get("l");
            if (lag == null) {
                Map<String, Object> extOut = message.getExt(true);
                HashMap<String, Long> timesync = new HashMap<String, Long>(3);
                timesync.put("tc", tc);
                timesync.put("ts", ts);
                timesync.put("p", System.currentTimeMillis() - ts);
                extOut.put("timesync", timesync);
            } else {
                int l = lag.intValue();
                int o = ((Number)sync.get("o")).intValue();
                int a = (int)(tc + (long)o + (long)l - ts);
                if (l == 0 || a >= this._accuracyTarget || a <= -this._accuracyTarget) {
                    Map<String, Object> extOut = message.getExt(true);
                    HashMap<String, Number> timesync = new HashMap<String, Number>(4);
                    timesync.put("tc", tc);
                    timesync.put("ts", ts);
                    timesync.put("p", System.currentTimeMillis() - ts);
                    timesync.put("a", a);
                    extOut.put("timesync", timesync);
                }
            }
        }
        return true;
    }
}

