/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import java.io.IOException;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.handler.AbstractHandler;
import org.apache.felix.http.base.internal.handler.ServletConfigImpl;
import org.apache.felix.http.base.internal.handler.ServletHandlerRequest;
import org.apache.felix.http.base.internal.util.UriUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServletHandler
extends AbstractHandler
implements Comparable<ServletHandler> {
    private final String alias;
    private final Servlet servlet;

    public ServletHandler(ExtServletContext context, Servlet servlet, String alias, String name) {
        super(context, name);
        this.alias = alias;
        this.servlet = servlet;
    }

    @Override
    public int compareTo(ServletHandler other) {
        return other.alias.length() - this.alias.length();
    }

    public RequestDispatcher createNamedRequestDispatcher() {
        return new RequestDispatcherImpl();
    }

    public RequestDispatcher createRequestDispatcher(String path, String pathInContext, String query) {
        return new RequestDispatcherImpl(path, pathInContext, query);
    }

    @Override
    public void destroy() {
        this.servlet.destroy();
    }

    public String getAlias() {
        return this.alias;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public boolean handle(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = DispatcherType.INCLUDE == req.getDispatcherType() ? (String)req.getAttribute("javax.servlet.include.servlet_path") : (DispatcherType.FORWARD == req.getDispatcherType() ? (String)req.getAttribute("javax.servlet.forward.servlet_path") : (DispatcherType.ASYNC == req.getDispatcherType() ? (String)req.getAttribute("javax.servlet.async.path_info") : req.getPathInfo()));
        boolean matches = this.matches(path);
        if (matches) {
            this.doHandle(req, res);
        }
        return matches;
    }

    @Override
    public void init() throws ServletException {
        this.servlet.init(new ServletConfigImpl(this.getName(), this.getContext(), this.getInitParams()));
    }

    public boolean matches(String uri) {
        if (uri == null) {
            return this.alias.equals("/");
        }
        if (this.alias.equals("/")) {
            return uri.startsWith(this.alias);
        }
        return uri.equals(this.alias) || uri.startsWith(this.alias + "/");
    }

    final void doHandle(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (DispatcherType.REQUEST == req.getDispatcherType()) {
            req = new ServletHandlerRequest(req, this.getContext(), this.alias);
        }
        if (this.getContext().handleSecurity(req, res)) {
            this.servlet.service(req, res);
        } else if (!res.isCommitted() && res.getStatus() == 200) {
            res.sendError(403);
        }
    }

    @Override
    protected Object getSubject() {
        return this.servlet;
    }

    private static class ServletRequestWrapper
    extends HttpServletRequestWrapper {
        private final RequestDispatcherImpl dispatcher;
        private final DispatcherType type;

        public ServletRequestWrapper(HttpServletRequest req, RequestDispatcherImpl dispatcher, DispatcherType type) {
            super(req);
            this.dispatcher = dispatcher;
            this.type = type;
        }

        public Object getAttribute(String name) {
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            if (this.isInclusionDispatcher()) {
                if ("javax.servlet.include.request_uri".equals(name)) {
                    return UriUtils.concat(request.getContextPath(), this.dispatcher.requestURI);
                }
                if ("javax.servlet.include.context_path".equals(name)) {
                    return request.getContextPath();
                }
                if ("javax.servlet.include.servlet_path".equals(name)) {
                    return this.dispatcher.servletPath;
                }
                if ("javax.servlet.include.path_info".equals(name)) {
                    return this.dispatcher.pathInfo;
                }
                if ("javax.servlet.include.query_string".equals(name)) {
                    return this.dispatcher.query;
                }
            } else if (this.isForwardingDispatcher()) {
                if ("javax.servlet.forward.request_uri".equals(name)) {
                    return super.getRequestURI();
                }
                if ("javax.servlet.forward.context_path".equals(name)) {
                    return request.getContextPath();
                }
                if ("javax.servlet.forward.servlet_path".equals(name)) {
                    return super.getServletPath();
                }
                if ("javax.servlet.forward.path_info".equals(name)) {
                    return super.getPathInfo();
                }
                if ("javax.servlet.forward.query_string".equals(name)) {
                    return super.getQueryString();
                }
            }
            return super.getAttribute(name);
        }

        public DispatcherType getDispatcherType() {
            return this.type;
        }

        public String getPathInfo() {
            if (this.isForwardingDispatcher()) {
                return this.dispatcher.pathInfo;
            }
            return super.getPathInfo();
        }

        public String getRequestURI() {
            if (this.isForwardingDispatcher()) {
                return UriUtils.concat(this.getContextPath(), this.dispatcher.requestURI);
            }
            return super.getRequestURI();
        }

        public String getServletPath() {
            if (this.isForwardingDispatcher()) {
                return this.dispatcher.servletPath;
            }
            return super.getServletPath();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "->" + super.getRequest();
        }

        private boolean isForwardingDispatcher() {
            return DispatcherType.FORWARD == this.type && !this.dispatcher.isNamedDispatcher();
        }

        private boolean isInclusionDispatcher() {
            return DispatcherType.INCLUDE == this.type && !this.dispatcher.isNamedDispatcher();
        }
    }

    private class RequestDispatcherImpl
    implements RequestDispatcher {
        final String servletPath;
        final String requestURI;
        final String pathInfo;
        final String query;
        final boolean named;

        public RequestDispatcherImpl() {
            this.requestURI = null;
            this.servletPath = ServletHandler.this.getAlias();
            this.pathInfo = null;
            this.query = null;
            this.named = true;
        }

        public RequestDispatcherImpl(String uri, String pathInContext, String query) {
            this.requestURI = uri;
            this.servletPath = ServletHandler.this.getAlias();
            this.pathInfo = this.servletPath.equals(pathInContext) ? null : pathInContext;
            this.query = query;
            this.named = false;
        }

        public void forward(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            if (res.isCommitted()) {
                throw new ServletException("Response has been committed");
            }
            res.resetBuffer();
            ServletHandler.this.doHandle(new ServletRequestWrapper((HttpServletRequest)req, this, DispatcherType.FORWARD), (HttpServletResponse)res);
            if (!req.isAsyncStarted()) {
                res.flushBuffer();
                res.getWriter().close();
            }
        }

        public void include(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            ServletHandler.this.doHandle(new ServletRequestWrapper((HttpServletRequest)req, this, DispatcherType.INCLUDE), (HttpServletResponse)res);
        }

        boolean isNamedDispatcher() {
            return this.named;
        }
    }
}

