/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import java.io.IOException;
import java.io.InputStream;

public class NonCloseableStream
extends InputStream {
    private final InputStream m_input;
    private volatile boolean m_closed;

    public NonCloseableStream(InputStream input) {
        this.m_input = input;
    }

    public int available() throws IOException {
        return this.m_input.available();
    }

    public void close() throws IOException {
        this.assertOpen();
        this.m_closed = true;
    }

    public boolean equals(Object obj) {
        return this.m_input.equals(obj);
    }

    public int hashCode() {
        return this.m_input.hashCode();
    }

    public void mark(int readlimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        return this.m_input.read();
    }

    public int read(byte[] b) throws IOException {
        this.assertOpen();
        return this.m_input.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.assertOpen();
        return this.m_input.read(b, off, len);
    }

    public void reset() throws IOException {
        throw new IOException("Mark and reset are not available on this type of stream.");
    }

    public long skip(long n) throws IOException {
        return this.m_input.skip(n);
    }

    public String toString() {
        return this.m_input.toString();
    }

    private void assertOpen() throws IOException {
        if (this.m_closed) {
            throw new IOException("Unable to read, stream is closed.");
        }
    }
}

