/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deployment.rp.autoconf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.deployment.rp.autoconf.AutoConfResource;
import org.apache.felix.deployment.rp.autoconf.ConfigurationAdminTask;
import org.apache.felix.deployment.rp.autoconf.DeleteResourceTask;
import org.apache.felix.deployment.rp.autoconf.DropResourceTask;
import org.apache.felix.deployment.rp.autoconf.InstallOrUpdateResourceTask;
import org.apache.felix.deployment.rp.autoconf.MetaTypeUtil;
import org.apache.felix.deployment.rp.autoconf.ObjectClassDefinitionImpl;
import org.apache.felix.deployment.rp.autoconf.PersistencyManager;
import org.apache.felix.deployment.rp.autoconf.PostCommitTask;
import org.apache.felix.deployment.rp.autoconf.StoreResourceTask;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.metatype.Designate;
import org.apache.felix.metatype.DesignateObject;
import org.apache.felix.metatype.MetaData;
import org.apache.felix.metatype.MetaDataReader;
import org.apache.felix.metatype.OCD;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.deploymentadmin.spi.DeploymentSession;
import org.osgi.service.deploymentadmin.spi.ResourceProcessor;
import org.osgi.service.deploymentadmin.spi.ResourceProcessorException;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.service.metatype.ObjectClassDefinition;

public class AutoConfResourceProcessor
implements ResourceProcessor,
EventHandler {
    public static final String CONFIGURATION_ADMIN_FILTER_ATTRIBUTE = "filter";
    private static final String LOCATION_PREFIX = "osgi-dp:";
    private static final String EVENTTOPIC_COMPLETE = "org/osgi/service/deployment/COMPLETE";
    private volatile LogService m_log;
    private volatile MetaTypeService m_metaService;
    private volatile DependencyManager m_dm;
    private Component m_component;
    private PersistencyManager m_persistencyManager;
    private final Object m_lock = new Object();
    private final Map<String, List<AutoConfResource>> m_toBeInstalled;
    private final Map<String, List<AutoConfResource>> m_toBeDeleted;
    private final AtomicReference<DeploymentSession> m_sessionRef = new AtomicReference();
    private final List<ConfigurationAdminTask> m_configurationAdminTasks;
    private final List<PostCommitTask> m_postCommitTasks;

    public AutoConfResourceProcessor() {
        this.m_toBeInstalled = new HashMap<String, List<AutoConfResource>>();
        this.m_toBeDeleted = new HashMap<String, List<AutoConfResource>>();
        this.m_configurationAdminTasks = new ArrayList<ConfigurationAdminTask>();
        this.m_postCommitTasks = new ArrayList<PostCommitTask>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigurationAdmin(ServiceReference ref, ConfigurationAdmin ca) {
        ArrayList<ConfigurationAdminTask> configAdminTasks;
        this.m_log.log(4, "found configuration admin " + ref);
        Iterator iterator = this.m_lock;
        synchronized (iterator) {
            configAdminTasks = new ArrayList<ConfigurationAdminTask>(this.m_configurationAdminTasks);
        }
        for (ConfigurationAdminTask task : configAdminTasks) {
            try {
                Filter filter = task.getFilter();
                if (filter != null && (filter == null || !filter.match(ref))) continue;
                task.run(this.m_persistencyManager, ca);
            }
            catch (Exception e) {
                this.m_log.log(1, "Exception during configuration to " + ca + ". Trying to continue.", (Throwable)e);
            }
        }
        this.m_log.log(4, "found configuration admin " + ref + " done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin(DeploymentSession session) {
        this.m_log.log(4, "beginning session " + session);
        Object object = this.m_lock;
        synchronized (object) {
            DeploymentSession current = this.m_sessionRef.get();
            if (current != null) {
                throw new IllegalArgumentException("Trying to begin new deployment session while already in one.");
            }
            if (session == null) {
                throw new IllegalArgumentException("Trying to begin new deployment session with a null session.");
            }
            if (!(this.m_toBeInstalled.isEmpty() && this.m_toBeDeleted.isEmpty() && this.m_configurationAdminTasks.isEmpty() && this.m_postCommitTasks.isEmpty() && this.m_component == null)) {
                throw new IllegalStateException("State not reset correctly at start of session.");
            }
            this.m_sessionRef.set(session);
        }
    }

    public void cancel() {
        this.m_log.log(4, "cancel");
        this.rollback();
    }

    public void commit() {
        this.m_log.log(4, "commit");
        Properties properties = new Properties();
        ((Dictionary)properties).put("event.topics", EVENTTOPIC_COMPLETE);
        this.m_component = this.m_dm.createComponent().setInterface(EventHandler.class.getName(), (Dictionary)properties).setImplementation((Object)this).setCallbacks(null, null, null, null).setAutoConfig(Component.class, false).add(new Dependency[]{this.m_dm.createServiceDependency().setService(ConfigurationAdmin.class).setCallbacks("addConfigurationAdmin", null).setRequired(false)});
        this.m_dm.add(this.m_component);
        this.m_log.log(4, "commit done");
    }

    public void dropAllResources() throws ResourceProcessorException {
        this.m_log.log(4, "drop all resources");
        this.assertInDeploymentSession("Can not drop all resources without a Deployment Session");
        for (String name : this.m_persistencyManager.getResourceNames()) {
            this.dropped(name);
        }
        this.m_log.log(4, "drop all resources done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropped(String name) throws ResourceProcessorException {
        HashMap<String, List<AutoConfResource>> toBeDeleted;
        this.m_log.log(4, "dropped " + name);
        this.assertInDeploymentSession("Can not drop resource without a Deployment Session");
        Object object = this.m_lock;
        synchronized (object) {
            toBeDeleted = new HashMap<String, List<AutoConfResource>>(this.m_toBeDeleted);
        }
        try {
            List<AutoConfResource> resources = this.m_persistencyManager.load(name);
            if (!toBeDeleted.containsKey(name)) {
                toBeDeleted.put(name, new ArrayList());
            }
            ((List)toBeDeleted.get(name)).addAll(resources);
        }
        catch (IOException ioe) {
            throw new ResourceProcessorException(463, "Unable to drop resource: " + name, ioe);
        }
        object = this.m_lock;
        synchronized (object) {
            this.m_toBeDeleted.putAll(toBeDeleted);
        }
        this.m_log.log(4, "dropped " + name + " done");
    }

    public void handleEvent(Event event) {
        this.postcommit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postcommit() {
        ArrayList<PostCommitTask> postCommitTasks;
        this.m_log.log(4, "post commit");
        Iterator iterator = this.m_lock;
        synchronized (iterator) {
            postCommitTasks = new ArrayList<PostCommitTask>(this.m_postCommitTasks);
        }
        for (PostCommitTask task : postCommitTasks) {
            try {
                task.run(this.m_persistencyManager);
            }
            catch (Exception e) {
                this.m_log.log(1, "Exception during post commit wrap-up. Trying to continue.", (Throwable)e);
            }
        }
        this.endSession();
        this.m_log.log(4, "post commit done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws ResourceProcessorException {
        String name;
        HashMap<String, List<AutoConfResource>> toBeInstalled;
        HashMap<String, List<AutoConfResource>> toBeDeleted;
        this.m_log.log(4, "prepare");
        this.assertInDeploymentSession("Can not prepare resource without a Deployment Session");
        Object object = this.m_lock;
        synchronized (object) {
            toBeDeleted = new HashMap<String, List<AutoConfResource>>(this.m_toBeDeleted);
            toBeInstalled = new HashMap<String, List<AutoConfResource>>(this.m_toBeInstalled);
        }
        ArrayList<ConfigurationAdminTask> configAdminTasks = new ArrayList<ConfigurationAdminTask>();
        ArrayList<PostCommitTask> postCommitTasks = new ArrayList<PostCommitTask>();
        this.m_log.log(4, "prepare delete");
        for (Map.Entry entry : toBeDeleted.entrySet()) {
            name = (String)entry.getKey();
            for (AutoConfResource resource : (List)entry.getValue()) {
                configAdminTasks.add(new DropResourceTask(resource));
            }
            postCommitTasks.add(new DeleteResourceTask(name));
        }
        this.m_log.log(4, "prepare install/update");
        for (Map.Entry entry : toBeInstalled.entrySet()) {
            name = (String)entry.getKey();
            List<AutoConfResource> existingResources = null;
            try {
                existingResources = this.m_persistencyManager.load(name);
            }
            catch (IOException ioe) {
                throw new ResourceProcessorException(1, "Unable to read existing resources for resource " + name, ioe);
            }
            List resources = (List)entry.getValue();
            for (AutoConfResource resource : resources) {
                if (existingResources != null) {
                    Iterator<AutoConfResource> iter = existingResources.iterator();
                    while (iter.hasNext()) {
                        AutoConfResource existing = iter.next();
                        if (!existing.equalsTargetConfiguration(resource)) continue;
                        iter.remove();
                    }
                }
                configAdminTasks.add(new InstallOrUpdateResourceTask(resource));
            }
            for (AutoConfResource existingResource : existingResources) {
                configAdminTasks.add(new DropResourceTask(existingResource));
            }
            postCommitTasks.add(new StoreResourceTask(name, resources));
        }
        Object object2 = this.m_lock;
        synchronized (object2) {
            this.m_configurationAdminTasks.addAll(configAdminTasks);
            this.m_postCommitTasks.addAll(postCommitTasks);
        }
        this.m_log.log(4, "prepare done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String name, InputStream stream) throws ResourceProcessorException {
        List designates;
        HashMap<String, List<AutoConfResource>> toBeInstalled;
        this.m_log.log(4, "processing " + name);
        this.assertInDeploymentSession("Can not process resource without a Deployment Session");
        Object object = this.m_lock;
        synchronized (object) {
            toBeInstalled = new HashMap<String, List<AutoConfResource>>(this.m_toBeInstalled);
        }
        MetaData data = this.parseAutoConfResource(stream);
        Filter filter = this.getFilter(data);
        if (!toBeInstalled.containsKey(name)) {
            toBeInstalled.put(name, new ArrayList());
        }
        if ((designates = data.getDesignates()) == null || designates.isEmpty()) {
            this.m_log.log(3, "No designates found in the resource, so there's nothing to process.");
            return;
        }
        Map localOcds = data.getObjectClassDefinitions();
        if (localOcds == null) {
            localOcds = Collections.emptyMap();
        }
        for (Designate designate : designates) {
            DesignateObject objectDef = designate.getObject();
            if (objectDef == null) {
                throw new ResourceProcessorException(463, "Designate Object child missing or invalid");
            }
            if (objectDef.getAttributes() == null || objectDef.getAttributes().isEmpty()) {
                throw new ResourceProcessorException(463, "Object Attributes child missing or invalid");
            }
            String ocdRef = objectDef.getOcdRef();
            if (ocdRef == null || "".equals(ocdRef)) {
                throw new ResourceProcessorException(463, "Object ocdRef attribute missing or invalid");
            }
            ObjectClassDefinition ocd = null;
            OCD localOcd = (OCD)localOcds.get(ocdRef);
            ObjectClassDefinition objectClassDefinition = ocd = localOcd != null ? new ObjectClassDefinitionImpl(localOcd) : this.getMetaTypeOCD(data, designate);
            if (ocd == null) {
                throw new ResourceProcessorException(463, "No Object Class Definition found with id=" + ocdRef);
            }
            Dictionary dict = MetaTypeUtil.getProperties(designate, ocd);
            if (dict == null) continue;
            AutoConfResource resource = new AutoConfResource(name, designate.getPid(), designate.getFactoryPid(), designate.getBundleLocation(), designate.isMerge(), dict, filter);
            ((List)toBeInstalled.get(name)).add(resource);
        }
        Object object2 = this.m_lock;
        synchronized (object2) {
            this.m_toBeInstalled.putAll(toBeInstalled);
        }
        this.m_log.log(4, "processing " + name + " done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        HashMap<String, List<AutoConfResource>> toBeInstalled;
        this.m_log.log(4, "rollback");
        Iterator iterator = this.m_lock;
        synchronized (iterator) {
            toBeInstalled = new HashMap<String, List<AutoConfResource>>(this.m_toBeInstalled);
        }
        for (Map.Entry entry : toBeInstalled.entrySet()) {
            Iterator iterator2 = ((List)entry.getValue()).iterator();
            if (!iterator2.hasNext()) continue;
            AutoConfResource resource = (AutoConfResource)iterator2.next();
            String name = resource.getName();
            try {
                this.dropped(name);
            }
            catch (ResourceProcessorException e) {
                this.m_log.log(1, "Unable to roll back resource '" + name + "', reason: " + e.getMessage() + ", caused by: " + e.getCause().getMessage());
            }
        }
        this.endSession();
        this.m_log.log(4, "rollback done");
    }

    public void start() throws IOException {
        File root = this.m_dm.getBundleContext().getDataFile("");
        if (root == null) {
            throw new IOException("No file system support");
        }
        this.m_persistencyManager = new PersistencyManager(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertInDeploymentSession(String msg) throws ResourceProcessorException {
        Object object = this.m_lock;
        synchronized (object) {
            DeploymentSession current = this.m_sessionRef.get();
            if (current == null) {
                throw new ResourceProcessorException(463, msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endSession() {
        if (this.m_component != null) {
            this.m_dm.remove(this.m_component);
            this.m_component = null;
        }
        Object object = this.m_lock;
        synchronized (object) {
            this.m_toBeInstalled.clear();
            this.m_toBeDeleted.clear();
            this.m_postCommitTasks.clear();
            this.m_configurationAdminTasks.clear();
            this.m_sessionRef.set(null);
        }
    }

    private Bundle getBundle(String bundleLocation, boolean isFactory) throws ResourceProcessorException {
        Bundle bundle;
        block2: {
            block1: {
                bundle = null;
                if (isFactory) break block1;
                if (!bundleLocation.startsWith(LOCATION_PREFIX)) break block2;
                DeploymentSession session = this.m_sessionRef.get();
                bundle = session.getSourceDeploymentPackage().getBundle(bundleLocation.substring(LOCATION_PREFIX.length()));
                break block2;
            }
            Bundle[] bundles = this.m_dm.getBundleContext().getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                String location = bundles[i].getLocation();
                if (!bundleLocation.equals(location)) continue;
                bundle = bundles[i];
                break;
            }
        }
        return bundle;
    }

    private Filter getFilter(MetaData data) throws ResourceProcessorException {
        Map optionalAttributes = data.getOptionalAttributes();
        if (optionalAttributes != null) {
            try {
                return FrameworkUtil.createFilter((String)((String)optionalAttributes.get(CONFIGURATION_ADMIN_FILTER_ATTRIBUTE)));
            }
            catch (InvalidSyntaxException e) {
                throw new ResourceProcessorException(463, "Unable to create filter!", e);
            }
        }
        return null;
    }

    private ObjectClassDefinition getMetaTypeOCD(MetaData data, Designate designate) throws ResourceProcessorException {
        String pid;
        boolean isFactoryConfig = this.isFactoryConfig(designate);
        Bundle bundle = this.getBundle(designate.getBundleLocation(), isFactoryConfig);
        if (bundle == null) {
            return null;
        }
        MetaTypeInformation mti = this.m_metaService.getMetaTypeInformation(bundle);
        if (mti == null) {
            return null;
        }
        pid = isFactoryConfig ? (pid = designate.getFactoryPid()) : designate.getPid();
        try {
            ObjectClassDefinition tempOcd = mti.getObjectClassDefinition(pid, null);
            String ocdRef = designate.getObject().getOcdRef();
            if (ocdRef.equals(tempOcd.getID())) {
                return tempOcd;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    private boolean isFactoryConfig(Designate designate) {
        String factoryPid = designate.getFactoryPid();
        return factoryPid != null && !"".equals(factoryPid);
    }

    private MetaData parseAutoConfResource(InputStream stream) throws ResourceProcessorException {
        MetaDataReader reader = new MetaDataReader();
        MetaData data = null;
        try {
            data = reader.parse(stream);
        }
        catch (IOException e) {
            throw new ResourceProcessorException(463, "Unable to process resource.", e);
        }
        if (data == null) {
            throw new ResourceProcessorException(463, "Supplied configuration is not conform the metatype xml specification.");
        }
        return data;
    }
}

