/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.utils.core;

import aQute.bnd.annotation.spi.ServiceProvider;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.felix.atomos.utils.api.Launcher;
import org.apache.felix.atomos.utils.api.LauncherBuilder;
import org.apache.felix.atomos.utils.api.plugin.SubstratePlugin;
import org.apache.felix.atomos.utils.core.LauncherImpl;
import org.osgi.util.converter.Converter;
import org.osgi.util.converter.Converters;

@ServiceProvider(value=LauncherBuilder.class)
public class LauncherBuilderImpl
implements LauncherBuilder {
    private final Converter converter = Converters.standardConverter();
    private final Collection<SubstratePlugin<?>> plugins = new HashSet();

    private void addInitPlugins(Class<? extends SubstratePlugin<?>> pluginClass, Object cfg) {
        try {
            SubstratePlugin<?> plugin = pluginClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Optional<Method> oMethod = Stream.of(plugin.getClass().getMethods()).filter(m -> m.getName().equals("init")).filter(m -> m.getParameterCount() == 1).filter(m -> m.getParameterTypes()[0] != Object.class).findAny();
            if (oMethod.isPresent()) {
                Method method = oMethod.get();
                Object config = this.converter.convert(cfg).to(method.getParameterTypes()[0]);
                method.invoke(plugin, config);
                this.plugins.add(plugin);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LauncherBuilder addPlugin(Class<? extends SubstratePlugin<?>> pluginClass, Map<String, Object> cfgMap) {
        this.addInitPlugins(pluginClass, cfgMap);
        return this;
    }

    public <C> LauncherBuilder addPlugin(Class<? extends SubstratePlugin<C>> pluginClass, C cfg) {
        this.addInitPlugins(pluginClass, cfg);
        return this;
    }

    public LauncherBuilder addPlugin(String pluginClassName, Map<String, Object> cfgMap) {
        Optional<Class<SubstratePlugin<?>>> optional = this.loadPluginClass(pluginClassName);
        if (optional.isPresent()) {
            this.addPlugin((Class)optional.get(), (Object)cfgMap);
        }
        return this;
    }

    public <C> LauncherBuilder addPlugin(SubstratePlugin<C> plugin, C cfg) {
        plugin.init(cfg);
        this.plugins.add(plugin);
        return this;
    }

    public Launcher build() {
        return new LauncherImpl(this.plugins);
    }

    Optional<Class<? extends SubstratePlugin<?>>> loadPluginClass(String className) {
        if (className != null && !className.isEmpty()) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(className);
                if (Stream.of(clazz.getGenericInterfaces()).filter(SubstratePlugin.class::isInstance).findAny().isPresent()) {
                    return Optional.of(clazz);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return Optional.empty();
    }
}

