/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.proxy;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Stack;
import org.apache.aries.blueprint.Interceptor;
import org.apache.aries.blueprint.proxy.AsmInterceptorWrapper;
import org.apache.aries.blueprint.proxy.WrapperedObject;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Collaborator
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = -58189302118314469L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Collaborator.class);
    final InvocationHandler delegate;
    final Object object;
    private transient List<Interceptor> interceptors = null;
    private transient ComponentMetadata cm = null;
    private transient boolean sorted = false;

    Collaborator(ComponentMetadata cm, List<Interceptor> interceptors, Object delegateObj) {
        this.cm = cm;
        this.object = delegateObj;
        this.delegate = new InvocationHandler(){

            private void onUnexpectedException(Throwable cause) {
                throw new Error("Unreachable catch statement reached", cause);
            }

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object result;
                try {
                    result = method.invoke(Collaborator.this.object, args);
                }
                catch (InvocationTargetException ite) {
                    throw ite.getCause();
                }
                catch (IllegalAccessException e) {
                    this.onUnexpectedException(e);
                    return null;
                }
                catch (IllegalArgumentException e) {
                    this.onUnexpectedException(e);
                    return null;
                }
                catch (SecurityException e) {
                    this.onUnexpectedException(e);
                    return null;
                }
                return result;
            }
        };
        this.interceptors = interceptors;
    }

    private void preCallInterceptor(List<Interceptor> interceptorList, ComponentMetadata cm, Method m, Object[] parameters, Stack<StackElement> calledInterceptors) throws Throwable {
        if (this.interceptors != null && !this.interceptors.isEmpty()) {
            for (Interceptor im : interceptorList) {
                StackElement se = new StackElement(im);
                calledInterceptors.push(se);
                se.setPreCallToken(im.preCall(cm, m, parameters));
            }
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object toReturn = null;
        if (method.getName().equals("unwrapObject") && method.getDeclaringClass() == WrapperedObject.class) {
            toReturn = this.object;
        } else if (method.getName().equals("equals") && method.getDeclaringClass() == Object.class) {
            if (args[0] instanceof WrapperedObject) {
                args[0] = ((WrapperedObject)args[0]).unwrapObject();
            } else if (AsmInterceptorWrapper.isProxyClass(args[0].getClass())) {
                args[0] = AsmInterceptorWrapper.unwrapObject(args[0]);
            }
            toReturn = this.delegate.invoke(proxy, method, args);
        } else if (method.getName().equals("finalize") && method.getParameterTypes().length == 0) {
            toReturn = null;
        } else {
            Stack<StackElement> calledInterceptors = new Stack<StackElement>();
            boolean inInvoke = false;
            try {
                this.preCallInterceptor(this.interceptors, this.cm, method, args, calledInterceptors);
                inInvoke = true;
                toReturn = this.delegate.invoke(proxy, method, args);
                inInvoke = false;
                this.postCallInterceptorWithReturn(this.cm, method, toReturn, calledInterceptors);
            }
            catch (Throwable e) {
                Throwable exceptionToRethrow;
                block17: {
                    LOGGER.error("invoke", e);
                    exceptionToRethrow = null;
                    if (!inInvoke) {
                        exceptionToRethrow = e;
                    } else if (!(e instanceof RuntimeException)) {
                        exceptionToRethrow = e;
                    }
                    try {
                        this.postCallInterceptorWithException(this.cm, method, e, calledInterceptors);
                    }
                    catch (Exception f) {
                        if (exceptionToRethrow != null) break block17;
                        exceptionToRethrow = f;
                    }
                }
                if (exceptionToRethrow == null) {
                    exceptionToRethrow = e;
                }
                throw exceptionToRethrow;
            }
        }
        return toReturn;
    }

    private void postCallInterceptorWithReturn(ComponentMetadata cm, Method method, Object returnType, Stack<StackElement> calledInterceptors) throws Throwable {
        while (!calledInterceptors.isEmpty()) {
            StackElement se = calledInterceptors.pop();
            try {
                se.interceptor.postCallWithReturn(cm, method, returnType, se.getPreCallToken());
            }
            catch (Throwable t) {
                LOGGER.error("postCallInterceptorWithReturn", t);
                throw t;
            }
        }
    }

    private void postCallInterceptorWithException(ComponentMetadata cm, Method method, Throwable exception, Stack<StackElement> calledInterceptors) throws Throwable {
        Throwable tobeRethrown = null;
        while (!calledInterceptors.isEmpty()) {
            StackElement se = calledInterceptors.pop();
            try {
                se.interceptor.postCallWithException(cm, method, exception, se.getPreCallToken());
            }
            catch (Throwable t) {
                LOGGER.error("postCallInterceptorWithException", t);
                if (tobeRethrown != null) continue;
                tobeRethrown = t;
            }
        }
        if (tobeRethrown != null) {
            throw tobeRethrown;
        }
    }

    private static class StackElement {
        private Interceptor interceptor;
        private Object preCallToken;

        private StackElement(Interceptor i) {
            this.interceptor = i;
        }

        private void setPreCallToken(Object preCallToken) {
            this.preCallToken = preCallToken;
        }

        private Object getPreCallToken() {
            return this.preCallToken;
        }
    }
}

