/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.main;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class StringMap
extends TreeMap {
    public StringMap() {
        this(true);
    }

    public StringMap(boolean caseSensitive) {
        super(new StringComparator(caseSensitive));
    }

    public StringMap(Map map, boolean caseSensitive) {
        this(caseSensitive);
        this.putAll(map);
    }

    public Object put(Object key, Object value) {
        return super.put(key.toString(), value);
    }

    public boolean isCaseSensitive() {
        return ((StringComparator)this.comparator()).isCaseSensitive();
    }

    public void setCaseSensitive(boolean b) {
        ((StringComparator)this.comparator()).setCaseSensitive(b);
    }

    private static class StringComparator
    implements Comparator {
        private boolean m_isCaseSensitive = true;

        public StringComparator(boolean b) {
            this.m_isCaseSensitive = b;
        }

        public int compare(Object o1, Object o2) {
            if (this.m_isCaseSensitive) {
                return o1.toString().compareTo(o2.toString());
            }
            return o1.toString().compareToIgnoreCase(o2.toString());
        }

        public boolean isCaseSensitive() {
            return this.m_isCaseSensitive;
        }

        public void setCaseSensitive(boolean b) {
            this.m_isCaseSensitive = b;
        }
    }
}

