/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.main;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.felix.karaf.main.Main;
import org.apache.felix.karaf.main.Utils;

public class Stop {
    public static void main(String[] args) throws Exception {
        File karafHome = Utils.getKarafHome();
        File karafBase = Utils.getKarafBase(karafHome);
        System.setProperty("karaf.home", karafHome.getPath());
        System.setProperty("karaf.base", karafBase.getPath());
        Main.loadSystemProperties(karafBase);
        File file = new File(new File(karafBase, "etc"), "config.properties");
        URL configPropURL = file.toURI().toURL();
        Properties props = Main.loadPropertiesFile(configPropURL);
        Main.copySystemProperties(props);
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            props.setProperty(name, Main.substVars(props.getProperty(name), name, null, props));
        }
        int port = Integer.parseInt(props.getProperty("karaf.shutdown.port", "0"));
        String host = props.getProperty("karaf.shutdown.host", "localhost");
        String portFile = props.getProperty("karaf.shutdown.port.file");
        String shutdown = props.getProperty("karaf.shutdown.command", "SHUTDOWN");
        if (port == 0 && portFile != null) {
            BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(portFile)));
            String portStr = r.readLine();
            port = Integer.parseInt(portStr);
            r.close();
        }
        if (port > 0) {
            Socket s = new Socket(host, port);
            s.getOutputStream().write(shutdown.getBytes());
            s.close();
        } else {
            System.err.println("Unable to find port...");
        }
    }
}

