/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.codec;

import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.apache.aries.jmx.util.FrameworkUtils;
import org.apache.aries.jmx.util.TypeUtils;
import org.osgi.framework.ServiceReference;
import org.osgi.jmx.framework.ServiceStateMBean;

public class ServiceData {
    private long serviceId;
    private long bundleId;
    private String[] serviceInterfaces;
    private long[] usingBundles;

    private ServiceData() {
    }

    public ServiceData(ServiceReference serviceReference) throws IllegalArgumentException {
        if (serviceReference == null) {
            throw new IllegalArgumentException("Argument serviceReference cannot be null");
        }
        this.serviceId = (Long)serviceReference.getProperty("service.id");
        this.bundleId = serviceReference.getBundle().getBundleId();
        this.serviceInterfaces = (String[])serviceReference.getProperty("objectClass");
        this.usingBundles = FrameworkUtils.getBundleIds(serviceReference.getUsingBundles());
    }

    public CompositeData toCompositeData() {
        CompositeDataSupport result = null;
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("Identifier", this.serviceId);
        items.put("BundleIdentifier", this.bundleId);
        items.put("objectClass", this.serviceInterfaces);
        items.put("UsingBundles", TypeUtils.toLong(this.usingBundles));
        try {
            result = new CompositeDataSupport(ServiceStateMBean.SERVICE_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Failed to create CompositeData for ServiceReference with service.id [" + this.serviceId + "]", e);
        }
        return result;
    }

    public static ServiceData from(CompositeData compositeData) {
        if (compositeData == null) {
            throw new IllegalArgumentException("Argument compositeData cannot be null");
        }
        if (!compositeData.getCompositeType().equals(ServiceStateMBean.SERVICE_TYPE)) {
            throw new IllegalArgumentException("Invalid CompositeType [" + compositeData.getCompositeType() + "]");
        }
        ServiceData serviceData = new ServiceData();
        serviceData.serviceId = (Long)compositeData.get("Identifier");
        serviceData.bundleId = (Long)compositeData.get("BundleIdentifier");
        serviceData.serviceInterfaces = (String[])compositeData.get("objectClass");
        serviceData.usingBundles = TypeUtils.toPrimitive((Long[])compositeData.get("UsingBundles"));
        return serviceData;
    }

    public long getServiceId() {
        return this.serviceId;
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public String[] getServiceInterfaces() {
        return this.serviceInterfaces;
    }

    public long[] getUsingBundles() {
        return this.usingBundles;
    }
}

