/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.studio.common.ui.dialogs.MessageDialogWithTextarea;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.view.wizards.MergeSchemasOptionsWizardPage;
import org.apache.directory.studio.schemaeditor.view.wizards.MergeSchemasSelectionWizardPage;
import org.apache.directory.studio.schemaeditor.view.wizards.Messages;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class MergeSchemasWizard
extends Wizard
implements IImportWizard {
    private MergeSchemasSelectionWizardPage selectionPage;
    private MergeSchemasOptionsWizardPage optionsPage;

    public void addPages() {
        this.selectionPage = new MergeSchemasSelectionWizardPage();
        this.optionsPage = new MergeSchemasOptionsWizardPage();
        this.addPage((IWizardPage)this.selectionPage);
        this.addPage((IWizardPage)this.optionsPage);
    }

    public boolean performFinish() {
        Object[] sourceObjects = this.selectionPage.getSelectedObjects();
        boolean replaceUnknownSyntax = this.optionsPage.isReplaceUnknownSyntax();
        boolean mergeDependencies = this.optionsPage.isMergeDependencies();
        boolean pullUpAttributes = this.optionsPage.isPullUpAttributes();
        ArrayList<String> errorMessages = new ArrayList<String>();
        this.mergeObjects(sourceObjects, errorMessages, replaceUnknownSyntax, mergeDependencies, pullUpAttributes);
        if (!errorMessages.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String errorMessage : errorMessages) {
                sb.append(errorMessage);
                sb.append('\n');
            }
            new MessageDialogWithTextarea(this.getShell(), Messages.getString("MergeSchemasWizard.MergeResultTitle"), Messages.getString("MergeSchemasWizard.MergeResultMessage"), sb.toString()).open();
        }
        return true;
    }

    private void mergeObjects(Object[] sourceObjects, List<String> errorMessages, boolean replaceUnknownSyntax, boolean mergeDependencies, boolean pullUpAttributes) {
        HashSet<Object> processedObjects = new HashSet<Object>();
        HashMap<String, Schema> targetSchemas = new HashMap<String, Schema>();
        Project targetProject = Activator.getDefault().getProjectsHandler().getOpenProject();
        Object[] objectArray = sourceObjects;
        int n = sourceObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Schema targetSchema;
            Object sourceObject = objectArray[n2];
            if (sourceObject instanceof Project) {
                Project sourceProject = (Project)sourceObject;
                for (Schema sourceSchema : sourceProject.getSchemaHandler().getSchemas()) {
                    Schema targetSchema2 = this.getTargetSchema(sourceSchema.getProject(), targetProject, targetSchemas);
                    this.mergeSchema(sourceSchema, targetProject, targetSchema2, processedObjects, errorMessages, replaceUnknownSyntax, mergeDependencies, pullUpAttributes);
                }
            }
            if (sourceObject instanceof Schema) {
                Schema sourceSchema = (Schema)((Object)sourceObject);
                targetSchema = this.getTargetSchema(sourceSchema.getProject(), targetProject, targetSchemas);
                this.mergeSchema(sourceSchema, targetProject, targetSchema, processedObjects, errorMessages, replaceUnknownSyntax, mergeDependencies, pullUpAttributes);
            }
            if (sourceObject instanceof MergeSchemasSelectionWizardPage.AttributeTypeFolder) {
                MergeSchemasSelectionWizardPage.AttributeTypeFolder atf = (MergeSchemasSelectionWizardPage.AttributeTypeFolder)sourceObject;
                targetSchema = this.getTargetSchema(atf.schema.getProject(), targetProject, targetSchemas);
                List<AttributeType> sourceAttributeTypes = atf.schema.getAttributeTypes();
                for (AttributeType sourceAttributeType : sourceAttributeTypes) {
                    this.mergeAttributeType(sourceAttributeType, targetProject, targetSchema, processedObjects, errorMessages, replaceUnknownSyntax, mergeDependencies, pullUpAttributes);
                }
            }
            if (sourceObject instanceof MergeSchemasSelectionWizardPage.ObjectClassFolder) {
                MergeSchemasSelectionWizardPage.ObjectClassFolder ocf = (MergeSchemasSelectionWizardPage.ObjectClassFolder)sourceObject;
                targetSchema = this.getTargetSchema(ocf.schema.getProject(), targetProject, targetSchemas);
                List<ObjectClass> sourceObjectClasses = ocf.schema.getObjectClasses();
                for (ObjectClass sourceObjectClass : sourceObjectClasses) {
                    this.mergeObjectClass(sourceObjectClass, targetProject, targetSchema, processedObjects, errorMessages, replaceUnknownSyntax, mergeDependencies, pullUpAttributes);
                }
            }
            if (sourceObject instanceof MergeSchemasSelectionWizardPage.AttributeTypeWrapper) {
                MergeSchemasSelectionWizardPage.AttributeTypeWrapper atw = (MergeSchemasSelectionWizardPage.AttributeTypeWrapper)sourceObject;
                targetSchema = this.getTargetSchema(atw.folder.schema.getProject(), targetProject, targetSchemas);
                this.mergeAttributeType(atw.attributeType, targetProject, targetSchema, processedObjects, errorMessages, replaceUnknownSyntax, mergeDependencies, pullUpAttributes);
            }
            if (sourceObject instanceof MergeSchemasSelectionWizardPage.ObjectClassWrapper) {
                MergeSchemasSelectionWizardPage.ObjectClassWrapper ocw = (MergeSchemasSelectionWizardPage.ObjectClassWrapper)sourceObject;
                targetSchema = this.getTargetSchema(ocw.folder.schema.getProject(), targetProject, targetSchemas);
                this.mergeObjectClass(ocw.objectClass, targetProject, targetSchema, processedObjects, errorMessages, replaceUnknownSyntax, mergeDependencies, pullUpAttributes);
            }
            ++n2;
        }
        for (Schema targetSchema : targetSchemas.values()) {
            if (targetProject.getSchemaHandler().getSchemas().contains((Object)targetSchema)) continue;
            targetProject.getSchemaHandler().addSchema(targetSchema);
        }
    }

    private Schema getTargetSchema(Project sourceProject, Project targetProject, Map<String, Schema> targetSchemas) {
        String targetSchemaName = "merge-from-" + sourceProject.getName();
        Schema targetSchema = targetProject.getSchemaHandler().getSchema(targetSchemaName);
        if (targetSchema != null) {
            targetProject.getSchemaHandler().removeSchema(targetSchema);
        } else if (targetSchemas.containsKey(targetSchemaName)) {
            targetSchema = targetSchemas.get(targetSchemaName);
        } else {
            targetSchema = new Schema(targetSchemaName);
            targetSchema.setProject(targetProject);
        }
        targetSchemas.put(targetSchemaName, targetSchema);
        return targetSchema;
    }

    private void mergeSchema(Schema sourceSchema, Project targetProject, Schema targetSchema, Set<Object> processedObjects, List<String> errorMessages, boolean replaceUnknownSyntax, boolean mergeDependencies, boolean pullUpAttributes) {
        List<AttributeType> sourceAttributeTypes = sourceSchema.getAttributeTypes();
        for (AttributeType sourceAttributeType : sourceAttributeTypes) {
            this.mergeAttributeType(sourceAttributeType, targetProject, targetSchema, processedObjects, errorMessages, replaceUnknownSyntax, mergeDependencies, pullUpAttributes);
        }
        List<ObjectClass> sourceObjectClasses = sourceSchema.getObjectClasses();
        for (ObjectClass sourceObjectClass : sourceObjectClasses) {
            this.mergeObjectClass(sourceObjectClass, targetProject, targetSchema, processedObjects, errorMessages, replaceUnknownSyntax, mergeDependencies, pullUpAttributes);
        }
    }

    private void mergeAttributeType(AttributeType sourceAttributeType, Project targetProject, Schema targetSchema, Set<Object> processedObjects, List<String> errorMessages, boolean replaceUnknownSyntax, boolean mergeDependencies, boolean pullUpAttributes) {
        boolean oidOrAliasAlreadyTaken;
        if (processedObjects.contains(sourceAttributeType)) {
            return;
        }
        processedObjects.add(sourceAttributeType);
        AttributeType targetAttributeType = targetProject.getSchemaHandler().getAttributeType(sourceAttributeType.getOid());
        if (targetAttributeType == null) {
            for (String name : sourceAttributeType.getNames()) {
                targetAttributeType = targetProject.getSchemaHandler().getAttributeType(name);
                if (targetAttributeType != null) break;
            }
        }
        if (!(oidOrAliasAlreadyTaken = targetProject.getSchemaHandler().isOidAlreadyTaken(sourceAttributeType.getOid()))) {
            for (String name : sourceAttributeType.getNames()) {
                oidOrAliasAlreadyTaken = targetProject.getSchemaHandler().isAliasAlreadyTakenForAttributeType(name);
                if (oidOrAliasAlreadyTaken) break;
            }
        }
        if (targetAttributeType != null) {
            errorMessages.add(NLS.bind((String)Messages.getString("MergeSchemasWizard.AttributeTypeExistsInTargetProject"), (Object)this.getIdString((AbstractSchemaObject)sourceAttributeType)));
        } else if (oidOrAliasAlreadyTaken) {
            errorMessages.add(NLS.bind((String)Messages.getString("MergeSchemasWizard.OidOrAliasAlreadyTaken"), (Object)this.getIdString((AbstractSchemaObject)sourceAttributeType)));
        } else {
            AttributeType superiorAttributeType;
            String superiorName;
            AttributeType at = targetSchema.getAttributeType(sourceAttributeType.getOid());
            if (at != null) {
                targetSchema.removeAttributeType(at);
            }
            AttributeType clonedAttributeType = new AttributeType(sourceAttributeType.getOid());
            clonedAttributeType.setNames(sourceAttributeType.getNames());
            clonedAttributeType.setDescription(sourceAttributeType.getDescription());
            clonedAttributeType.setSuperiorOid(sourceAttributeType.getSuperiorOid());
            clonedAttributeType.setUsage(sourceAttributeType.getUsage());
            clonedAttributeType.setSyntaxOid(sourceAttributeType.getSyntaxOid());
            clonedAttributeType.setSyntaxLength(sourceAttributeType.getSyntaxLength());
            clonedAttributeType.setObsolete(sourceAttributeType.isObsolete());
            clonedAttributeType.setCollective(sourceAttributeType.isCollective());
            clonedAttributeType.setSingleValued(sourceAttributeType.isSingleValued());
            clonedAttributeType.setUserModifiable(sourceAttributeType.isUserModifiable());
            clonedAttributeType.setEqualityOid(sourceAttributeType.getEqualityOid());
            clonedAttributeType.setOrderingOid(sourceAttributeType.getOrderingOid());
            clonedAttributeType.setSubstringOid(sourceAttributeType.getSubstringOid());
            clonedAttributeType.setSchemaName(targetSchema.getSchemaName());
            if (replaceUnknownSyntax && (clonedAttributeType.getSyntaxOid() == null || targetProject.getSchemaHandler().getSyntax(clonedAttributeType.getSyntaxOid()) == null)) {
                errorMessages.add(NLS.bind((String)Messages.getString("MergeSchemasWizard.ReplacedSyntax"), (Object[])new String[]{this.getIdString((AbstractSchemaObject)sourceAttributeType), clonedAttributeType.getSyntaxOid(), "1.3.6.1.4.1.1466.115.121.1.15 (Directory String)"}));
                clonedAttributeType.setSyntaxOid("1.3.6.1.4.1.1466.115.121.1.15");
                clonedAttributeType.setEqualityOid("caseIgnoreMatch");
                clonedAttributeType.setOrderingOid(null);
                clonedAttributeType.setSubstringOid("caseIgnoreSubstringsMatch");
            }
            if (mergeDependencies && (superiorName = clonedAttributeType.getSuperiorOid()) != null && (superiorAttributeType = Activator.getDefault().getSchemaHandler().getAttributeType(superiorName)) != null) {
                this.mergeAttributeType(superiorAttributeType, targetProject, targetSchema, processedObjects, errorMessages, replaceUnknownSyntax, mergeDependencies, pullUpAttributes);
            }
            targetSchema.addAttributeType(clonedAttributeType);
        }
    }

    private void mergeObjectClass(ObjectClass sourceObjectClass, Project targetProject, Schema targetSchema, Set<Object> processedObjects, List<String> errorMessages, boolean replaceUnknownSyntax, boolean mergeDependencies, boolean pullUpAttributes) {
        boolean oidOrAliasAlreadyTaken;
        if (processedObjects.contains(sourceObjectClass)) {
            return;
        }
        processedObjects.add(sourceObjectClass);
        ObjectClass targetObjectClass = targetProject.getSchemaHandler().getObjectClass(sourceObjectClass.getOid());
        if (targetObjectClass == null) {
            for (String name : sourceObjectClass.getNames()) {
                targetObjectClass = targetProject.getSchemaHandler().getObjectClass(name);
                if (targetObjectClass != null) break;
            }
        }
        if (!(oidOrAliasAlreadyTaken = targetProject.getSchemaHandler().isOidAlreadyTaken(sourceObjectClass.getOid()))) {
            for (String name : sourceObjectClass.getNames()) {
                oidOrAliasAlreadyTaken = targetProject.getSchemaHandler().isAliasAlreadyTakenForObjectClass(name);
                if (oidOrAliasAlreadyTaken) break;
            }
        }
        if (targetObjectClass != null) {
            errorMessages.add(NLS.bind((String)Messages.getString("MergeSchemasWizard.ObjectClassExistsInTargetProject"), (Object)this.getIdString((AbstractSchemaObject)sourceObjectClass)));
        } else if (oidOrAliasAlreadyTaken) {
            errorMessages.add(NLS.bind((String)Messages.getString("MergeSchemasWizard.OidOrAliasAlreadyTaken"), (Object)this.getIdString((AbstractSchemaObject)sourceObjectClass)));
        } else {
            ObjectClass oc = targetSchema.getObjectClass(sourceObjectClass.getOid());
            if (oc != null) {
                targetSchema.removeObjectClass(oc);
            }
            ObjectClass clonedObjectClass = new ObjectClass(sourceObjectClass.getOid());
            clonedObjectClass.setOid(sourceObjectClass.getOid());
            clonedObjectClass.setNames(sourceObjectClass.getNames());
            clonedObjectClass.setDescription(sourceObjectClass.getDescription());
            clonedObjectClass.setSuperiorOids(sourceObjectClass.getSuperiorOids());
            clonedObjectClass.setType(sourceObjectClass.getType());
            clonedObjectClass.setObsolete(sourceObjectClass.isObsolete());
            clonedObjectClass.setMustAttributeTypeOids(sourceObjectClass.getMustAttributeTypeOids());
            clonedObjectClass.setMayAttributeTypeOids(sourceObjectClass.getMayAttributeTypeOids());
            clonedObjectClass.setSchemaName(targetSchema.getSchemaName());
            if (mergeDependencies) {
                List superClassesNames = clonedObjectClass.getSuperiorOids();
                if (superClassesNames != null) {
                    for (String superClassName : superClassesNames) {
                        if (superClassName == null) continue;
                        ObjectClass superSourceObjectClass = Activator.getDefault().getSchemaHandler().getObjectClass(superClassName);
                        ObjectClass superTargetObjectClass = targetProject.getSchemaHandler().getObjectClass(superClassName);
                        if (superSourceObjectClass == null) continue;
                        if (superTargetObjectClass == null) {
                            this.mergeObjectClass(superSourceObjectClass, targetProject, targetSchema, processedObjects, errorMessages, replaceUnknownSyntax, mergeDependencies, pullUpAttributes);
                            continue;
                        }
                        if (!pullUpAttributes) continue;
                        this.pullUpAttributes(clonedObjectClass, superSourceObjectClass, superTargetObjectClass);
                    }
                }
                List mustNamesList = clonedObjectClass.getMustAttributeTypeOids();
                List mayNamesList = clonedObjectClass.getMayAttributeTypeOids();
                ArrayList attributeNames = new ArrayList();
                if (mustNamesList != null) {
                    attributeNames.addAll(mustNamesList);
                }
                if (mayNamesList != null) {
                    attributeNames.addAll(mayNamesList);
                }
                for (String attributeName : attributeNames) {
                    AttributeType attributeType;
                    if (attributeName == null || (attributeType = Activator.getDefault().getSchemaHandler().getAttributeType(attributeName)) == null) continue;
                    this.mergeAttributeType(attributeType, targetProject, targetSchema, processedObjects, errorMessages, replaceUnknownSyntax, mergeDependencies, pullUpAttributes);
                }
            }
            targetSchema.addObjectClass(clonedObjectClass);
        }
    }

    private void pullUpAttributes(ObjectClass targetObjectClass, ObjectClass sourceSuperObjectClass, ObjectClass targetSuperObjectClass) {
        HashSet<String> sourceMustAttributeNames = new HashSet<String>();
        this.fetchAttributes(sourceMustAttributeNames, sourceSuperObjectClass, true);
        HashSet<String> targetMustAttributeNames = new HashSet<String>();
        this.fetchAttributes(targetMustAttributeNames, targetSuperObjectClass, true);
        sourceMustAttributeNames.removeAll(targetMustAttributeNames);
        if (!sourceMustAttributeNames.isEmpty()) {
            sourceMustAttributeNames.addAll(targetObjectClass.getMustAttributeTypeOids());
            targetObjectClass.setMustAttributeTypeOids(new ArrayList<String>(sourceMustAttributeNames));
        }
        HashSet<String> sourceMayAttributeNames = new HashSet<String>();
        this.fetchAttributes(sourceMayAttributeNames, sourceSuperObjectClass, false);
        HashSet<String> targetMayAttributeNames = new HashSet<String>();
        this.fetchAttributes(targetMayAttributeNames, targetSuperObjectClass, false);
        sourceMayAttributeNames.removeAll(targetMayAttributeNames);
        if (!sourceMayAttributeNames.isEmpty()) {
            sourceMayAttributeNames.addAll(targetObjectClass.getMayAttributeTypeOids());
            targetObjectClass.setMayAttributeTypeOids(new ArrayList<String>(sourceMayAttributeNames));
        }
    }

    private void fetchAttributes(Set<String> attributeNameList, ObjectClass oc, boolean must) {
        List attributeNames = must ? oc.getMustAttributeTypeOids() : oc.getMayAttributeTypeOids();
        attributeNameList.addAll(attributeNames);
        for (String superClassName : oc.getSuperiorOids()) {
            ObjectClass superObjectClass = Activator.getDefault().getSchemaHandler().getObjectClass(superClassName);
            this.fetchAttributes(attributeNameList, superObjectClass, must);
        }
    }

    private String getIdString(AbstractSchemaObject schemaObject) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (schemaObject.getNames() != null) {
            for (String name : schemaObject.getNames()) {
                sb.append(name);
                sb.append(',');
            }
        }
        sb.append(schemaObject.getOid());
        sb.append(']');
        return sb.toString();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

