/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.views;

import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.controller.ProblemsViewController;
import org.apache.directory.studio.schemaeditor.model.schemachecker.SchemaChecker;
import org.apache.directory.studio.schemaeditor.view.views.Messages;
import org.apache.directory.studio.schemaeditor.view.views.ProblemsViewContentProvider;
import org.apache.directory.studio.schemaeditor.view.views.ProblemsViewLabelProvider;
import org.apache.directory.studio.schemaeditor.view.wrappers.ProblemsViewRoot;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ProblemsView
extends ViewPart {
    public static final String ID = PluginConstants.VIEW_PROBLEMS_VIEW_ID;
    private TreeViewer treeViewer;
    private ProblemsViewContentProvider contentProvider;
    private Label overviewLabel;
    private SchemaChecker schemaChecker;
    private ProblemsViewController controller;

    public void createPartControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(PluginConstants.PLUGIN_ID) + "." + "problems_view");
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        parent.setLayout((Layout)gridLayout);
        this.overviewLabel = new Label(parent, 0);
        this.setErrorsAndWarningsCount(0, 0);
        this.overviewLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        Label separatorLabel = new Label(parent, 258);
        separatorLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.initViewer(parent);
        this.controller = new ProblemsViewController(this);
    }

    private void initViewer(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 66304);
        Tree tree = this.treeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeColumn descriptionColumn = new TreeColumn(tree, 16384);
        descriptionColumn.setText(Messages.getString("ProblemsView.Description"));
        descriptionColumn.setWidth(500);
        TreeColumn resourceColumn = new TreeColumn(tree, 16384);
        resourceColumn.setText(Messages.getString("ProblemsView.Resource"));
        resourceColumn.setWidth(100);
        this.contentProvider = new ProblemsViewContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ProblemsViewLabelProvider());
    }

    public void setFocus() {
        this.treeViewer.getTree().setFocus();
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public void reloadViewer() {
        this.treeViewer.setInput((Object)new ProblemsViewRoot());
        this.treeViewer.expandAll();
        this.schemaChecker = Activator.getDefault().getSchemaChecker();
        if (this.schemaChecker != null) {
            this.setErrorsAndWarningsCount(this.schemaChecker.getErrors().size(), this.schemaChecker.getWarnings().size());
        } else {
            this.setErrorsAndWarningsCount(0, 0);
        }
    }

    public void setErrorsAndWarningsCount(int errors, int warnings) {
        StringBuffer sb = new StringBuffer();
        sb.append(errors);
        sb.append(" ");
        if (errors > 1) {
            sb.append(Messages.getString("ProblemsView.Errors"));
        } else {
            sb.append(Messages.getString("ProblemsView.Error"));
        }
        sb.append(", ");
        sb.append(warnings);
        sb.append(" ");
        if (warnings > 1) {
            sb.append(Messages.getString("ProblemsView.Warnings"));
        } else {
            sb.append(Messages.getString("ProblemsView.Warning"));
        }
        this.overviewLabel.setText(sb.toString());
    }

    public void dispose() {
        this.controller.dispose();
    }
}

