/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.searchresult;

import org.apache.directory.studio.connection.core.event.EventRunner;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserSelectionUtils;
import org.apache.directory.studio.ldapbrowser.core.events.EmptyValueAddedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryUpdateListener;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.events.SearchUpdateEvent;
import org.apache.directory.studio.ldapbrowser.core.events.SearchUpdateListener;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.actions.OpenSearchResultAction;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.OpenBestEditorAction;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditor;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorCursor;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorInput;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorLabelProvider;
import org.apache.directory.studio.ldapbrowser.ui.views.browser.BrowserView;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class SearchResultEditorUniversalListener
implements SearchUpdateListener,
EntryUpdateListener {
    private SearchResultEditor editor;
    private TableViewer viewer;
    private SearchResultEditorCursor cursor;
    private OpenBestEditorAction startEditAction;
    private ISearch selectedSearch;
    private Hyperlink dnLink;
    private TableEditor tableEditor;
    private IContextActivation contextActivation;
    private INullSelectionListener searchSelectionListener = new INullSelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (SearchResultEditorUniversalListener.this.editor != null && part != null && SearchResultEditorUniversalListener.this.editor.getSite().getWorkbenchWindow() == part.getSite().getWorkbenchWindow()) {
                ISearch[] searches = BrowserSelectionUtils.getSearches((ISelection)selection);
                Object[] objects = BrowserSelectionUtils.getObjects((ISelection)selection);
                if (searches.length == 1 && objects.length == 1) {
                    SearchResultEditorUniversalListener.this.editor.setInput(new SearchResultEditorInput(searches[0]));
                } else {
                    SearchResultEditorUniversalListener.this.editor.setInput(new SearchResultEditorInput(null));
                }
            }
        }
    };
    private IPartListener2 partListener = new IPartListener2(){

        public void partDeactivated(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) == SearchResultEditorUniversalListener.this.editor && SearchResultEditorUniversalListener.this.contextActivation != null) {
                SearchResultEditorUniversalListener.this.editor.getActionGroup().deactivateGlobalActionHandlers();
                IContextService contextService = (IContextService)PlatformUI.getWorkbench().getAdapter(IContextService.class);
                contextService.deactivateContext(SearchResultEditorUniversalListener.this.contextActivation);
                SearchResultEditorUniversalListener.this.contextActivation = null;
            }
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) == SearchResultEditorUniversalListener.this.editor) {
                IContextService contextService = (IContextService)PlatformUI.getWorkbench().getAdapter(IContextService.class);
                SearchResultEditorUniversalListener.this.contextActivation = contextService.activateContext(BrowserCommonConstants.CONTEXT_WINDOWS);
                SearchResultEditorUniversalListener.this.editor.getActionGroup().activateGlobalActionHandlers();
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    };
    private IHyperlinkListener dnHyperlinkListener = new IHyperlinkListener(){

        public void linkActivated(HyperlinkEvent e) {
            ISearchResult sr = (ISearchResult)e.widget.getData();
            OpenSearchResultAction action = new OpenSearchResultAction();
            action.setSelectedSearchResults(new ISearchResult[]{sr});
            action.run();
        }

        public void linkEntered(HyperlinkEvent e) {
        }

        public void linkExited(HyperlinkEvent e) {
        }
    };
    private MouseTrackListener dnMouseTrackListener = new MouseTrackListener(){

        public void mouseEnter(MouseEvent e) {
        }

        public void mouseExit(MouseEvent e) {
            if (!SearchResultEditorUniversalListener.this.dnLink.isDisposed()) {
                SearchResultEditorUniversalListener.this.dnLink.setVisible(false);
                SearchResultEditorUniversalListener.this.tableEditor.setEditor(null);
            }
        }

        public void mouseHover(MouseEvent e) {
        }
    };
    private MouseMoveListener cursorMouseMoveListener = new MouseMoveListener(){

        public void mouseMove(MouseEvent e) {
            if (!SearchResultEditorUniversalListener.this.cursor.isDisposed()) {
                TableItem item = SearchResultEditorUniversalListener.this.cursor.getRow();
                if (SearchResultEditorUniversalListener.this.cursor.getColumn() == 0 && "Dn".equalsIgnoreCase(SearchResultEditorUniversalListener.this.cursor.getRow().getParent().getColumns()[0].getText())) {
                    SearchResultEditorUniversalListener.this.checkDnLink(item);
                }
            }
        }
    };
    private MouseMoveListener viewerMouseMoveListener = new MouseMoveListener(){

        public void mouseMove(MouseEvent e) {
            if (!SearchResultEditorUniversalListener.this.viewer.getTable().isDisposed()) {
                TableItem item = SearchResultEditorUniversalListener.this.viewer.getTable().getItem(new Point(e.x, e.y));
                SearchResultEditorUniversalListener.this.viewer.getTable().getColumns()[0].getWidth();
                if (e.x > 0 && e.x < SearchResultEditorUniversalListener.this.viewer.getTable().getColumns()[0].getWidth() && "Dn".equalsIgnoreCase(SearchResultEditorUniversalListener.this.viewer.getTable().getColumns()[0].getText())) {
                    SearchResultEditorUniversalListener.this.checkDnLink(item);
                }
            }
        }
    };
    private SelectionListener cursorSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            SearchResultEditorUniversalListener.this.viewer.setSelection(null, true);
            SearchResultEditorUniversalListener.this.viewer.getTable().setSelection(new TableItem[0]);
            ISearchResult result = SearchResultEditorUniversalListener.this.cursor.getSelectedSearchResult();
            String property = SearchResultEditorUniversalListener.this.cursor.getSelectedProperty();
            if (property != null && result != null && SearchResultEditorUniversalListener.this.viewer.getCellModifier().canModify((Object)result, property)) {
                SearchResultEditorUniversalListener.this.cursor.setBackground(Display.getDefault().getSystemColor(26));
            } else {
                SearchResultEditorUniversalListener.this.cursor.setBackground(Display.getDefault().getSystemColor(33));
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            SearchResultEditorUniversalListener.this.viewer.setSelection(null, true);
            SearchResultEditorUniversalListener.this.viewer.getTable().setSelection(new TableItem[0]);
            if (SearchResultEditorUniversalListener.this.startEditAction.isEnabled()) {
                SearchResultEditorUniversalListener.this.startEditAction.run();
            }
        }
    };
    private MouseListener cursorMouseListener = new MouseAdapter(){

        public void mouseDoubleClick(MouseEvent e) {
            SearchResultEditorUniversalListener.this.viewer.setSelection(null, true);
            SearchResultEditorUniversalListener.this.viewer.getTable().setSelection(new TableItem[0]);
            if (SearchResultEditorUniversalListener.this.startEditAction.isEnabled()) {
                SearchResultEditorUniversalListener.this.startEditAction.run();
            }
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
        }
    };
    private KeyListener cursorKeyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
            if (e.character != '\u0000' && e.character != '\r' && e.character != '\n' && e.character != '\b' && e.character != '\u007f' && e.character != '\t' && e.character != '\u001b' && (e.stateMask == 0 || e.stateMask == 131072) && SearchResultEditorUniversalListener.this.startEditAction.isEnabled() && SearchResultEditorUniversalListener.this.startEditAction.getBestValueEditor().getCellEditor() instanceof TextCellEditor) {
                SearchResultEditorUniversalListener.this.startEditAction.run();
                CellEditor editor = SearchResultEditorUniversalListener.this.viewer.getCellEditors()[SearchResultEditorUniversalListener.this.cursor.getColumn()];
                if (editor instanceof TextCellEditor) {
                    editor.setValue((Object)String.valueOf(e.character));
                    ((Text)editor.getControl()).setSelection(1);
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    };

    public SearchResultEditorUniversalListener(SearchResultEditor editor) {
        this.editor = editor;
        this.startEditAction = editor.getActionGroup().getOpenBestEditorAction();
        this.viewer = editor.getMainWidget().getViewer();
        this.cursor = editor.getConfiguration().getCursor(this.viewer);
        this.dnLink = new Hyperlink((Composite)this.viewer.getTable(), 0);
        this.dnLink.setLayoutData((Object)new GridData(1024, 16384, true, true));
        this.dnLink.setText("");
        this.dnLink.setMenu(this.viewer.getTable().getMenu());
        this.tableEditor = new TableEditor(this.viewer.getTable());
        this.tableEditor.horizontalAlignment = 16384;
        this.tableEditor.verticalAlignment = 1024;
        this.tableEditor.grabHorizontal = true;
        this.tableEditor.grabVertical = true;
        this.dnLink.addHyperlinkListener(this.dnHyperlinkListener);
        this.dnLink.addMouseTrackListener(this.dnMouseTrackListener);
        this.cursor.addMouseMoveListener(this.cursorMouseMoveListener);
        this.cursor.addSelectionListener(this.cursorSelectionListener);
        this.cursor.addMouseListener(this.cursorMouseListener);
        this.cursor.addKeyListener(this.cursorKeyListener);
        this.viewer.getTable().addMouseMoveListener(this.viewerMouseMoveListener);
        editor.getSite().getPage().addPartListener(this.partListener);
        editor.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener(BrowserView.getId(), (ISelectionListener)this.searchSelectionListener);
        EventRegistry.addSearchUpdateListener((SearchUpdateListener)this, (EventRunner)BrowserCommonActivator.getDefault().getEventRunner());
        EventRegistry.addEntryUpdateListener((EntryUpdateListener)this, (EventRunner)BrowserCommonActivator.getDefault().getEventRunner());
    }

    public void dispose() {
        if (this.editor != null) {
            this.editor.getSite().getPage().removePartListener(this.partListener);
            this.editor.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(BrowserView.getId(), (ISelectionListener)this.searchSelectionListener);
            EventRegistry.removeSearchUpdateListener((SearchUpdateListener)this);
            EventRegistry.removeEntryUpdateListener((EntryUpdateListener)this);
            this.selectedSearch = null;
            this.startEditAction = null;
            this.cursor = null;
            this.viewer = null;
            this.editor = null;
        }
    }

    public void searchUpdated(SearchUpdateEvent searchUpdateEvent) {
        if (this.selectedSearch == searchUpdateEvent.getSearch()) {
            this.refreshInput();
        }
    }

    public void entryUpdated(EntryModificationEvent event) {
        if (event instanceof EmptyValueAddedEvent && !this.editor.getActionGroup().isEditorActive()) {
            EmptyValueAddedEvent evae = (EmptyValueAddedEvent)event;
            IAttribute att = evae.getAddedValue().getAttribute();
            AttributeHierarchy ah = this.cursor.getSelectedAttributeHierarchy();
            if (ah != null && ah.contains(att)) {
                this.viewer.setSelection(null, true);
                this.viewer.getTable().setSelection(new TableItem[0]);
                if (this.startEditAction.isEnabled()) {
                    this.startEditAction.run();
                }
            }
        } else {
            this.viewer.refresh(true);
            this.cursor.notifyListeners(13, new Event());
        }
    }

    void setInput(ISearch search) {
        this.selectedSearch = search;
        this.refreshInput();
        this.editor.getActionGroup().setInput(search);
    }

    void refreshInput() {
        int usedColumns;
        this.ensureColumnCount(1);
        TableColumn[] columns = this.viewer.getTable().getColumns();
        if (this.selectedSearch != null) {
            String[] attributes;
            boolean showDn;
            boolean bl = showDn = BrowserUIPlugin.getDefault().getPreferenceStore().getBoolean("searchResultEditorShowDn") || this.selectedSearch.getReturningAttributes().length == 0;
            if (showDn) {
                attributes = new String[this.selectedSearch.getReturningAttributes().length + 1];
                attributes[0] = "Dn";
                System.arraycopy(this.selectedSearch.getReturningAttributes(), 0, attributes, 1, attributes.length - 1);
            } else {
                attributes = this.selectedSearch.getReturningAttributes();
            }
            if (attributes.length > columns.length) {
                this.ensureColumnCount(attributes.length);
                columns = this.viewer.getTable().getColumns();
            }
            int i = 0;
            while (i < attributes.length) {
                columns[i].setText(attributes[i]);
                ++i;
            }
            this.viewer.setColumnProperties(attributes);
            ((SearchResultEditorLabelProvider)this.viewer.getLabelProvider()).inputChanged(this.selectedSearch, showDn);
            this.viewer.setInput((Object)this.selectedSearch);
            CellEditor[] editors = new CellEditor[attributes.length];
            this.viewer.setCellEditors(editors);
            if (attributes.length > 0) {
                int width = this.viewer.getTable().getClientArea().width / attributes.length;
                int i2 = 0;
                while (i2 < attributes.length) {
                    columns[i2].setWidth(width);
                    ++i2;
                }
            }
            usedColumns = attributes.length;
        } else {
            this.viewer.setInput(null);
            columns[0].setText("Dn");
            columns[0].pack();
            usedColumns = 1;
        }
        int i = usedColumns;
        while (i < columns.length) {
            columns[i].setWidth(0);
            columns[i].setText(" ");
            ++i;
        }
        this.editor.getConfiguration().getContentProvider(this.editor.getMainWidget()).refresh();
    }

    private void ensureColumnCount(int count) {
        TableColumn[] columns = this.viewer.getTable().getColumns();
        if (columns.length < count) {
            int i = columns.length;
            while (i < count) {
                TableColumn column = new TableColumn(this.viewer.getTable(), 16384);
                column.setText("");
                column.setWidth(0);
                column.setResizable(true);
                column.setMoveable(true);
                ++i;
            }
        }
    }

    private void checkDnLink(TableItem item) {
        if (this.dnLink == null || this.dnLink.isDisposed() || this.tableEditor == null || this.viewer.getTable().isDisposed() || this.cursor.isDisposed()) {
            return;
        }
        boolean showLinks = BrowserUIPlugin.getDefault().getPreferenceStore().getBoolean("searchResultEditorShowLinks");
        if (showLinks) {
            Object data;
            boolean linkVisible = false;
            if (item != null && (data = item.getData()) instanceof ISearchResult) {
                ISearchResult sr = (ISearchResult)data;
                item.getFont();
                this.viewer.getTable().getColumn(0).getWidth();
                this.viewer.getTable().getItemHeight();
                this.dnLink.setData((Object)sr);
                this.dnLink.setText(sr.getDn().getName());
                this.dnLink.setUnderlined(true);
                this.dnLink.setFont(item.getFont());
                this.dnLink.setForeground(item.getForeground());
                this.dnLink.setBackground(item.getBackground());
                this.dnLink.setBounds(item.getBounds(0));
                this.tableEditor.setEditor((Control)this.dnLink, item, 0);
                linkVisible = true;
            }
            if (!linkVisible) {
                this.dnLink.setVisible(false);
                this.tableEditor.setEditor(null);
            }
        }
    }
}

