/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.entry;

import org.apache.directory.studio.entryeditors.EntryEditorInput;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.EntryEditor;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.LocateEntryInLdapBrowserAction;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.LocateSearchResultOrBookmarkAction;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ContributionItemFactory;

public class EntryEditorShowInMenuManager {
    private EntryEditor entryEditor;
    private LocateEntryInLdapBrowserAction locateEntryInDitAction;
    private LocateSearchResultOrBookmarkAction locateSearchResultOrBookmarkAction;

    public EntryEditorShowInMenuManager(EntryEditor entryEditor) {
        this.entryEditor = entryEditor;
        this.locateEntryInDitAction = new LocateEntryInLdapBrowserAction(entryEditor, this);
        this.locateSearchResultOrBookmarkAction = new LocateSearchResultOrBookmarkAction(entryEditor, this);
    }

    public void createMenuManager(IMenuManager parent) {
        MenuManager showInMenuManager = new MenuManager(Messages.getString("EntryEditorShowInMenuManager.ShowIn"));
        parent.add((IContributionItem)showInMenuManager);
        Object input = this.getInput();
        if (input != null) {
            showInMenuManager.add((IAction)this.locateEntryInDitAction);
            if (this.inputIsSearchResultOrBookmark()) {
                showInMenuManager.add((IAction)this.locateSearchResultOrBookmarkAction);
            }
        }
        showInMenuManager.add(ContributionItemFactory.VIEWS_SHOW_IN.create(PlatformUI.getWorkbench().getActiveWorkbenchWindow()));
    }

    public Object getInput() {
        EntryEditorInput editorInput;
        if (this.entryEditor != null && (editorInput = this.entryEditor.getEntryEditorInput()) != null) {
            return editorInput.getInput();
        }
        return null;
    }

    private boolean inputIsSearchResultOrBookmark() {
        Object input = this.getInput();
        return input instanceof ISearchResult || input instanceof IBookmark;
    }
}

