/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.rest;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.directory.fortress.core.ReviewMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.Manageable;
import org.apache.directory.fortress.core.model.FortRequest;
import org.apache.directory.fortress.core.model.FortResponse;
import org.apache.directory.fortress.core.model.OrgUnit;
import org.apache.directory.fortress.core.model.PermObj;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.PermissionAttributeSet;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.RoleConstraint;
import org.apache.directory.fortress.core.model.SDSet;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.core.rest.RestUtils;
import org.apache.directory.fortress.core.util.VUtil;

public class ReviewMgrRestImpl
extends Manageable
implements ReviewMgr {
    private static final String CLS_NM = ReviewMgrRestImpl.class.getName();

    @Override
    public Permission readPermission(Permission permission) throws SecurityException {
        VUtil.assertNotNull(permission, 3009, CLS_NM + ".readPermission");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(permission);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "permRead");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Permission retPerm = (Permission)response.getEntity();
        return retPerm;
    }

    @Override
    public PermObj readPermObj(PermObj permObj) throws SecurityException {
        VUtil.assertNotNull(permObj, 3010, CLS_NM + ".readPermObj");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(permObj);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "objRead");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        PermObj retObj = (PermObj)response.getEntity();
        return retObj;
    }

    @Override
    public List<Permission> findPermissions(Permission permission) throws SecurityException {
        VUtil.assertNotNull(permission, 3009, CLS_NM + ".findPermissions");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(permission);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "permSearch");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<Permission> retPerms = response.getEntities();
        return retPerms;
    }

    @Override
    public List<Permission> findPermsByObj(PermObj permObj) throws SecurityException {
        VUtil.assertNotNull(permObj, 3010, CLS_NM + ".findPermsByObj");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(permObj);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "permObjSearch");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<Permission> retPerms = response.getEntities();
        return retPerms;
    }

    @Override
    public List<Permission> findAnyPermissions(Permission permission) throws SecurityException {
        VUtil.assertNotNull(permission, 3009, CLS_NM + ".findAnyPermissions");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(permission);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "permSearchAny");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<Permission> retPerms = response.getEntities();
        return retPerms;
    }

    @Override
    public List<PermObj> findPermObjs(PermObj permObj) throws SecurityException {
        VUtil.assertNotNull(permObj, 3010, CLS_NM + ".findPermObjs");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(permObj);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "objSearch");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<PermObj> retObjs = response.getEntities();
        return retObjs;
    }

    @Override
    public List<PermObj> findPermObjs(OrgUnit ou) throws SecurityException {
        VUtil.assertNotNull(ou, 8068, CLS_NM + ".findPermObjs");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        PermObj inObj = new PermObj();
        inObj.setOu(ou.getName());
        request.setEntity(inObj);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "objSearch");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<PermObj> retObjs = response.getEntities();
        return retObjs;
    }

    @Override
    public Role readRole(Role role) throws SecurityException {
        VUtil.assertNotNull(role, 5007, CLS_NM + ".readRole");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(role);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "roleRead");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Role retRole = (Role)response.getEntity();
        return retRole;
    }

    @Override
    public List<Role> findRoles(String searchVal) throws SecurityException {
        VUtil.assertNotNull(searchVal, 5005, CLS_NM + ".findRoles");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setValue(searchVal);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "roleSearch");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<Role> retRoles = response.getEntities();
        return retRoles;
    }

    @Override
    public List<String> findRoles(String searchVal, int limit) throws SecurityException {
        VUtil.assertNotNull(searchVal, 5005, CLS_NM + ".findRoles");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setValue(searchVal);
        request.setLimit(limit);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "roleSearch");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<String> retRoles = response.getValues();
        return retRoles;
    }

    @Override
    public final User readUser(User user) throws SecurityException {
        VUtil.assertNotNull(user, 1008, CLS_NM + ".readUser");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(user);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "userRead");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        User retUser = (User)response.getEntity();
        return retUser;
    }

    @Override
    public final List<User> findUsers(User user) throws SecurityException {
        VUtil.assertNotNull(user, 1008, CLS_NM + ".findUsers");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(user);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "userSearch");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<User> retUsers = response.getEntities();
        return retUsers;
    }

    @Override
    public List<User> findUsers(OrgUnit ou) throws SecurityException {
        VUtil.assertNotNull(ou, 8018, CLS_NM + ".findUsers");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        User inUser = new User();
        inUser.setOu(ou.getName());
        request.setEntity(inUser);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "userSearch");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<User> retUsers = response.getEntities();
        return retUsers;
    }

    @Override
    public final List<String> findUsers(User user, int limit) throws SecurityException {
        VUtil.assertNotNull(user, 1008, CLS_NM + ".findUsers");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setLimit(limit);
        request.setEntity(user);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "userSearch");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<String> retUsers = response.getValues();
        return retUsers;
    }

    @Override
    public List<String> assignedUsers(Role role, int limit) throws SecurityException {
        List<String> retUsers;
        VUtil.assertNotNull(role, 5007, CLS_NM + ".assignedUsers");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setLimit(limit);
        request.setEntity(role);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "userAsigned");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() == 0) {
            retUsers = response.getValues();
            if (retUsers == null) {
                retUsers = new ArrayList<String>();
            }
        } else {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        return retUsers;
    }

    @Override
    public List<User> assignedUsers(Role role) throws SecurityException {
        VUtil.assertNotNull(role, 5007, CLS_NM + ".assignedUsers");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(role);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "userAsigned");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<User> retUsers = response.getEntities();
        return retUsers;
    }

    @Override
    public List<UserRole> assignedRoles(User user) throws SecurityException {
        VUtil.assertNotNull(user, 1008, CLS_NM + ".assignedRoles");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(user);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "roleAsigned");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<UserRole> retUserRoles = response.getEntities();
        return retUserRoles;
    }

    @Override
    public List<String> assignedRoles(String userId) throws SecurityException {
        VUtil.assertNotNullOrEmpty(userId, 1008, CLS_NM + ".assignedRoles");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setValue(userId);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "roleAsigned");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<String> retUserRoles = response.getValues();
        return retUserRoles;
    }

    @Override
    public List<User> authorizedUsers(Role role) throws SecurityException {
        List<User> retUsers;
        VUtil.assertNotNull(role, 5007, CLS_NM + ".authorizedUsers");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(role);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "userAuthzed");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() == 0) {
            retUsers = response.getEntities();
            if (retUsers == null) {
                retUsers = new ArrayList<User>();
            }
        } else {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        return retUsers;
    }

    @Override
    public Set<String> authorizedRoles(User user) throws SecurityException {
        VUtil.assertNotNull(user, 1008, CLS_NM + ".authorizedRoles");
        TreeSet<String> retRoleNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(user);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "roleAuthzed");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Set<String> tempNames = response.getValueSet();
        retRoleNames.addAll(tempNames);
        return retRoleNames;
    }

    @Override
    public List<Permission> rolePermissions(Role role) throws SecurityException {
        return this.rolePermissions(role, false);
    }

    @Override
    public List<Permission> rolePermissions(Role role, boolean noInheritance) throws SecurityException {
        VUtil.assertNotNull(role, 5007, CLS_NM + ".rolePermissions");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(role);
        request.setIsFlag(noInheritance);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "rolePerms");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<Permission> retPerms = response.getEntities();
        return retPerms;
    }

    @Override
    public List<PermissionAttributeSet> rolePermissionAttributeSets(Role role, boolean noInhertiance) throws SecurityException {
        VUtil.assertNotNull(role, 5007, CLS_NM + ".rolePermissionAttributeSets");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(role);
        request.setIsFlag(noInhertiance);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "rolePermAttrSets");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<PermissionAttributeSet> retAttrSets = response.getEntities();
        return retAttrSets;
    }

    @Override
    public List<Permission> userPermissions(User user) throws SecurityException {
        VUtil.assertNotNull(user, 1008, CLS_NM + ".userPermissions");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(user);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "userPerms");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<Permission> retPerms = response.getEntities();
        return retPerms;
    }

    @Override
    public List<String> permissionRoles(Permission perm) throws SecurityException {
        VUtil.assertNotNull(perm, 3010, CLS_NM + ".permissionRoles");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(perm);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "permRoles");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<String> retRoleNames = response.getValues();
        return retRoleNames;
    }

    @Override
    public Set<String> authorizedPermissionRoles(Permission perm) throws SecurityException {
        VUtil.assertNotNull(perm, 3009, CLS_NM + ".authorizedPermissionRoles");
        TreeSet<String> retRoleNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(perm);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "permRolesAuthzed");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Set<String> tempNames = response.getValueSet();
        retRoleNames.addAll(tempNames);
        return retRoleNames;
    }

    @Override
    public List<String> permissionUsers(Permission perm) throws SecurityException {
        VUtil.assertNotNull(perm, 3009, CLS_NM + ".permissionUsers");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(perm);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "permUsers");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<String> retUsers = response.getValues();
        return retUsers;
    }

    @Override
    public Set<String> authorizedPermissionUsers(Permission perm) throws SecurityException {
        VUtil.assertNotNull(perm, 3009, CLS_NM + ".authorizedPermissionUsers");
        TreeSet<String> retUserIds = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(perm);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "permUsersAuthzed");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Set<String> tempNames = response.getValueSet();
        retUserIds.addAll(tempNames);
        return retUserIds;
    }

    @Override
    public List<SDSet> ssdRoleSets(Role role) throws SecurityException {
        List<SDSet> retSsdRoleSets;
        VUtil.assertNotNull(role, 5007, CLS_NM + ".ssdRoleSets");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(role);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "ssdRoleSets");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() == 0) {
            retSsdRoleSets = response.getEntities();
            if (retSsdRoleSets == null) {
                retSsdRoleSets = new ArrayList<SDSet>();
            }
        } else {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        return retSsdRoleSets;
    }

    @Override
    public SDSet ssdRoleSet(SDSet set) throws SecurityException {
        VUtil.assertNotNull(set, 5087, CLS_NM + ".ssdRoleSet");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(set);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "ssdRead");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        SDSet retSet = (SDSet)response.getEntity();
        return retSet;
    }

    @Override
    public List<SDSet> ssdSets(SDSet ssd) throws SecurityException {
        List<SDSet> retSsdSets;
        VUtil.assertNotNull(ssd, 5007, CLS_NM + ".ssdSets");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(ssd);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "ssdSets");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() == 0) {
            retSsdSets = response.getEntities();
            if (retSsdSets == null) {
                retSsdSets = new ArrayList<SDSet>();
            }
        } else {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        return retSsdSets;
    }

    @Override
    public Set<String> ssdRoleSetRoles(SDSet ssd) throws SecurityException {
        VUtil.assertNotNull(ssd, 5087, CLS_NM + ".ssdRoleSetRoles");
        TreeSet<String> retRoleNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(ssd);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "ssdRoles");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Set<String> tempNames = response.getValueSet();
        retRoleNames.addAll(tempNames);
        return retRoleNames;
    }

    @Override
    public int ssdRoleSetCardinality(SDSet ssd) throws SecurityException {
        VUtil.assertNotNull(ssd, 5087, CLS_NM + ".ssdRoleSetCardinality");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(ssd);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "ssdCard");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        SDSet retSet = (SDSet)response.getEntity();
        return retSet.getCardinality();
    }

    @Override
    public List<SDSet> dsdRoleSets(Role role) throws SecurityException {
        List<SDSet> retDsdRoleSets;
        VUtil.assertNotNull(role, 5007, CLS_NM + ".dsdRoleSets");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(role);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "dsdRoleSets");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() == 0) {
            retDsdRoleSets = response.getEntities();
            if (retDsdRoleSets == null) {
                retDsdRoleSets = new ArrayList<SDSet>();
            }
        } else {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        return retDsdRoleSets;
    }

    @Override
    public SDSet dsdRoleSet(SDSet set) throws SecurityException {
        VUtil.assertNotNull(set, 5096, CLS_NM + ".dsdRoleSet");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(set);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "dsdRead");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        SDSet retSet = (SDSet)response.getEntity();
        return retSet;
    }

    @Override
    public List<SDSet> dsdSets(SDSet dsd) throws SecurityException {
        List<SDSet> retDsdSets;
        VUtil.assertNotNull(dsd, 5007, CLS_NM + ".dsdSets");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(dsd);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "dsdSets");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() == 0) {
            retDsdSets = response.getEntities();
            if (retDsdSets == null) {
                retDsdSets = new ArrayList<SDSet>();
            }
        } else {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        return retDsdSets;
    }

    @Override
    public Set<String> dsdRoleSetRoles(SDSet dsd) throws SecurityException {
        VUtil.assertNotNull(dsd, 5087, CLS_NM + ".dsdRoleSetRoles");
        TreeSet<String> retRoleNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(dsd);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "dsdRoles");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Set<String> tempNames = response.getValueSet();
        retRoleNames.addAll(tempNames);
        return retRoleNames;
    }

    @Override
    public int dsdRoleSetCardinality(SDSet dsd) throws SecurityException {
        VUtil.assertNotNull(dsd, 5096, CLS_NM + ".dsdRoleSetCardinality");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(dsd);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "dsdCard");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        SDSet retSet = (SDSet)response.getEntity();
        return retSet.getCardinality();
    }

    @Override
    public PermissionAttributeSet readPermAttributeSet(PermissionAttributeSet permAttributeSet) throws SecurityException {
        VUtil.assertNotNull(permAttributeSet, 3030, CLS_NM + ".readPermAttributeSet");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(permAttributeSet);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "readPermAttributeSet");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        PermissionAttributeSet retPermSet = (PermissionAttributeSet)response.getEntity();
        return retPermSet;
    }

    @Override
    public List<RoleConstraint> findRoleConstraints(User user, Permission permission, RoleConstraint.RCType rcType) throws SecurityException {
        VUtil.assertNotNull(user, 1008, CLS_NM + ".findRoleConstraints");
        VUtil.assertNotNull(user, 3008, CLS_NM + ".findRoleConstraints");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(user);
        request.setEntity2(permission);
        request.setValue(rcType.toString());
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "findRoleConstraints");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<RoleConstraint> retConstraints = response.getEntities();
        return retConstraints;
    }

    @Override
    public List<User> assignedUsers(Role role, RoleConstraint roleConstraint) throws SecurityException {
        VUtil.assertNotNull(role, 5007, CLS_NM + ".assignedUsers");
        VUtil.assertNotNull(roleConstraint, 5102, CLS_NM + ".assignedUsers");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(role);
        request.setEntity2(roleConstraint);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "userAsignedConstraints");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<User> users = response.getEntities();
        return users;
    }

    @Override
    public List<UserRole> assignedUsers(Role role, RoleConstraint.RCType rcType, String key) throws SecurityException {
        VUtil.assertNotNull(role, 5007, CLS_NM + ".assignedUsers");
        VUtil.assertNotNull((Object)rcType, 5100, CLS_NM + ".assignedUsers");
        VUtil.assertNotNull(key, 5103, CLS_NM + ".assignedUsers");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(role);
        RoleConstraint constraint = new RoleConstraint();
        constraint.setKey(key);
        constraint.setType(rcType);
        request.setEntity2(constraint);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "userAsignedConstraintsKey");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<UserRole> uRoles = response.getEntities();
        return uRoles;
    }
}

