/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.directory.fortress.annotation.AdminPermissionOperation;
import org.apache.directory.fortress.core.AdminMgr;
import org.apache.directory.fortress.core.FinderException;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.AdminRoleP;
import org.apache.directory.fortress.core.impl.AdminUtil;
import org.apache.directory.fortress.core.impl.ConfigP;
import org.apache.directory.fortress.core.impl.GroupP;
import org.apache.directory.fortress.core.impl.Manageable;
import org.apache.directory.fortress.core.impl.PermP;
import org.apache.directory.fortress.core.impl.RoleP;
import org.apache.directory.fortress.core.impl.RoleUtil;
import org.apache.directory.fortress.core.impl.SDUtil;
import org.apache.directory.fortress.core.impl.SdP;
import org.apache.directory.fortress.core.impl.UserP;
import org.apache.directory.fortress.core.model.AdminRole;
import org.apache.directory.fortress.core.model.Configuration;
import org.apache.directory.fortress.core.model.ConstraintUtil;
import org.apache.directory.fortress.core.model.Group;
import org.apache.directory.fortress.core.model.Hier;
import org.apache.directory.fortress.core.model.PermObj;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.PermissionAttribute;
import org.apache.directory.fortress.core.model.PermissionAttributeSet;
import org.apache.directory.fortress.core.model.Relationship;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.RoleConstraint;
import org.apache.directory.fortress.core.model.SDSet;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.VUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AdminMgrImpl
extends Manageable
implements AdminMgr,
Serializable {
    private static final String CLS_NM = AdminMgrImpl.class.getName();
    private static final AdminRoleP adminP = new AdminRoleP();
    private static final PermP permP = new PermP();
    private static final RoleP roleP = new RoleP();
    private static final SdP sdP = new SdP();
    private static final UserP userP = new UserP();
    private static final GroupP groupP = new GroupP();
    private static final ConfigP configP = new ConfigP();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);

    @Override
    @AdminPermissionOperation
    public User addUser(User user) throws SecurityException {
        String methodName = "addUser";
        this.assertContext(CLS_NM, methodName, user, 1008);
        this.setEntitySession(CLS_NM, methodName, user);
        AdminUtil.canDo(this.adminSess, user, this.contextId, true);
        return userP.add(user);
    }

    @Override
    @AdminPermissionOperation
    public void disableUser(User user) throws SecurityException {
        String methodName = "disableUser";
        this.assertContext(CLS_NM, methodName, user, 1008);
        this.setEntitySession(CLS_NM, methodName, user);
        AdminUtil.canDo(this.adminSess, user, this.contextId, false);
        String userDn = userP.softDelete(user);
        userP.lock(user);
        permP.remove(user);
        roleP.removeOccupant(userDn, this.contextId);
        adminP.removeOccupant(userDn, this.contextId);
    }

    @Override
    @AdminPermissionOperation
    public void deleteUser(User user) throws SecurityException {
        String methodName = "deleteUser";
        this.assertContext(CLS_NM, methodName, user, 1008);
        this.setEntitySession(CLS_NM, methodName, user);
        AdminUtil.canDo(this.adminSess, user, this.contextId, false);
        permP.remove(user);
        String userDn = userP.delete(user);
        roleP.removeOccupant(userDn, this.contextId);
        adminP.removeOccupant(userDn, this.contextId);
    }

    @Override
    @AdminPermissionOperation
    public User updateUser(User user) throws SecurityException {
        String methodName = "updateUser";
        this.assertContext(CLS_NM, methodName, user, 1008);
        this.setEntitySession(CLS_NM, methodName, user);
        AdminUtil.canDo(this.adminSess, user, this.contextId, false);
        return userP.update(user);
    }

    @Override
    @AdminPermissionOperation
    public void changePassword(User user, String newPassword) throws SecurityException {
        String methodName = "changePassword";
        this.assertContext(CLS_NM, methodName, user, 1008);
        this.setEntitySession(CLS_NM, methodName, user);
        AdminUtil.canDo(this.adminSess, user, this.contextId, false);
        VUtil.assertNotNullOrEmpty(newPassword, 1009, CLS_NM + methodName);
        userP.changePassword(user, newPassword);
    }

    @Override
    @AdminPermissionOperation
    public void lockUserAccount(User user) throws SecurityException {
        String methodName = "lockUserAccount";
        this.assertContext(CLS_NM, methodName, user, 1008);
        this.setEntitySession(CLS_NM, methodName, user);
        AdminUtil.canDo(this.adminSess, user, this.contextId, false);
        userP.lock(user);
    }

    @Override
    @AdminPermissionOperation
    public void unlockUserAccount(User user) throws SecurityException {
        String methodName = "unlockUserAccount";
        this.assertContext(CLS_NM, methodName, user, 1008);
        this.setEntitySession(CLS_NM, methodName, user);
        userP.unlock(user);
    }

    @Override
    @AdminPermissionOperation
    public void resetPassword(User user, String newPassword) throws SecurityException {
        String methodName = "resetPassword";
        this.assertContext(CLS_NM, methodName, user, 1008);
        VUtil.assertNotNullOrEmpty(newPassword, 1009, CLS_NM + "." + methodName);
        this.setEntitySession(CLS_NM, methodName, user);
        AdminUtil.canDo(this.adminSess, user, this.contextId, false);
        user.setPassword(newPassword);
        userP.resetPassword(user);
    }

    @Override
    @AdminPermissionOperation
    public void deletePasswordPolicy(User user) throws SecurityException {
        String methodName = "deletePasswordPolicy";
        this.assertContext(CLS_NM, methodName, user, 1008);
        this.setEntitySession(CLS_NM, methodName, user);
        AdminUtil.canDo(this.adminSess, user, this.contextId, false);
        userP.deletePwPolicy(user);
    }

    @Override
    @AdminPermissionOperation
    public Role addRole(Role role) throws SecurityException {
        String methodName = "addRole";
        this.assertContext(CLS_NM, methodName, role, 5007);
        this.setEntitySession(CLS_NM, methodName, role);
        return roleP.add(role);
    }

    @Override
    @AdminPermissionOperation
    public void deleteRole(Role role) throws SecurityException {
        UserRole uRole;
        String methodName = "deleteRole";
        this.assertContext(CLS_NM, methodName, role, 5007);
        this.setEntitySession(CLS_NM, methodName, role);
        int numChildren = RoleUtil.getInstance().numChildren(role.getName(), role.getContextId());
        if (numChildren > 0) {
            String error = methodName + " role [" + role.getName() + "] must remove [" + numChildren + "] descendants before deletion";
            LOG.error(error);
            throw new SecurityException(5058, error, null);
        }
        Role outRole = roleP.read(role);
        outRole.setContextId(role.getContextId());
        List<Group> groups = groupP.roleGroups(outRole);
        for (Group group : groups) {
            group.setContextId(this.contextId);
            groupP.deassign(group, outRole.getDn());
        }
        if (Config.getInstance().isRoleOccupant()) {
            List<User> users = userP.getAssignedUsers(role);
            if (users != null) {
                for (User ue : users) {
                    uRole = new UserRole(ue.getUserId(), role.getName());
                    this.setAdminData(CLS_NM, methodName, uRole);
                    this.deassignUser(uRole);
                }
            }
        } else {
            List<String> userIds = userP.getAssignedUserIds(role);
            for (String userId : userIds) {
                uRole = new UserRole(userId, role.getName());
                this.setAdminData(CLS_NM, methodName, uRole);
                this.deassignUser(uRole);
            }
        }
        permP.remove(role);
        Set<String> parents = RoleUtil.getInstance().getParents(role.getName(), this.contextId);
        if (parents != null) {
            for (String parent : parents) {
                RoleUtil.getInstance().updateHier(this.contextId, new Relationship(role.getName().toUpperCase(), parent.toUpperCase()), Hier.Op.REM);
            }
        }
        roleP.delete(role);
    }

    @Override
    @AdminPermissionOperation
    public Role updateRole(Role role) throws SecurityException {
        String methodName = "updateRole";
        this.assertContext(CLS_NM, methodName, role, 5007);
        this.setEntitySession(CLS_NM, methodName, role);
        return roleP.update(role);
    }

    @Override
    @AdminPermissionOperation
    public void assignUser(UserRole uRole) throws SecurityException {
        String methodName = "assignUser";
        this.assertContext(CLS_NM, methodName, uRole, 2003);
        VUtil.assertNotNull(uRole.getName(), 5005, CLS_NM + methodName);
        Role role = new Role(uRole.getName());
        role.setContextId(this.contextId);
        User user = new User(uRole.getUserId());
        user.setContextId(this.contextId);
        this.setEntitySession(CLS_NM, methodName, uRole);
        AdminUtil.canAssign(uRole.getAdminSession(), user, role, this.contextId);
        SDUtil.getInstance().validateSSD(user, role);
        role.setContextId(this.contextId);
        Role validRole = roleP.readConstraints(role);
        ConstraintUtil.validateOrCopy(validRole, uRole);
        String dn = userP.assign(uRole);
        if (Config.getInstance().isRoleOccupant()) {
            this.setAdminData(CLS_NM, methodName, role);
            roleP.assign(role, dn);
        }
    }

    @Override
    @AdminPermissionOperation
    public void enableRoleConstraint(Role role, RoleConstraint roleConstraint) throws SecurityException {
        String methodName = "enableRoleConstraint";
        VUtil.assertNotNull(role, 5007, CLS_NM + methodName);
        VUtil.assertNotNull(role.getName(), 5005, CLS_NM + methodName);
        VUtil.assertNotNull(roleConstraint, 5102, CLS_NM + methodName);
        this.setEntitySession(CLS_NM, methodName, role);
        String propKey = Config.getInstance().getConstraintKey(role.getName(), this.contextId);
        String propValue = roleConstraint.getKey();
        VUtil.assertNotNull(propValue, 5103, CLS_NM + methodName);
        roleP.readConstraints(role);
        Properties props = new Properties();
        props.setProperty(propKey, propValue);
        String realmName = Config.getInstance().getProperty("config.realm", "DEFAULT");
        configP.update(new Configuration(realmName, props));
        Config.getInstance().setProperty(propKey, propValue);
    }

    @Override
    @AdminPermissionOperation
    public void disableRoleConstraint(Role role, RoleConstraint roleConstraint) throws SecurityException {
        String methodName = "disableRoleConstraint";
        this.setEntitySession(CLS_NM, methodName, role);
        VUtil.assertNotNull(role, 5007, CLS_NM + methodName);
        VUtil.assertNotNull(role.getName(), 5005, CLS_NM + methodName);
        VUtil.assertNotNull(roleConstraint, 5102, CLS_NM + methodName);
        String propKey = Config.getInstance().getConstraintKey(role.getName(), this.contextId);
        String propValue = roleConstraint.getKey();
        VUtil.assertNotNull(propValue, 5103, CLS_NM + methodName);
        Properties props = new Properties();
        props.setProperty(propKey, propValue);
        String realmName = Config.getInstance().getProperty("config.realm", "DEFAULT");
        configP.delete(realmName, props);
        Config.getInstance().clearProperty(propKey);
    }

    @Override
    @AdminPermissionOperation
    public RoleConstraint addRoleConstraint(UserRole uRole, RoleConstraint roleConstraint) throws SecurityException {
        block5: {
            String methodName;
            block4: {
                methodName = "addRoleConstraint";
                this.assertContext(CLS_NM, methodName, uRole, 2003);
                VUtil.assertNotNull(uRole.getName(), 5005, CLS_NM + methodName);
                VUtil.assertNotNull(roleConstraint, 5102, CLS_NM + methodName);
                this.setEntitySession(CLS_NM, methodName, uRole);
                if (roleConstraint.getType() == RoleConstraint.RCType.USER) {
                    String propKey = Config.getInstance().getConstraintKey(uRole.getName(), this.contextId);
                    String propValue = Config.getInstance().getProperty(propKey);
                    VUtil.assertNotNull(propValue, 5104, CLS_NM + methodName);
                }
                User user = new User(uRole.getUserId());
                user.setContextId(this.contextId);
                List<String> assignedRoles = userP.getAssignedRoles(user);
                this.assertContext(CLS_NM, methodName, uRole, 2003);
                if (CollectionUtils.isEmpty(assignedRoles)) break block4;
                if (assignedRoles.stream().anyMatch(uRole.getName()::equalsIgnoreCase)) break block5;
            }
            String error = methodName + " user [" + uRole.getUserId() + "] not assigned role [" + uRole.getName() + "]";
            LOG.error(error);
            throw new SecurityException(2009, error, null);
        }
        AdminUtil.canAssign(uRole.getAdminSession(), new User(uRole.getUserId()), new Role(uRole.getName()), this.contextId);
        userP.assign(uRole, roleConstraint);
        return roleConstraint;
    }

    @Override
    @AdminPermissionOperation
    public void removeRoleConstraint(UserRole uRole, RoleConstraint roleConstraint) throws SecurityException {
        String methodName = "removeRoleConstraint";
        this.assertContext(CLS_NM, methodName, uRole, 2003);
        VUtil.assertNotNull(roleConstraint, 5102, CLS_NM + methodName);
        VUtil.assertNotNull(uRole.getName(), 5005, CLS_NM + methodName);
        this.setEntitySession(CLS_NM, methodName, uRole);
        userP.deassign(uRole, roleConstraint);
    }

    @Override
    @AdminPermissionOperation
    public void removeRoleConstraint(UserRole uRole, String roleConstraintId) throws SecurityException {
        String methodName = "removeRoleConstraint";
        this.assertContext(CLS_NM, methodName, uRole, 2003);
        VUtil.assertNotNull(uRole.getName(), 5005, CLS_NM + methodName);
        VUtil.assertNotNull(roleConstraintId, 5102, CLS_NM + methodName);
        VUtil.assertNotNull(uRole.getName(), 5005, CLS_NM + methodName);
        this.setEntitySession(CLS_NM, methodName, uRole);
        AdminUtil.canDeassign(uRole.getAdminSession(), new User(uRole.getUserId()), new Role(uRole.getName()), this.contextId);
        boolean found = false;
        User user = new User(uRole.getUserId());
        user.setContextId(this.contextId);
        List<UserRole> userRoles = userP.read(user, true).getRoles();
        block0: for (UserRole ur : userRoles) {
            if (!ur.getName().equals(uRole.getName())) continue;
            List<RoleConstraint> rcs = ur.getRoleConstraints();
            for (RoleConstraint rc : rcs) {
                if (!rc.getId().equals(roleConstraintId)) continue;
                userP.deassign(uRole, rc);
                found = true;
                continue block0;
            }
        }
        if (!found) {
            throw new FinderException(10402, "Role constraint with id " + roleConstraintId + " not found");
        }
    }

    @Override
    @AdminPermissionOperation
    public void deassignUser(UserRole uRole) throws SecurityException {
        String methodName = "deassignUser";
        this.assertContext(CLS_NM, methodName, uRole, 2003);
        Role role = new Role(uRole.getName());
        role.setContextId(this.contextId);
        User user = new User(uRole.getUserId());
        this.setEntitySession(CLS_NM, methodName, uRole);
        AdminUtil.canDeassign(user.getAdminSession(), user, role, this.contextId);
        String dn = userP.deassign(uRole);
        if (Config.getInstance().isRoleOccupant()) {
            this.setAdminData(CLS_NM, methodName, role);
            roleP.deassign(role, dn);
        }
    }

    @Override
    @AdminPermissionOperation
    public Permission addPermission(Permission perm) throws SecurityException {
        String methodName = "addPermission";
        this.assertContext(CLS_NM, methodName, perm, 3009);
        this.setEntitySession(CLS_NM, methodName, perm);
        return permP.add(perm);
    }

    @Override
    @AdminPermissionOperation
    public PermissionAttributeSet addPermissionAttributeSet(PermissionAttributeSet permAttributeSet) throws SecurityException {
        String methodName = "addPermissionAttributeSet";
        this.assertContext(CLS_NM, methodName, permAttributeSet, 3030);
        this.setEntitySession(CLS_NM, methodName, permAttributeSet);
        return permP.add(permAttributeSet);
    }

    @Override
    @AdminPermissionOperation
    public void deletePermissionAttributeSet(PermissionAttributeSet permAttributeSet) throws SecurityException {
        String methodName = "deletePermissionAttributeSet";
        this.assertContext(CLS_NM, methodName, permAttributeSet, 3030);
        this.setEntitySession(CLS_NM, methodName, permAttributeSet);
        permP.delete(permAttributeSet);
    }

    @Override
    @AdminPermissionOperation
    public PermissionAttribute addPermissionAttributeToSet(PermissionAttribute permAttribute, String attributeSetName) throws SecurityException {
        String methodName = "addPermissionAttributeToSet";
        this.assertContext(CLS_NM, methodName, permAttribute, 3032);
        this.setEntitySession(CLS_NM, methodName, permAttribute);
        return permP.add(permAttribute, attributeSetName);
    }

    @Override
    @AdminPermissionOperation
    public void removePermissionAttributeFromSet(PermissionAttribute permAttribute, String attributeSetName) throws SecurityException {
        String methodName = "removePermissionAttributeFromSet";
        this.assertContext(CLS_NM, methodName, permAttribute, 3032);
        this.setEntitySession(CLS_NM, methodName, permAttribute);
        permP.delete(permAttribute, attributeSetName);
    }

    @Override
    @AdminPermissionOperation
    public void updatePermissionAttributeInSet(PermissionAttribute permAttribute, String attributeSetName, boolean replaceValidValues) throws SecurityException {
        String methodName = "updatePermissionAttributeInSet";
        this.assertContext(CLS_NM, methodName, permAttribute, 3032);
        this.setEntitySession(CLS_NM, methodName, permAttribute);
        permP.update(permAttribute, attributeSetName, replaceValidValues);
    }

    @Override
    @AdminPermissionOperation
    public Permission updatePermission(Permission perm) throws SecurityException {
        String methodName = "updatePermission";
        this.assertContext(CLS_NM, methodName, perm, 3009);
        this.setEntitySession(CLS_NM, methodName, perm);
        return permP.update(perm);
    }

    @Override
    @AdminPermissionOperation
    public void deletePermission(Permission perm) throws SecurityException {
        String methodName = "deletePermission";
        this.assertContext(CLS_NM, methodName, perm, 3009);
        this.setEntitySession(CLS_NM, methodName, perm);
        permP.delete(perm);
    }

    @Override
    @AdminPermissionOperation
    public PermObj addPermObj(PermObj pObj) throws SecurityException {
        String methodName = "addPermObj";
        this.assertContext(CLS_NM, methodName, pObj, 3010);
        this.setEntitySession(CLS_NM, methodName, pObj);
        return permP.add(pObj);
    }

    @Override
    @AdminPermissionOperation
    public PermObj updatePermObj(PermObj pObj) throws SecurityException {
        String methodName = "updatePermObj";
        this.assertContext(CLS_NM, methodName, pObj, 3010);
        this.setEntitySession(CLS_NM, methodName, pObj);
        return permP.update(pObj);
    }

    @Override
    @AdminPermissionOperation
    public void deletePermObj(PermObj pObj) throws SecurityException {
        String methodName = "deletePermObj";
        this.assertContext(CLS_NM, methodName, pObj, 3010);
        this.setEntitySession(CLS_NM, methodName, pObj);
        permP.delete(pObj);
    }

    @Override
    @AdminPermissionOperation
    public void grantPermission(Permission perm, Role role) throws SecurityException {
        String methodName = "grantPermission";
        this.assertContext(CLS_NM, methodName, perm, 3009);
        this.assertContext(CLS_NM, methodName, role, 5007);
        this.setEntitySession(CLS_NM, methodName, perm);
        if (perm.isAdmin()) {
            AdminRole adminRole = new AdminRole(role.getName());
            adminRole.setContextId(this.contextId);
            adminP.read(adminRole);
        } else {
            AdminUtil.canGrant(perm.getAdminSession(), role, perm, this.contextId);
            roleP.readConstraints(role);
        }
        permP.grant(perm, role);
    }

    @Override
    @AdminPermissionOperation
    public void revokePermission(Permission perm, Role role) throws SecurityException {
        String methodName = "revokePermission";
        this.assertContext(CLS_NM, methodName, perm, 3009);
        this.assertContext(CLS_NM, methodName, role, 5007);
        this.setEntitySession(CLS_NM, methodName, perm);
        if (!perm.isAdmin()) {
            AdminUtil.canRevoke(perm.getAdminSession(), role, perm, this.contextId);
        }
        permP.revoke(perm, role);
    }

    @Override
    @AdminPermissionOperation
    public void grantPermission(Permission perm, User user) throws SecurityException {
        String methodName = "grantPermissionUser";
        this.assertContext(CLS_NM, methodName, perm, 3009);
        this.setEntitySession(CLS_NM, methodName, perm);
        this.assertContext(CLS_NM, methodName, user, 1008);
        userP.read(user, false);
        permP.grant(perm, user);
    }

    @Override
    @AdminPermissionOperation
    public void revokePermission(Permission perm, User user) throws SecurityException {
        String methodName = "revokePermissionUser";
        this.assertContext(CLS_NM, methodName, perm, 3009);
        this.setEntitySession(CLS_NM, methodName, perm);
        this.assertContext(CLS_NM, methodName, user, 1008);
        permP.revoke(perm, user);
    }

    @Override
    @AdminPermissionOperation
    public void addDescendant(Role parentRole, Role childRole) throws SecurityException {
        String methodName = "addDescendant";
        this.assertContext(CLS_NM, methodName, parentRole, 5013);
        this.assertContext(CLS_NM, methodName, childRole, 5014);
        this.setEntitySession(CLS_NM, methodName, childRole);
        Role role = new Role(parentRole.getName());
        role.setContextId(this.contextId);
        roleP.readConstraints(role);
        RoleUtil.getInstance().validateRelationship(childRole, parentRole, false);
        childRole.setParent(parentRole.getName());
        roleP.add(childRole);
        RoleUtil.getInstance().updateHier(this.contextId, new Relationship(childRole.getName().toUpperCase(), parentRole.getName().toUpperCase()), Hier.Op.ADD);
    }

    @Override
    @AdminPermissionOperation
    public void addAscendant(Role childRole, Role parentRole) throws SecurityException {
        String methodName = "addAscendant";
        this.assertContext(CLS_NM, methodName, parentRole, 5013);
        this.setEntitySession(CLS_NM, methodName, parentRole);
        this.assertContext(CLS_NM, methodName, childRole, 5014);
        Role role = new Role(childRole.getName());
        role.setContextId(this.contextId);
        role = roleP.readConstraints(role);
        role.setContextId(this.contextId);
        RoleUtil.getInstance().validateRelationship(childRole, parentRole, false);
        roleP.add(parentRole);
        Role cRole2 = new Role(childRole.getName());
        cRole2.setParents(role.getParents());
        cRole2.setParent(parentRole.getName());
        cRole2.setContextId(this.contextId);
        this.setAdminData(CLS_NM, methodName, cRole2);
        roleP.update(cRole2);
        RoleUtil.getInstance().updateHier(this.contextId, new Relationship(childRole.getName().toUpperCase(), parentRole.getName().toUpperCase()), Hier.Op.ADD);
    }

    @Override
    @AdminPermissionOperation
    public void addInheritance(Role parentRole, Role childRole) throws SecurityException {
        String methodName = "addInheritance";
        this.assertContext(CLS_NM, methodName, parentRole, 5013);
        this.assertContext(CLS_NM, methodName, childRole, 5014);
        this.setEntitySession(CLS_NM, methodName, parentRole);
        Role pRole = new Role(parentRole.getName());
        pRole.setContextId(this.contextId);
        roleP.readConstraints(pRole);
        Role cRole = new Role(childRole.getName());
        cRole.setContextId(this.contextId);
        cRole = roleP.readConstraints(cRole);
        RoleUtil.getInstance().validateRelationship(childRole, parentRole, false);
        RoleUtil.getInstance().updateHier(this.contextId, new Relationship(childRole.getName().toUpperCase(), parentRole.getName().toUpperCase()), Hier.Op.ADD);
        Role cRole2 = new Role(childRole.getName());
        cRole2.setParents(cRole.getParents());
        cRole2.setParent(parentRole.getName());
        cRole2.setContextId(this.contextId);
        this.setAdminData(CLS_NM, methodName, cRole2);
        roleP.update(cRole2);
    }

    @Override
    @AdminPermissionOperation
    public void deleteInheritance(Role parentRole, Role childRole) throws SecurityException {
        String methodName = "deleteInheritance";
        this.assertContext(CLS_NM, methodName, parentRole, 5013);
        this.setEntitySession(CLS_NM, methodName, parentRole);
        this.assertContext(CLS_NM, methodName, childRole, 5014);
        RoleUtil.getInstance().validateRelationship(childRole, parentRole, true);
        RoleUtil.getInstance().updateHier(this.contextId, new Relationship(childRole.getName().toUpperCase(), parentRole.getName().toUpperCase()), Hier.Op.REM);
        Role cRole = new Role(childRole.getName());
        cRole.setContextId(this.contextId);
        cRole = roleP.read(cRole);
        Role cRole2 = new Role(childRole.getName());
        cRole2.setParents(cRole.getParents());
        cRole2.delParent(parentRole.getName());
        cRole2.setContextId(this.contextId);
        this.setAdminData(CLS_NM, methodName, cRole2);
        if (!CollectionUtils.isNotEmpty(cRole2.getParents())) {
            roleP.deleteParent(cRole2);
        } else {
            roleP.update(cRole2);
        }
    }

    @Override
    @AdminPermissionOperation
    public SDSet createSsdSet(SDSet ssdSet) throws SecurityException {
        String methodName = "createSsdSet";
        this.assertContext(CLS_NM, methodName, ssdSet, 5087);
        this.setEntitySession(CLS_NM, methodName, ssdSet);
        ssdSet.setType(SDSet.SDType.STATIC);
        if (ssdSet.getCardinality() == null) {
            ssdSet.setCardinality(2);
        }
        this.clearSSDCache(ssdSet);
        return sdP.add(ssdSet);
    }

    @Override
    @AdminPermissionOperation
    public SDSet updateSsdSet(SDSet ssdSet) throws SecurityException {
        String methodName = "updateSsdSet";
        this.assertContext(CLS_NM, methodName, ssdSet, 5087);
        this.setEntitySession(CLS_NM, methodName, ssdSet);
        ssdSet.setType(SDSet.SDType.STATIC);
        return sdP.update(ssdSet);
    }

    @Override
    @AdminPermissionOperation
    public SDSet addSsdRoleMember(SDSet ssdSet, Role role) throws SecurityException {
        String methodName = "addSsdRoleMember";
        this.assertContext(CLS_NM, methodName, ssdSet, 5087);
        this.assertContext(CLS_NM, methodName, role, 5007);
        this.setEntitySession(CLS_NM, methodName, ssdSet);
        SDSet entity = sdP.read(ssdSet);
        entity.setContextId(this.contextId);
        entity.addMember(role.getName());
        this.setAdminData(CLS_NM, methodName, entity);
        SDSet ssdOut = sdP.update(entity);
        this.clearSSDCache(role);
        return ssdOut;
    }

    @Override
    @AdminPermissionOperation
    public SDSet deleteSsdRoleMember(SDSet ssdSet, Role role) throws SecurityException {
        String methodName = "deleteSsdRoleMember";
        this.assertContext(CLS_NM, methodName, ssdSet, 5087);
        this.assertContext(CLS_NM, methodName, role, 5007);
        this.setEntitySession(CLS_NM, methodName, ssdSet);
        SDSet entity = sdP.read(ssdSet);
        entity.setContextId(this.contextId);
        entity.delMember(role.getName());
        if (entity.getMembers().isEmpty()) {
            entity.addMember("none");
        }
        this.setAdminData(CLS_NM, methodName, entity);
        SDSet ssdOut = sdP.update(entity);
        this.clearSSDCache(role);
        return ssdOut;
    }

    @Override
    @AdminPermissionOperation
    public SDSet deleteSsdSet(SDSet ssdSet) throws SecurityException {
        String methodName = "deleteSsdSet";
        this.assertContext(CLS_NM, methodName, ssdSet, 5087);
        this.setEntitySession(CLS_NM, methodName, ssdSet);
        ssdSet.setType(SDSet.SDType.STATIC);
        this.clearSSDCache(ssdSet);
        return sdP.delete(ssdSet);
    }

    private void clearSSDCache(SDSet ssdSet) {
        if (ssdSet.getMembers() != null) {
            for (String roleName : ssdSet.getMembers()) {
                SDUtil.getInstance().clearSsdCacheEntry(roleName, this.contextId);
            }
        }
    }

    private void clearSSDCache(Role role) {
        SDUtil.getInstance().clearSsdCacheEntry(role.getName(), this.contextId);
    }

    @Override
    @AdminPermissionOperation
    public SDSet setSsdSetCardinality(SDSet ssdSet, int cardinality) throws SecurityException {
        String methodName = "setSsdSetCardinality";
        this.assertContext(CLS_NM, methodName, ssdSet, 5087);
        this.setEntitySession(CLS_NM, methodName, ssdSet);
        ssdSet.setType(SDSet.SDType.STATIC);
        ssdSet.setCardinality(cardinality);
        this.clearSSDCache(ssdSet);
        return sdP.update(ssdSet);
    }

    @Override
    @AdminPermissionOperation
    public SDSet createDsdSet(SDSet dsdSet) throws SecurityException {
        String methodName = "createDsdSet";
        this.assertContext(CLS_NM, methodName, dsdSet, 5096);
        this.setEntitySession(CLS_NM, methodName, dsdSet);
        dsdSet.setType(SDSet.SDType.DYNAMIC);
        if (dsdSet.getCardinality() == null) {
            dsdSet.setCardinality(2);
        }
        return sdP.add(dsdSet);
    }

    @Override
    @AdminPermissionOperation
    public SDSet updateDsdSet(SDSet dsdSet) throws SecurityException {
        String methodName = "updateDsdSet";
        this.assertContext(CLS_NM, methodName, dsdSet, 5096);
        this.setEntitySession(CLS_NM, methodName, dsdSet);
        dsdSet.setType(SDSet.SDType.DYNAMIC);
        return sdP.update(dsdSet);
    }

    @Override
    @AdminPermissionOperation
    public SDSet addDsdRoleMember(SDSet dsdSet, Role role) throws SecurityException {
        String methodName = "addDsdRoleMember";
        this.assertContext(CLS_NM, methodName, dsdSet, 5096);
        this.assertContext(CLS_NM, methodName, role, 5007);
        this.setEntitySession(CLS_NM, methodName, dsdSet);
        SDSet entity = sdP.read(dsdSet);
        entity.setContextId(this.contextId);
        entity.addMember(role.getName());
        this.setAdminData(CLS_NM, methodName, entity);
        SDSet dsdOut = sdP.update(entity);
        this.clearDSDCache(dsdSet);
        return dsdOut;
    }

    @Override
    @AdminPermissionOperation
    public SDSet deleteDsdRoleMember(SDSet dsdSet, Role role) throws SecurityException {
        String methodName = "deleteDsdRoleMember";
        this.assertContext(CLS_NM, methodName, dsdSet, 5096);
        this.assertContext(CLS_NM, methodName, role, 5007);
        this.setEntitySession(CLS_NM, methodName, dsdSet);
        SDSet entity = sdP.read(dsdSet);
        entity.setContextId(this.contextId);
        entity.delMember(role.getName());
        if (entity.getMembers().isEmpty()) {
            entity.addMember("none");
        }
        this.setAdminData(CLS_NM, methodName, entity);
        SDSet dsdOut = sdP.update(entity);
        this.clearDSDCache(dsdSet);
        return dsdOut;
    }

    @Override
    @AdminPermissionOperation
    public SDSet deleteDsdSet(SDSet dsdSet) throws SecurityException {
        String methodName = "deleteDsdSet";
        this.assertContext(CLS_NM, methodName, dsdSet, 5096);
        this.setEntitySession(CLS_NM, methodName, dsdSet);
        dsdSet.setType(SDSet.SDType.DYNAMIC);
        this.clearDSDCache(dsdSet);
        return sdP.delete(dsdSet);
    }

    @Override
    @AdminPermissionOperation
    public SDSet setDsdSetCardinality(SDSet dsdSet, int cardinality) throws SecurityException {
        String methodName = "setDsdSetCardinality";
        this.assertContext(CLS_NM, methodName, dsdSet, 5096);
        this.setEntitySession(CLS_NM, methodName, dsdSet);
        dsdSet.setType(SDSet.SDType.DYNAMIC);
        dsdSet.setCardinality(cardinality);
        this.clearDSDCache(dsdSet);
        return sdP.update(dsdSet);
    }

    private void clearDSDCache(SDSet dsdSet) {
        SDUtil.getInstance().clearDsdCacheEntry(dsdSet.getName(), this.contextId);
    }
}

