/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core;

import org.apache.commons.lang.StringUtils;
import org.apache.directory.fortress.core.AccessMgr;
import org.apache.directory.fortress.core.Manageable;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.AccessMgrImpl;
import org.apache.directory.fortress.core.rest.AccessMgrRestImpl;
import org.apache.directory.fortress.core.util.ClassUtil;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.VUtil;

public final class AccessMgrFactory {
    private static final String CLS_NM = AccessMgrFactory.class.getName();

    public static AccessMgr createInstance() throws SecurityException {
        return AccessMgrFactory.createInstance("HOME");
    }

    public static AccessMgr createInstance(String contextId) throws SecurityException {
        VUtil.assertNotNull(contextId, 101, CLS_NM + ".createInstance");
        String accessClassName = Config.getInstance().getProperty("accessmgr.implementation");
        Manageable accessMgr = StringUtils.isEmpty((String)accessClassName) ? (Config.getInstance().isRestEnabled() ? new AccessMgrRestImpl() : new AccessMgrImpl()) : (AccessMgr)ClassUtil.createInstance(accessClassName);
        accessMgr.setContextId(contextId);
        return accessMgr;
    }
}

