/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.modifyRequest;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.api.ldap.codec.decorators.ModifyRequestDecorator;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.ModifyResponseImpl;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddModifyRequestAttribute
extends GrammarAction<LdapMessageContainer<ModifyRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(AddModifyRequestAttribute.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public AddModifyRequestAttribute() {
        super("Store Modify request operation type");
    }

    public void action(LdapMessageContainer<ModifyRequestDecorator> container) throws DecoderException {
        ModifyRequestDecorator modifyRequestDecorator = container.getMessage();
        ModifyRequest modifyRequest = (ModifyRequest)modifyRequestDecorator.getDecorated();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err((I18n)I18n.ERR_04083, (Object[])new Object[0]);
            LOG.error(msg);
            ModifyResponseImpl response = new ModifyResponseImpl(modifyRequest.getMessageId());
            throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, modifyRequest.getName(), null);
        }
        String type = Strings.utf8ToString((byte[])tlv.getValue().getData());
        modifyRequestDecorator.addAttributeTypeAndValues(type);
        if (IS_DEBUG) {
            LOG.debug("Modifying type : {}", (Object)type);
        }
    }
}

