/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.addRequest;

import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.AddRequestDecorator;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddAttributeValue
extends GrammarAction<LdapMessageContainer<AddRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(AddAttributeValue.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public AddAttributeValue() {
        super("Store a value");
    }

    @Override
    public void action(LdapMessageContainer<AddRequestDecorator> container) {
        AddRequestDecorator addRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        Object value = null;
        try {
            if (tlv.getLength() == 0) {
                addRequest.addAttributeValue("");
            } else if (container.isBinary(addRequest.getCurrentAttributeType())) {
                value = tlv.getValue().getData();
                if (IS_DEBUG) {
                    LOG.debug("Adding value {}", (Object)Strings.dumpBytes(value));
                }
                addRequest.addAttributeValue((byte[])value);
            } else {
                value = Strings.utf8ToString(tlv.getValue().getData());
                if (IS_DEBUG) {
                    LOG.debug("Adding value {}" + value);
                }
                addRequest.addAttributeValue((String)value);
            }
        }
        catch (LdapException ldapException) {
            // empty catch block
        }
        container.setGrammarEndAllowed(true);
    }
}

