/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.evaluator;

import java.util.Iterator;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.filter.LessEqNode;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.IndexNotFoundException;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.evaluator.LeafEvaluator;

public class LessEqEvaluator<T>
extends LeafEvaluator<T> {
    public LessEqEvaluator(LessEqNode<T> node, Store db, SchemaManager schemaManager) throws LdapException {
        super(node, db, schemaManager);
        if (db.hasIndexOn(this.attributeType)) {
            try {
                this.idx = db.getIndex(this.attributeType);
            }
            catch (IndexNotFoundException infe) {
                throw new LdapOtherException(infe.getMessage(), infe);
            }
        } else {
            this.idx = null;
        }
        MatchingRule mr = this.attributeType.getOrdering();
        if (mr == null) {
            mr = this.attributeType.getEquality();
        }
        if (mr == null) {
            throw new IllegalStateException(I18n.err(I18n.ERR_717, node));
        }
        this.normalizer = mr.getNormalizer();
        this.ldapComparator = mr.getLdapComparator();
    }

    @Override
    public LessEqNode<T> getExpression() {
        return (LessEqNode)this.node;
    }

    @Override
    public boolean evaluate(PartitionTxn partitionTxn, IndexEntry<?, String> indexEntry) throws LdapException {
        Attribute attr;
        Entry entry = indexEntry.getEntry();
        if (null == entry) {
            entry = this.db.fetch(partitionTxn, indexEntry.getId());
            if (null == entry) {
                return false;
            }
            indexEntry.setEntry(entry);
        }
        if ((attr = entry.get(this.attributeType)) != null && this.evaluate(indexEntry, attr)) {
            return true;
        }
        if (this.schemaManager.getAttributeTypeRegistry().hasDescendants(this.attributeType)) {
            Iterator<AttributeType> descendants = this.schemaManager.getAttributeTypeRegistry().descendants(this.attributeType);
            while (descendants.hasNext()) {
                AttributeType descendant = descendants.next();
                attr = entry.get(descendant);
                if (attr == null || !this.evaluate(indexEntry, attr)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean evaluate(Entry entry) throws LdapException {
        Attribute attr = entry.get(this.attributeType);
        if (attr != null && this.evaluate(null, attr)) {
            return true;
        }
        if (this.schemaManager.getAttributeTypeRegistry().hasDescendants(this.attributeType)) {
            Iterator<AttributeType> descendants = this.schemaManager.getAttributeTypeRegistry().descendants(this.attributeType);
            while (descendants.hasNext()) {
                AttributeType descendant = descendants.next();
                attr = entry.get(descendant);
                if (attr == null || !this.evaluate(null, attr)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean evaluate(IndexEntry<Object, String> indexEntry, Attribute attribute) {
        for (Value value : attribute) {
            if (this.ldapComparator.compare(value.getNormalized(), this.node.getValue().getNormalized()) > 0) continue;
            if (indexEntry != null) {
                indexEntry.setKey(value.getString());
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("LessEqEvaluator : ").append(super.toString()).append("\n");
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toString("");
    }
}

