/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.request;

import org.apache.directory.api.ldap.model.message.CompareRequest;
import org.apache.directory.api.ldap.model.message.CompareResponse;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareRequestHandler
extends LdapRequestHandler<CompareRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(CompareRequestHandler.class);

    @Override
    public void handle(LdapSession session, CompareRequest compareRequest) {
        LOG.debug("Handling compare request while ignoring referrals: {}", (Object)compareRequest);
        CompareResponse compareResponse = (CompareResponse)compareRequest.getResultResponse();
        LdapResult result = compareRequest.getResultResponse().getLdapResult();
        try {
            if (session.getCoreSession().compare(compareRequest)) {
                result.setResultCode(ResultCodeEnum.COMPARE_TRUE);
            } else {
                result.setResultCode(ResultCodeEnum.COMPARE_FALSE);
            }
            result.setMatchedDn(compareRequest.getName());
            session.getIoSession().write(compareResponse);
        }
        catch (Exception e) {
            this.handleException(session, compareRequest, compareResponse, e);
        }
    }
}

