/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.AbandonListener;
import org.apache.directory.api.ldap.model.message.AbandonableRequest;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchResultEntry;
import org.apache.directory.api.ldap.model.message.SearchResultEntryImpl;
import org.apache.directory.api.ldap.model.message.controls.ChangeType;
import org.apache.directory.api.ldap.model.message.controls.EntryChangeImpl;
import org.apache.directory.api.ldap.model.message.controls.PersistentSearch;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.entry.ServerEntryUtils;
import org.apache.directory.server.core.api.event.DirectoryListener;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ChangeOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.ldap.LdapSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentSearchListener
implements DirectoryListener,
AbandonListener {
    private static final Logger LOG = LoggerFactory.getLogger(PersistentSearchListener.class);
    final LdapSession session;
    final SearchRequest req;
    final PersistentSearch psearchControl;
    private LookupOperationContext filterCtx;
    private SchemaManager schemaManager;

    public PersistentSearchListener(LdapSession session, SearchRequest req) {
        this.session = session;
        this.req = req;
        req.addAbandonListener(this);
        this.psearchControl = (PersistentSearch)req.getControls().get("2.16.840.1.113730.3.4.3");
        this.filterCtx = new LookupOperationContext(session.getCoreSession(), req.getAttributes().toArray(Strings.EMPTY_STRING_ARRAY));
        this.schemaManager = session.getCoreSession().getDirectoryService().getSchemaManager();
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }

    public void abandon() {
        this.session.getCoreSession().getDirectoryService().getEventService().removeListener(this);
    }

    @Override
    public void requestAbandoned(AbandonableRequest req) {
        this.abandon();
    }

    private void setECResponseControl(SearchResultEntry response, ChangeOperationContext opContext, ChangeType type) {
        if (this.psearchControl.isReturnECs()) {
            EntryChangeImpl ecControl = new EntryChangeImpl();
            ecControl.setChangeType(type);
            if (opContext.getChangeLogEvent() != null) {
                ecControl.setChangeNumber(opContext.getChangeLogEvent().getRevision());
            }
            if (opContext instanceof RenameOperationContext || opContext instanceof MoveOperationContext) {
                ecControl.setPreviousDn(opContext.getDn());
            }
            response.addControl(ecControl);
        }
    }

    @Override
    public void entryAdded(AddOperationContext addContext) {
        if (!this.psearchControl.isNotificationEnabled(ChangeType.ADD)) {
            return;
        }
        SearchResultEntryImpl respEntry = new SearchResultEntryImpl(this.req.getMessageId());
        respEntry.setObjectName(addContext.getDn());
        ClonedServerEntry entry = new ClonedServerEntry(addContext.getEntry());
        this.filterEntry(entry);
        respEntry.setEntry(entry);
        this.setECResponseControl(respEntry, addContext, ChangeType.ADD);
        this.session.getIoSession().write(respEntry);
    }

    @Override
    public void entryDeleted(DeleteOperationContext deleteContext) {
        if (!this.psearchControl.isNotificationEnabled(ChangeType.DELETE)) {
            return;
        }
        SearchResultEntryImpl respEntry = new SearchResultEntryImpl(this.req.getMessageId());
        respEntry.setObjectName(deleteContext.getDn());
        this.filterEntry(deleteContext.getEntry());
        respEntry.setEntry(deleteContext.getEntry());
        this.setECResponseControl(respEntry, deleteContext, ChangeType.DELETE);
        this.session.getIoSession().write(respEntry);
    }

    @Override
    public void entryModified(ModifyOperationContext modifyContext) {
        if (!this.psearchControl.isNotificationEnabled(ChangeType.MODIFY)) {
            return;
        }
        SearchResultEntryImpl respEntry = new SearchResultEntryImpl(this.req.getMessageId());
        respEntry.setObjectName(modifyContext.getDn());
        ClonedServerEntry entry = new ClonedServerEntry(modifyContext.getAlteredEntry());
        this.filterEntry(entry);
        respEntry.setEntry(entry);
        this.setECResponseControl(respEntry, modifyContext, ChangeType.MODIFY);
        this.session.getIoSession().write(respEntry);
    }

    @Override
    public void entryMoved(MoveOperationContext moveContext) {
        if (!this.psearchControl.isNotificationEnabled(ChangeType.MODDN)) {
            return;
        }
        SearchResultEntryImpl respEntry = new SearchResultEntryImpl(this.req.getMessageId());
        respEntry.setObjectName(moveContext.getNewDn());
        ClonedServerEntry entry = new ClonedServerEntry(moveContext.getModifiedEntry());
        this.filterEntry(entry);
        respEntry.setEntry(entry);
        this.setECResponseControl(respEntry, moveContext, ChangeType.MODDN);
        this.session.getIoSession().write(respEntry);
    }

    @Override
    public void entryMovedAndRenamed(MoveAndRenameOperationContext moveAndRenameContext) {
        this.entryRenamed(moveAndRenameContext);
    }

    @Override
    public void entryRenamed(RenameOperationContext renameContext) {
        if (!this.psearchControl.isNotificationEnabled(ChangeType.MODDN)) {
            return;
        }
        SearchResultEntryImpl respEntry = new SearchResultEntryImpl(this.req.getMessageId());
        respEntry.setObjectName(renameContext.getModifiedEntry().getDn());
        ClonedServerEntry entry = new ClonedServerEntry(renameContext.getModifiedEntry());
        this.filterEntry(entry);
        respEntry.setEntry(entry);
        this.setECResponseControl(respEntry, renameContext, ChangeType.MODDN);
        this.session.getIoSession().write(respEntry);
    }

    private void filterEntry(Entry entry) {
        try {
            ServerEntryUtils.filterContents(this.schemaManager, this.filterCtx, entry);
        }
        catch (LdapException e) {
            throw new RuntimeException(e);
        }
    }
}

