/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapReferralException;
import org.apache.directory.api.ldap.model.message.IntermediateResponse;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.ldap.model.message.SearchResultDone;
import org.apache.directory.api.ldap.model.message.SearchResultEntry;
import org.apache.directory.api.ldap.model.message.SearchResultReference;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.ldap.client.api.exception.LdapConnectionTimeOutException;
import org.apache.directory.ldap.client.api.future.SearchFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchCursorImpl
extends AbstractCursor<Response>
implements SearchCursor {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger(Loggers.CURSOR_LOG.getName());
    private SearchFuture future;
    private long timeout;
    private TimeUnit timeUnit;
    private Response response;
    private boolean done;
    private SearchResultDone searchDoneResp;

    public SearchCursorImpl(SearchFuture future, long timeout, TimeUnit timeUnit) {
        if (LOG_CURSOR.isDebugEnabled()) {
            LOG_CURSOR.debug(I18n.msg(I18n.MSG_04170_CREATING_SEARCH_CURSOR, this));
        }
        this.future = future;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    @Override
    public boolean next() throws LdapException, CursorException {
        if (this.done) {
            return false;
        }
        try {
            if (this.future.isCancelled()) {
                this.response = null;
                this.done = true;
                return false;
            }
            this.response = this.future.get(this.timeout, this.timeUnit);
        }
        catch (Exception e) {
            LdapException ldapException = new LdapException(LdapNetworkConnection.NO_RESPONSE_ERROR, e);
            if (!this.future.isCancelled()) {
                this.future.cancel(true);
            }
            try {
                this.close(ldapException);
            }
            catch (IOException ioe) {
                throw new LdapException(ioe.getMessage(), ioe);
            }
            throw ldapException;
        }
        if (this.response == null) {
            this.future.cancel(true);
            throw new LdapConnectionTimeOutException(LdapNetworkConnection.TIME_OUT_ERROR);
        }
        this.done = this.response instanceof SearchResultDone;
        if (this.done) {
            this.searchDoneResp = (SearchResultDone)this.response;
            this.response = null;
        }
        return !this.done;
    }

    @Override
    public Response get() throws InvalidCursorPositionException {
        if (!this.available()) {
            throw new InvalidCursorPositionException();
        }
        return this.response;
    }

    @Override
    public SearchResultDone getSearchResultDone() {
        return this.searchDoneResp;
    }

    @Override
    public boolean available() {
        return this.response != null;
    }

    @Override
    public void close() throws IOException {
        if (LOG_CURSOR.isDebugEnabled()) {
            LOG_CURSOR.debug(I18n.msg(I18n.MSG_04171_CLOSING_SEARCH_CURSOR, this));
        }
        this.close(null);
    }

    @Override
    public void close(Exception cause) throws IOException {
        if (LOG_CURSOR.isDebugEnabled()) {
            LOG_CURSOR.debug(I18n.msg(I18n.MSG_04171_CLOSING_SEARCH_CURSOR, this));
        }
        if (this.done) {
            super.close();
            return;
        }
        if (!this.future.isCancelled()) {
            this.future.cancel(true);
        }
        if (cause != null) {
            super.close(cause);
        } else {
            super.close();
        }
    }

    @Override
    public void after(Response element) throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_13102_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("after( Response element )")));
    }

    @Override
    public void afterLast() throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_13102_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("afterLast()")));
    }

    @Override
    public void before(Response element) throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_13102_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("before( Response element )")));
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_13102_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("beforeFirst()")));
    }

    @Override
    public boolean first() throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_13102_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("first()")));
    }

    @Override
    public boolean last() throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_13102_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("last()")));
    }

    @Override
    public boolean previous() throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_13102_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("previous()")));
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean isReferral() {
        return this.response instanceof SearchResultReference;
    }

    @Override
    public Referral getReferral() throws LdapException {
        if (this.isReferral()) {
            return ((SearchResultReference)this.response).getReferral();
        }
        throw new LdapException();
    }

    @Override
    public boolean isEntry() {
        return this.response instanceof SearchResultEntry;
    }

    @Override
    public Entry getEntry() throws LdapException {
        if (this.isEntry()) {
            return ((SearchResultEntry)this.response).getEntry();
        }
        if (this.isReferral()) {
            Referral referral = ((SearchResultReference)this.response).getReferral();
            throw new LdapReferralException(referral.getLdapUrls());
        }
        throw new LdapException();
    }

    @Override
    public boolean isIntermediate() {
        return this.response instanceof IntermediateResponse;
    }

    @Override
    public IntermediateResponse getIntermediate() throws LdapException {
        if (this.isEntry()) {
            return (IntermediateResponse)this.response;
        }
        throw new LdapException();
    }
}

