/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.api.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.deltaspike.core.api.projectstage.ProjectStage;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.ProjectStageProducer;

public class PropertyLoader {
    public static final int CONFIGURATION_ORDINAL_DEFAULT_VALUE = 100;
    private static final String FILE_EXTENSION = ".properties";
    private static final Logger LOG = Logger.getLogger(PropertyLoader.class.getName());

    private PropertyLoader() {
    }

    public static synchronized Properties getProperties(String propertyFileName) {
        if (propertyFileName == null) {
            throw new IllegalArgumentException("propertyFileName must not be null!");
        }
        try {
            List<Properties> allProperties;
            if (propertyFileName.endsWith(FILE_EXTENSION)) {
                propertyFileName = propertyFileName.substring(0, propertyFileName.length() - FILE_EXTENSION.length());
            }
            if ((allProperties = PropertyLoader.loadAllProperties(propertyFileName)) == null) {
                return null;
            }
            List<Properties> sortedProperties = PropertyLoader.sortProperties(allProperties);
            Properties properties = PropertyLoader.mergeProperties(sortedProperties);
            return properties;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Error while loading the propertyFile " + propertyFileName, e);
            return null;
        }
    }

    private static List<Properties> loadAllProperties(String propertyFileName) throws IOException {
        ClassLoader cl = ClassUtils.getClassLoader(null);
        ArrayList<Properties> properties = new ArrayList<Properties>();
        Enumeration<URL> propertyUrls = cl.getResources(propertyFileName + FILE_EXTENSION);
        while (propertyUrls != null && propertyUrls.hasMoreElements()) {
            URL propertyUrl = propertyUrls.nextElement();
            PropertyLoader.fillProperties(properties, propertyUrl);
        }
        ProjectStage ps = ProjectStageProducer.getInstance().getProjectStage();
        propertyUrls = cl.getResources(propertyFileName + "-" + ps + FILE_EXTENSION);
        while (propertyUrls != null && propertyUrls.hasMoreElements()) {
            URL propertyUrl = propertyUrls.nextElement();
            PropertyLoader.fillProperties(properties, propertyUrl);
        }
        if (properties.isEmpty()) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("could not find any property files with name " + propertyFileName);
            }
            return null;
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillProperties(List<Properties> properties, URL propertyUrl) throws IOException {
        try (InputStream is = null;){
            is = propertyUrl.openStream();
            Properties prop = new Properties();
            prop.load(is);
            properties.add(prop);
            int ordinal = PropertyLoader.getConfigurationOrdinal(prop);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("loading properties with ordinal " + ordinal + " from file " + propertyUrl.getFile());
            }
        }
    }

    private static List<Properties> sortProperties(List<Properties> allProperties) {
        ArrayList<Properties> sortedProperties = new ArrayList<Properties>();
        for (Properties p : allProperties) {
            int listConfigOrder;
            int i;
            int configOrder = PropertyLoader.getConfigurationOrdinal(p);
            for (i = 0; i < sortedProperties.size() && (listConfigOrder = PropertyLoader.getConfigurationOrdinal((Properties)sortedProperties.get(i))) <= configOrder; ++i) {
            }
            sortedProperties.add(i, p);
        }
        return sortedProperties;
    }

    private static int getConfigurationOrdinal(Properties p) {
        int configOrder = 100;
        String configOrderString = p.getProperty("deltaspike_ordinal");
        if (configOrderString != null && configOrderString.length() > 0) {
            try {
                configOrder = Integer.parseInt(configOrderString);
            }
            catch (NumberFormatException nfe) {
                LOG.severe("deltaspike_ordinal must be an integer value!");
                throw nfe;
            }
        }
        return configOrder;
    }

    private static Properties mergeProperties(List<Properties> sortedProperties) {
        Properties mergedProperties = new Properties();
        for (Properties p : sortedProperties) {
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if ("deltaspike_ordinal".equals(key)) continue;
                mergedProperties.setProperty(key, value);
            }
        }
        return mergedProperties;
    }
}

