/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.scope.window.strategy;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Typed;
import javax.faces.context.FacesContext;
import org.apache.deltaspike.core.util.StringUtils;
import org.apache.deltaspike.jsf.impl.scope.window.strategy.AbstractClientWindowStrategy;
import org.apache.deltaspike.jsf.impl.util.ClientWindowHelper;

@Dependent
@Typed(value={LazyWindowStrategy.class})
public class LazyWindowStrategy
extends AbstractClientWindowStrategy {
    @Override
    protected String getOrCreateWindowId(FacesContext facesContext) {
        String windowId = ClientWindowHelper.getInitialRedirectWindowId(facesContext);
        if (StringUtils.isEmpty((String)windowId)) {
            windowId = this.getWindowIdParameter(facesContext);
        }
        boolean post = this.isPost(facesContext);
        if (StringUtils.isEmpty((String)windowId) && post) {
            windowId = this.getWindowIdPostParameter(facesContext);
        }
        if (StringUtils.isEmpty((String)windowId)) {
            if (this.jsfModuleConfig.isInitialRedirectEnabled() && !post) {
                ClientWindowHelper.handleInitialRedirect(facesContext, this.generateNewWindowId());
                facesContext.responseComplete();
                windowId = null;
            } else {
                windowId = this.generateNewWindowId();
            }
        }
        return windowId;
    }

    @Override
    protected Map<String, String> createQueryURLParameters(FacesContext facesContext) {
        String windowId = this.getWindowId(facesContext);
        if (windowId == null) {
            return null;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dswid", windowId);
        return parameters;
    }

    @Override
    protected boolean isSupportClientWindowRenderingMode() {
        return true;
    }

    @Override
    public boolean isInitialRedirectSupported(FacesContext facesContext) {
        return true;
    }
}

