/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.audit;

import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.logging.Level;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.apache.deltaspike.core.util.metadata.AnnotationInstanceProvider;
import org.apache.deltaspike.data.api.audit.CreatedBy;
import org.apache.deltaspike.data.api.audit.CurrentUser;
import org.apache.deltaspike.data.api.audit.ModifiedBy;
import org.apache.deltaspike.data.impl.audit.AuditPropertyException;
import org.apache.deltaspike.data.impl.audit.AuditProvider;
import org.apache.deltaspike.data.impl.property.Property;

class PrincipalProvider
extends AuditProvider {
    @Inject
    private BeanManager manager;

    PrincipalProvider() {
    }

    @Override
    public void prePersist(Object entity) {
        this.updatePrincipal(entity, true);
    }

    @Override
    public void preUpdate(Object entity) {
        this.updatePrincipal(entity, false);
    }

    private void updatePrincipal(Object entity, boolean create) {
        for (Property<Object> property : this.getProperties(entity, CreatedBy.class, ModifiedBy.class, create)) {
            this.setProperty(entity, property, create);
        }
    }

    private void setProperty(Object entity, Property<Object> property, boolean create) {
        try {
            if (!this.isCorrectContext(property, create)) {
                return;
            }
            Object value = this.resolvePrincipal(entity, property);
            property.setValue(entity, value);
            log.log(Level.FINER, "Updated {0} with {1}", new Object[]{this.propertyName(entity, property), value});
        }
        catch (Exception e) {
            throw new AuditPropertyException("Failed to write principal to " + this.propertyName(entity, property), e);
        }
    }

    private boolean isCorrectContext(Property<Object> property, boolean create) {
        ModifiedBy annotation;
        return !create || !property.getAnnotatedElement().isAnnotationPresent(ModifiedBy.class) || (annotation = property.getAnnotatedElement().getAnnotation(ModifiedBy.class)).onCreate();
    }

    protected Object resolvePrincipal(Object entity, Property<Object> property) {
        CurrentUser principal = (CurrentUser)AnnotationInstanceProvider.of(CurrentUser.class);
        Class<Object> propertyClass = property.getJavaClass();
        Set beans = this.manager.getBeans(propertyClass, new Annotation[]{principal});
        if (!beans.isEmpty() && beans.size() == 1) {
            Bean bean = (Bean)beans.iterator().next();
            Object result = this.manager.getReference(bean, propertyClass, this.manager.createCreationalContext((Contextual)bean));
            return result;
        }
        throw new IllegalArgumentException("Principal " + (beans.isEmpty() ? "not found" : "not unique") + " for " + this.propertyName(entity, property));
    }
}

