/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.scope.mapped;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.RequestScoped;
import javax.faces.bean.ViewScoped;
import org.apache.deltaspike.core.api.projectstage.ProjectStage;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.ProjectStageProducer;
import org.apache.deltaspike.jsf.impl.scope.mapped.Jsf2BeanWrapper;
import org.apache.deltaspike.jsf.impl.util.JsfUtils;

public class MappedJsf2ScopeExtension
implements Extension,
Deactivatable {
    private boolean isActivated = true;
    private final Logger logger = Logger.getLogger(MappedJsf2ScopeExtension.class.getName());
    private Map<Class<? extends Annotation>, Class<? extends Annotation>> mappedJsfScopes = new HashMap<Class<? extends Annotation>, Class<? extends Annotation>>();

    public MappedJsf2ScopeExtension() {
        if (ClassUtils.tryToLoadClassForName((String)"javax.faces.bean.ApplicationScoped") != null) {
            this.mappedJsfScopes.put(javax.faces.bean.ApplicationScoped.class, ApplicationScoped.class);
            this.mappedJsfScopes.put(javax.faces.bean.SessionScoped.class, SessionScoped.class);
            this.mappedJsfScopes.put(RequestScoped.class, javax.enterprise.context.RequestScoped.class);
            if (JsfUtils.isViewScopeDelegationEnabled()) {
                this.mappedJsfScopes.put(ViewScoped.class, ClassUtils.tryToLoadClassForName((String)"javax.faces.view.ViewScoped"));
            }
        }
    }

    protected void init(@Observes BeforeBeanDiscovery beforeBeanDiscovery) {
        this.isActivated = ClassDeactivationUtils.isActivated(this.getClass());
    }

    protected void convertJsf2Scopes(@Observes ProcessAnnotatedType processAnnotatedType) {
        if (!this.isActivated) {
            return;
        }
        Class<? extends Annotation> jsf2ScopeAnnotation = this.getJsf2ScopeAnnotation(processAnnotatedType);
        if (jsf2ScopeAnnotation != null && !this.isBeanWithManagedBeanAnnotation(processAnnotatedType)) {
            processAnnotatedType.setAnnotatedType(this.convertBean(processAnnotatedType.getAnnotatedType(), jsf2ScopeAnnotation));
        }
    }

    private Class<? extends Annotation> getJsf2ScopeAnnotation(ProcessAnnotatedType processAnnotatedType) {
        for (Class<? extends Annotation> currentJsfScope : this.mappedJsfScopes.keySet()) {
            if (!processAnnotatedType.getAnnotatedType().getJavaClass().isAnnotationPresent(currentJsfScope)) continue;
            return currentJsfScope;
        }
        return null;
    }

    private boolean isBeanWithManagedBeanAnnotation(ProcessAnnotatedType processAnnotatedType) {
        Class beanClass = processAnnotatedType.getAnnotatedType().getJavaClass();
        return beanClass.isAnnotationPresent(ManagedBean.class);
    }

    private AnnotatedType convertBean(AnnotatedType annotatedType, Class<? extends Annotation> jsf2ScopeAnnotation) {
        this.logConvertedBean(annotatedType, jsf2ScopeAnnotation);
        return new Jsf2BeanWrapper(annotatedType, this.mappedJsfScopes.get(jsf2ScopeAnnotation), jsf2ScopeAnnotation);
    }

    private void logConvertedBean(AnnotatedType annotatedType, Class<? extends Annotation> jsf2ScopeAnnotation) {
        ProjectStage projectStage = ProjectStageProducer.getInstance().getProjectStage();
        if (projectStage == ProjectStage.Development) {
            this.logger.info("JSF2 bean was converted to a CDI bean. Type: " + annotatedType.getJavaClass().getName() + " original scope: " + jsf2ScopeAnnotation.getName());
        }
    }
}

