/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.listener.request;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.lifecycle.ClientWindow;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleWrapper;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.ExceptionUtils;
import org.apache.deltaspike.jsf.impl.listener.request.DeltaSpikeLifecycleWrapper;
import org.apache.deltaspike.jsf.impl.scope.window.ClientWindowAdapter;
import org.apache.deltaspike.jsf.spi.scope.window.ClientWindowConfig;

public class JsfClientWindowAwareLifecycleWrapper
extends LifecycleWrapper {
    private final Lifecycle wrapped;
    private volatile Boolean initialized;
    private ClientWindowConfig clientWindowConfig;

    public JsfClientWindowAwareLifecycleWrapper(Lifecycle wrapped) {
        this.wrapped = wrapped;
    }

    public Lifecycle getWrapped() {
        return this.wrapped;
    }

    public void attachWindow(FacesContext facesContext) {
        this.lazyInit();
        boolean delegateWindowHandling = ClientWindowConfig.ClientWindowRenderMode.DELEGATED.equals((Object)this.clientWindowConfig.getClientWindowRenderMode(facesContext));
        if (delegateWindowHandling) {
            try {
                Lifecycle externalWrapper = ((DeltaSpikeLifecycleWrapper)this.wrapped).getWrapped();
                JsfClientWindowAwareLifecycleWrapper.delegateAttachWindow(facesContext, externalWrapper);
            }
            catch (Exception e) {
                try {
                    this.attachWindowOnUnwrappedInstance(facesContext, this.wrapped);
                }
                catch (Exception e1) {
                    throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
                }
            }
        } else {
            org.apache.deltaspike.jsf.spi.scope.window.ClientWindow clientWindow = (org.apache.deltaspike.jsf.spi.scope.window.ClientWindow)BeanProvider.getContextualReference(org.apache.deltaspike.jsf.spi.scope.window.ClientWindow.class, (Annotation[])new Annotation[0]);
            String windowId = clientWindow.getWindowId(facesContext);
            if (!facesContext.getResponseComplete() && !"default".equals(windowId)) {
                facesContext.getExternalContext().setClientWindow((ClientWindow)new ClientWindowAdapter(clientWindow));
            }
        }
    }

    private void attachWindowOnUnwrappedInstance(FacesContext facesContext, Lifecycle wrapped) throws Exception {
        Lifecycle wrappedLifecycle = null;
        if (wrapped instanceof LifecycleWrapper) {
            wrappedLifecycle = ((LifecycleWrapper)wrapped).getWrapped();
        }
        if (wrappedLifecycle == null) {
            for (Field field : wrapped.getClass().getDeclaredFields()) {
                if (!Lifecycle.class.isAssignableFrom(field.getType())) continue;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                wrappedLifecycle = (Lifecycle)field.get(wrapped);
                break;
            }
        }
        if (wrappedLifecycle != null) {
            try {
                JsfClientWindowAwareLifecycleWrapper.delegateAttachWindow(facesContext, wrappedLifecycle);
            }
            catch (Exception e) {
                this.attachWindowOnUnwrappedInstance(facesContext, wrappedLifecycle);
            }
        }
    }

    private static void delegateAttachWindow(FacesContext facesContext, Lifecycle lifecycle) throws Exception {
        if (lifecycle instanceof LifecycleWrapper || lifecycle.getClass().getDeclaredMethod("attachWindow", FacesContext.class) != null) {
            lifecycle.attachWindow(facesContext);
        }
    }

    public void render(FacesContext facesContext) throws FacesException {
        this.lazyInit();
        boolean delegateWindowHandling = ClientWindowConfig.ClientWindowRenderMode.DELEGATED.equals((Object)this.clientWindowConfig.getClientWindowRenderMode(facesContext));
        if (!delegateWindowHandling && facesContext.getExternalContext().getClientWindow() != null) {
            facesContext.getExternalContext().getClientWindow().disableClientWindowRenderMode(facesContext);
        }
        super.render(facesContext);
    }

    private void lazyInit() {
        if (this.initialized == null) {
            this.init();
        }
    }

    private synchronized void init() {
        if (this.initialized == null) {
            this.clientWindowConfig = (ClientWindowConfig)BeanProvider.getContextualReference(ClientWindowConfig.class, (Annotation[])new Annotation[0]);
            this.initialized = true;
        }
    }
}

