/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.testcontrol.impl.mock;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.deltaspike.testcontrol.api.junit.TestBaseConfig;
import org.apache.deltaspike.testcontrol.spi.mock.MockFilter;

public class DefaultMockFilter
implements MockFilter {
    private static final Logger LOG = Logger.getLogger(DefaultMockFilter.class.getName());
    private static final String DS_BASE_PACKAGE = "org.apache.deltaspike.";
    private static final String JAVA_BASE_PACKAGE = "java.";
    private static final String JAVAX_BASE_PACKAGE = "javax.";
    private static final String EJB_BASE_PACKAGE = "javax.ejb.";
    private static final String OWB_BASE_PACKAGE = "org.apache.webbeans.";
    private static final String WELD_BASE_PACKAGE = "org.jboss.weld.";

    public boolean isMockedImplementationSupported(BeanManager beanManager, Annotated annotated) {
        if (!this.isMockSupportEnabled(annotated)) {
            return false;
        }
        Class<?> origin = null;
        if (annotated instanceof AnnotatedType) {
            origin = ((AnnotatedType)annotated).getJavaClass();
            HashSet<Annotation> annotations = new HashSet<Annotation>();
            annotations.addAll(annotated.getAnnotations());
            for (AnnotatedMethod annotatedMethod : ((AnnotatedType)annotated).getMethods()) {
                annotations.addAll(annotatedMethod.getAnnotations());
            }
            if (this.isEjbOrAnnotatedTypeWithInterceptorAnnotation(beanManager, annotations, origin.getName())) {
                return false;
            }
        } else if (annotated instanceof AnnotatedMember) {
            Member member = ((AnnotatedMember)annotated).getJavaMember();
            origin = member.getDeclaringClass();
            if (this.isEjbOrAnnotatedTypeWithInterceptorAnnotation(beanManager, annotated.getAnnotations(), member.toString())) {
                return false;
            }
        }
        if (origin != null && origin.getPackage() == null) {
            LOG.warning("Please don't use the default-package for " + origin.getName());
            return true;
        }
        return origin != null && !this.isInternalPackage(origin.getPackage().getName());
    }

    protected boolean isMockSupportEnabled(Annotated annotated) {
        if ((annotated instanceof AnnotatedMethod || annotated instanceof AnnotatedField) && annotated.getAnnotation(Produces.class) != null) {
            return TestBaseConfig.MockIntegration.ALLOW_MOCKED_PRODUCERS;
        }
        return TestBaseConfig.MockIntegration.ALLOW_MOCKED_BEANS;
    }

    protected boolean isEjbOrAnnotatedTypeWithInterceptorAnnotation(BeanManager beanManager, Set<Annotation> annotations, String origin) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType().getName().startsWith(EJB_BASE_PACKAGE)) {
                return true;
            }
            if (this.isStandardAnnotation(annotation) || !beanManager.isInterceptorBinding(annotation.annotationType()) && (!beanManager.isStereotype(annotation.annotationType()) || !this.isStereotypeWithInterceptor(annotation, beanManager))) continue;
            LOG.warning("Skip mocking intercepted bean " + origin);
            return true;
        }
        return false;
    }

    protected boolean isStereotypeWithInterceptor(Annotation stereotypeAnnotation, BeanManager beanManager) {
        for (Annotation annotation : stereotypeAnnotation.annotationType().getAnnotations()) {
            if (this.isStandardAnnotation(annotation) || !beanManager.isInterceptorBinding(annotation.annotationType()) && !this.isStereotypeWithInterceptor(annotation, beanManager)) continue;
            return true;
        }
        return false;
    }

    protected boolean isStandardAnnotation(Annotation annotation) {
        return annotation.annotationType().getName().startsWith(JAVA_BASE_PACKAGE) || annotation.annotationType().getName().startsWith(JAVAX_BASE_PACKAGE);
    }

    protected boolean isInternalPackage(String packageName) {
        return packageName.startsWith(OWB_BASE_PACKAGE) || packageName.startsWith(WELD_BASE_PACKAGE) || this.isDeltaSpikePackage(packageName);
    }

    protected boolean isDeltaSpikePackage(String packageName) {
        return packageName.startsWith(DS_BASE_PACKAGE);
    }
}

