/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.outlet.java;

import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.torque.generator.GeneratorException;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.outlet.OutletImpl;
import org.apache.torque.generator.outlet.OutletResult;
import org.apache.torque.generator.qname.QualifiedName;

public class JavadocOutlet
extends OutletImpl {
    public static final String BODY_MERGEPOINT_NAME = "body";
    public static final String ATTRIBUTES_MERGEPOINT_NAME = "attributes";
    private static final String START_LINE = "/**";
    private static final String MID_LINE_START = " * ";
    private static final String END_LINE = " */";
    private static final String JAVADOC_ATTRIBUTE_START = "@";
    private static final int DEFAULT_MAX_LINEWIDTH = 80;
    private String lineBreak = "\n";
    private int maxLineLength = 80;
    private String indent = "    ";
    private String removableWrapCharacters = " ";
    private String wrapAfterCharacters = ".;,-";

    public JavadocOutlet(QualifiedName qualifiedName) {
        super(qualifiedName);
    }

    @Override
    public OutletResult execute(ControllerState controllerState) throws GeneratorException {
        StringBuilder result = new StringBuilder();
        result.append(this.indent).append(START_LINE).append(this.lineBreak);
        String body = this.mergepoint(BODY_MERGEPOINT_NAME, controllerState);
        result.append(this.wrapLinesAndIndent(body));
        String attributes = this.mergepoint(ATTRIBUTES_MERGEPOINT_NAME, controllerState);
        if (!StringUtils.isEmpty((CharSequence)attributes) && !StringUtils.isEmpty((CharSequence)body)) {
            result.append(this.indent).append(" *").append(this.lineBreak);
        }
        if (!StringUtils.isEmpty((CharSequence)attributes)) {
            result.append(this.wrapLinesAndIndent(attributes));
        }
        result.append(this.indent).append(END_LINE).append(this.lineBreak);
        return new OutletResult(result.toString());
    }

    String wrapLinesAndIndent(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return "";
        }
        StringTokenizer tokenizer = new StringTokenizer(content.trim(), this.removableWrapCharacters + this.wrapAfterCharacters + "\r\n@", true);
        StringBuilder result = new StringBuilder();
        result.append(this.indent).append(MID_LINE_START);
        int currentLineLength = this.indent.length() + MID_LINE_START.length();
        boolean lineBreakPossible = false;
        boolean lastCharRemovable = true;
        String token = null;
        Object currentIndent = this.indent + MID_LINE_START;
        String lastJavadocAttribute = null;
        while (tokenizer.hasMoreTokens() || token != null) {
            if (token == null) {
                token = tokenizer.nextToken();
            }
            if ("\r".equals(token)) {
                token = null;
                continue;
            }
            if ("\n".equals(token)) {
                result.append(this.lineBreak);
                lineBreakPossible = false;
                lastCharRemovable = true;
                if (tokenizer.hasMoreTokens()) {
                    result.append((String)currentIndent);
                    currentLineLength = ((String)currentIndent).length();
                }
                token = null;
                continue;
            }
            if (JAVADOC_ATTRIBUTE_START.equals(token)) {
                if (tokenizer.hasMoreTokens()) {
                    token = tokenizer.nextToken();
                    currentIndent = StringUtils.rightPad((String)(this.indent + MID_LINE_START), (int)(this.indent.length() + MID_LINE_START.length() + 2 + token.length()));
                    if (result.length() > this.indent.length() + MID_LINE_START.length()) {
                        JavadocOutlet.removeEnd(result, " \r\n");
                        boolean alreadyIndented = false;
                        if (result.toString().endsWith(this.indent + " *")) {
                            alreadyIndented = true;
                        }
                        boolean doubleLineBreak = false;
                        if (!token.equals(lastJavadocAttribute)) {
                            doubleLineBreak = true;
                        }
                        if (!alreadyIndented) {
                            result.append(this.lineBreak).append(this.indent).append(" *");
                        }
                        if (doubleLineBreak) {
                            result.append(this.lineBreak).append(this.indent).append(" *");
                        }
                        result.append(" ");
                    }
                    currentLineLength = this.indent.length() + MID_LINE_START.length();
                    lastJavadocAttribute = token;
                }
                result.append(JAVADOC_ATTRIBUTE_START);
                ++currentLineLength;
                lineBreakPossible = false;
                lastCharRemovable = false;
                continue;
            }
            if (this.maxLineLength == -1) {
                result.append(token);
                token = null;
                continue;
            }
            if (this.removableWrapCharacters.indexOf(token) != -1) {
                if (currentLineLength + 1 > this.maxLineLength) {
                    result.append(this.lineBreak);
                    if (tokenizer.hasMoreTokens()) {
                        result.append((String)currentIndent);
                        currentLineLength = ((String)currentIndent).length();
                    }
                    lineBreakPossible = false;
                    lastCharRemovable = false;
                } else {
                    result.append(token);
                    ++currentLineLength;
                    lineBreakPossible = true;
                    lastCharRemovable = true;
                }
                token = null;
                continue;
            }
            if (lineBreakPossible) {
                int unbreakableChunkSize;
                String nextToken = null;
                if (tokenizer.hasMoreTokens()) {
                    nextToken = tokenizer.nextToken();
                }
                if (currentLineLength + (unbreakableChunkSize = nextToken == null || "\r".equals(nextToken) || "\n".equals(nextToken) || this.wrapAfterCharacters.contains(token) || JAVADOC_ATTRIBUTE_START.equals(nextToken) || this.removableWrapCharacters.contains(nextToken) ? token.length() : token.length() + nextToken.length()) > this.maxLineLength) {
                    if (lastCharRemovable) {
                        result.replace(result.length() - 1, result.length(), "");
                    }
                    result.append(this.lineBreak).append((String)currentIndent).append(token);
                    currentLineLength = ((String)currentIndent).length() + token.length();
                } else {
                    result.append(token);
                    currentLineLength += token.length();
                }
                lastCharRemovable = false;
                lineBreakPossible = this.wrapAfterCharacters.contains(token);
                token = nextToken;
                continue;
            }
            result.append(token);
            currentLineLength += token.length();
            lastCharRemovable = false;
            lineBreakPossible = this.wrapAfterCharacters.contains(token);
            token = null;
        }
        if (!result.toString().endsWith(this.lineBreak)) {
            result.append(this.lineBreak);
        }
        return result.toString();
    }

    public String getLineBreak() {
        return this.lineBreak;
    }

    public void setLineBreak(String lineBreak) {
        if (!"\r".equals(lineBreak) && !"\r\n".equals(lineBreak)) {
            throw new IllegalArgumentException("lineBreak must be either \\r or \\r\\n");
        }
        this.lineBreak = lineBreak;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public void setMaxLineLength(int maxLineLength) {
        this.maxLineLength = maxLineLength;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public String getRemovableWrapCharacters() {
        return this.removableWrapCharacters;
    }

    public void setRemovableWrapCharacters(String removableWrapCharacters) {
        this.removableWrapCharacters = removableWrapCharacters;
    }

    public String getWrapAfterCharacters() {
        return this.wrapAfterCharacters;
    }

    public void setWrapAfterCharacters(String wrapAfterCharacters) {
        this.wrapAfterCharacters = wrapAfterCharacters;
    }

    static void removeEnd(StringBuilder stringBuilder, String removeChars) {
        int index;
        HashSet<Character> removeCharSet = new HashSet<Character>();
        for (char character : removeChars.toCharArray()) {
            removeCharSet.add(Character.valueOf(character));
        }
        for (index = stringBuilder.length(); index > 0 && removeCharSet.contains(Character.valueOf(stringBuilder.charAt(index - 1))); --index) {
        }
        stringBuilder.replace(index, stringBuilder.length(), "");
    }
}

