/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.adapter;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.torque.adapter.AbstractAdapter;
import org.apache.torque.adapter.IDMethod;
import org.apache.torque.sql.Query;

public class MysqlAdapter
extends AbstractAdapter {
    private static final long serialVersionUID = 7547291410802807010L;

    protected MysqlAdapter() {
    }

    @Override
    public String toUpperCase(String in) {
        return in;
    }

    @Override
    public String ignoreCase(String in) {
        return in;
    }

    @Override
    public IDMethod getIDMethodType() {
        return IDMethod.AUTO_INCREMENT;
    }

    @Override
    public String getIDMethodSQL(Object obj) {
        return "SELECT LAST_INSERT_ID()";
    }

    @Override
    public void lockTable(Connection con, String table) throws SQLException {
        try (Statement statement = con.createStatement();){
            StringBuilder stmt = new StringBuilder();
            stmt.append("LOCK TABLE ").append(table).append(" WRITE");
            statement.executeUpdate(stmt.toString());
        }
    }

    @Override
    public void unlockTable(Connection con, String table) throws SQLException {
        try (Statement statement = con.createStatement();){
            statement.executeUpdate("UNLOCK TABLES");
        }
    }

    @Override
    public void generateLimits(Query query, long offset, int limit) {
        if (offset > 0L) {
            if (limit >= 0) {
                query.setLimit(Integer.toString(limit));
            } else {
                query.setLimit("18446744073709551615");
            }
            query.setOffset(Long.toString(offset));
        } else if (limit >= 0) {
            query.setLimit(Integer.toString(limit));
        }
        query.setPreLimit(null);
        query.setPostLimit(null);
    }
}

