/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.lateral;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.jcs.auxiliary.AbstractAuxiliaryCacheMonitor;
import org.apache.commons.jcs.auxiliary.lateral.LateralCacheNoWait;
import org.apache.commons.jcs.auxiliary.lateral.socket.tcp.LateralTCPCacheFactory;
import org.apache.commons.jcs.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.commons.jcs.engine.CacheStatus;
import org.apache.commons.jcs.engine.ZombieCacheServiceNonLocal;
import org.apache.commons.jcs.engine.behavior.ICacheServiceNonLocal;

public class LateralCacheMonitor
extends AbstractAuxiliaryCacheMonitor {
    private ConcurrentHashMap<String, LateralCacheNoWait<?, ?>> caches;
    private LateralTCPCacheFactory factory;

    protected static void forceShortIdlePeriod(long idlePeriod) {
        LateralCacheMonitor.idlePeriod = idlePeriod;
    }

    public LateralCacheMonitor(LateralTCPCacheFactory factory) {
        super("JCS-LateralCacheMonitor");
        this.factory = factory;
        this.caches = new ConcurrentHashMap();
        LateralCacheMonitor.setIdlePeriod(20000L);
    }

    public void addCache(LateralCacheNoWait<?, ?> cache) {
        this.caches.put(cache.getCacheName(), cache);
        if (this.getState() == Thread.State.NEW) {
            this.start();
        }
    }

    @Override
    public void dispose() {
        this.caches.clear();
    }

    @Override
    public void doWork() {
        this.log.info((Object)("Number of caches to monitor = " + this.caches.size()));
        for (Map.Entry<String, LateralCacheNoWait<?, ?>> entry : this.caches.entrySet()) {
            String cacheName = entry.getKey();
            LateralCacheNoWait<?, ?> c = entry.getValue();
            if (c.getStatus() != CacheStatus.ERROR) continue;
            this.log.info((Object)("Found LateralCacheNoWait in error, " + cacheName));
            ITCPLateralCacheAttributes lca = (ITCPLateralCacheAttributes)c.getAuxiliaryCacheAttributes();
            ICacheServiceNonLocal cacheService = this.factory.getCSNLInstance(lca);
            if (cacheService instanceof ZombieCacheServiceNonLocal) continue;
            c.fixCache(cacheService);
        }
    }
}

