/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;

public class FileUtils {
    public static final int NONE = 0;
    public static final int RECURSIVE = 1;
    public static final int RETRY = 2;
    public static final int SKIP_MISSING = 4;
    public static final int IGNORE_ERRORS = 8;

    public static void delete(File f) throws IOException {
        FileUtils.delete(f, 0);
    }

    public static void delete(File f, int options) throws IOException {
        File[] items;
        if ((options & 4) != 0 && !f.exists()) {
            return;
        }
        if ((options & 1) != 0 && f.isDirectory() && (items = f.listFiles()) != null) {
            for (File c : items) {
                FileUtils.delete(c, options);
            }
        }
        if (!f.delete()) {
            if ((options & 2) != 0 && f.exists()) {
                for (int i = 1; i < 10; ++i) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!f.delete()) continue;
                    return;
                }
            }
            if ((options & 8) == 0) {
                throw new IOException(MessageFormat.format(JGitText.get().deleteFileFailed, f.getAbsolutePath()));
            }
        }
    }

    public static void mkdir(File d) throws IOException {
        FileUtils.mkdir(d, false);
    }

    public static void mkdir(File d, boolean skipExisting) throws IOException {
        if (!d.mkdir()) {
            if (skipExisting && d.isDirectory()) {
                return;
            }
            throw new IOException(MessageFormat.format(JGitText.get().mkDirFailed, d.getAbsolutePath()));
        }
    }

    public static void mkdirs(File d) throws IOException {
        FileUtils.mkdirs(d, false);
    }

    public static void mkdirs(File d, boolean skipExisting) throws IOException {
        if (!d.mkdirs()) {
            if (skipExisting && d.isDirectory()) {
                return;
            }
            throw new IOException(MessageFormat.format(JGitText.get().mkDirsFailed, d.getAbsolutePath()));
        }
    }

    public static void createNewFile(File f) throws IOException {
        if (!f.createNewFile()) {
            throw new IOException(MessageFormat.format(JGitText.get().createNewFileFailed, f));
        }
    }
}

