/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLException;
import org.apache.derby.impl.drda.NetworkServerControlImpl;

final class ClientThread
extends Thread {
    NetworkServerControlImpl parent;
    ServerSocket serverSocket;
    private int timeSlice;

    ClientThread(NetworkServerControlImpl networkServerControlImpl, ServerSocket serverSocket) {
        super(NetworkServerControlImpl.getUniqueThreadName("NetworkServerThread"));
        this.parent = networkServerControlImpl;
        this.serverSocket = serverSocket;
        this.timeSlice = networkServerControlImpl.getTimeSlice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Socket socket = null;
        block11: while (true) {
            try {
                while (true) {
                    try {
                        socket = this.acceptClientWithRetry();
                        if (this.parent.getShutdown()) {
                            if (socket != null) {
                                socket.close();
                            }
                            return;
                        }
                        socket.setKeepAlive(this.parent.getKeepAlive());
                        if (this.timeSlice > 0) {
                            socket.setSoTimeout(this.timeSlice);
                        }
                        this.parent.addSession(socket);
                        continue block11;
                    }
                    catch (InterruptedException interruptedException) {
                        if (this.parent.getShutdown()) {
                            socket.close();
                            return;
                        }
                        this.parent.consoleExceptionPrintTrace(interruptedException);
                        if (socket == null) continue;
                        socket.close();
                        continue;
                    }
                    catch (SSLException sSLException) {
                        this.parent.consoleExceptionPrintTrace(sSLException);
                        this.parent.directShutdownInternal();
                        return;
                    }
                    catch (IOException iOException) {
                        if (socket != null) {
                            socket.close();
                        }
                        Object object = this.parent.getShutdownSync();
                        synchronized (object) {
                            if (this.parent.getShutdown()) {
                                return;
                            }
                        }
                        this.parent.consoleExceptionPrintTrace(iOException);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                this.parent.consoleExceptionPrintTrace(exception);
                try {
                    if (socket == null) continue;
                    socket.close();
                    continue;
                }
                catch (IOException iOException) {
                    this.parent.consoleExceptionPrintTrace(iOException);
                    continue;
                }
            }
            break;
        }
    }

    private Socket acceptClientWithRetry() {
        for (int i = 1; i <= 3; ++i) {
            try {
                return this.serverSocket.accept();
            }
            catch (Exception exception) {
                if (this.parent.getShutdown()) continue;
                this.parent.consoleExceptionPrintTrace(exception);
                if (i == 3) {
                    this.parent.directShutdownInternal();
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    this.parent.consoleExceptionPrintTrace(interruptedException);
                }
                continue;
            }
        }
        return null;
    }
}

