/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SQLAuthorizationPropTest
extends BaseJDBCTestCase {
    public SQLAuthorizationPropTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite(SQLAuthorizationPropTest.class, "SQLAuthorizationPropTest");
        Properties properties = new Properties();
        properties.setProperty("derby.database.sqlAuthorization", "true");
        SQLAuthorizationPropTest sQLAuthorizationPropTest = new SQLAuthorizationPropTest("grantRevokeAfterSettingSQLAuthProperty");
        baseTestSuite.addTest((Test)new DatabasePropertyTestSetup((Test)sQLAuthorizationPropTest, properties, true));
        baseTestSuite.addTest((Test)new SQLAuthorizationPropTest("resetSQLAuthProperty"));
        return TestConfiguration.singleUseDatabaseDecorator((Test)baseTestSuite);
    }

    protected void setUp() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table GR_TAB (id int)");
        statement.close();
    }

    @Override
    protected void tearDown() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("drop table GR_TAB");
        statement.close();
        super.tearDown();
    }

    public void testGrantRevokeWithoutSQLAuthProperty() throws SQLException {
        Statement statement = this.createStatement();
        try {
            statement.execute("grant select on GR_TAB to some_user");
            SQLAuthorizationPropTest.fail((String)"FAIL: Grant statement should have failed when SQL authorization is not set");
        }
        catch (SQLException sQLException) {
            SQLAuthorizationPropTest.assertSQLState("42Z60", sQLException);
        }
        try {
            statement.execute("revoke select on GR_TAB from some_user");
            SQLAuthorizationPropTest.fail((String)"FAIL: Revoke statement should have failed when SQL authorization is not set");
        }
        catch (SQLException sQLException) {
            SQLAuthorizationPropTest.assertSQLState("42Z60", sQLException);
        }
        statement.close();
    }

    public void grantRevokeAfterSettingSQLAuthProperty() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("grant select on GR_TAB to some_user");
        statement.execute("revoke select on GR_TAB from some_user");
        statement.close();
    }

    public void resetSQLAuthProperty() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        CallableStatement callableStatement = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)");
        callableStatement.setString(1, "derby.database.sqlAuthorization");
        this.testPropertyReset(callableStatement, "false");
        this.testPropertyReset(callableStatement, null);
        this.testPropertyReset(callableStatement, "some_value");
        this.testPropertyReset(callableStatement, "true");
        callableStatement.close();
    }

    private void testPropertyReset(CallableStatement callableStatement, String string) throws SQLException {
        callableStatement.setString(2, string);
        try {
            callableStatement.executeUpdate();
            if (string.compareToIgnoreCase("true") != 0) {
                SQLAuthorizationPropTest.fail((String)"FAIL: Should not be possible to reset sql authorization once it has been turned on");
            }
        }
        catch (SQLException sQLException) {
            SQLAuthorizationPropTest.assertSQLState("XCY02", sQLException);
        }
    }

    public void test_5838() throws Exception {
        Statement statement = this.createStatement();
        SQLAuthorizationPropTest.assertStatementError("XCY02", statement, "call syscs_util.syscs_set_database_property( 'DataDictionaryVersion', 'foobar' )");
    }
}

