/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import org.apache.derby.agg.Aggregator;

public class ModeAggregate
implements Aggregator<Integer, Integer, ModeAggregate> {
    private HashMap<Integer, Accumulator> _accumulators;

    public void init() {
        this._accumulators = new HashMap();
    }

    public void accumulate(Integer n) {
        this.getAccumulator(n).add(1);
    }

    public void merge(ModeAggregate modeAggregate) {
        HashMap<Integer, Accumulator> hashMap = modeAggregate._accumulators;
        for (Integer n : hashMap.keySet()) {
            this.getAccumulator(n).add(hashMap.get(n).getCount());
        }
    }

    public Integer terminate() {
        return this._accumulators.isEmpty() ? null : Collections.max(this._accumulators.values()).getValue();
    }

    private Accumulator getAccumulator(Integer n) {
        Accumulator accumulator = this._accumulators.get(n);
        if (accumulator == null) {
            accumulator = new Accumulator(n);
            this._accumulators.put(n, accumulator);
        }
        return accumulator;
    }

    public static final class Accumulator
    implements Comparable<Accumulator>,
    Serializable {
        private Integer _value;
        private int _count;

        public Accumulator(Integer n) {
            this._value = n;
            this._count = 0;
        }

        public void add(int n) {
            this._count += n;
        }

        public Integer getValue() {
            return this._value;
        }

        public int getCount() {
            return this._count;
        }

        @Override
        public int compareTo(Accumulator accumulator) {
            int n = this._count - accumulator._count;
            if (n != 0) {
                return n;
            }
            return this._value - accumulator._value;
        }
    }
}

