/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class FromSubquery
extends FromTable {
    ResultSetNode subquery;
    private OrderByList orderByList;
    private ValueNode offset;
    private ValueNode fetchFirst;
    private boolean hasJDBClimitClause;
    private SchemaDescriptor origCompilationSchema = null;

    FromSubquery(ResultSetNode subquery, OrderByList orderByList, ValueNode offset, ValueNode fetchFirst, boolean hasJDBClimitClause, String correlationName, ResultColumnList derivedRCL, Properties tableProperties, ContextManager cm) {
        super(correlationName, tableProperties, cm);
        this.subquery = subquery;
        this.orderByList = orderByList;
        this.offset = offset;
        this.fetchFirst = fetchFirst;
        this.hasJDBClimitClause = hasJDBClimitClause;
        this.setResultColumns(derivedRCL);
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.subquery != null) {
            this.printLabel(depth, "subquery: ");
            this.subquery.treePrint(depth + 1);
        }
        if (this.orderByList != null) {
            this.printLabel(depth, "orderByList: ");
            this.orderByList.treePrint(depth + 1);
        }
        if (this.offset != null) {
            this.printLabel(depth, "offset: ");
            this.offset.treePrint(depth + 1);
        }
        if (this.fetchFirst != null) {
            this.printLabel(depth, "fetchFirst: ");
            this.fetchFirst.treePrint(depth + 1);
        }
    }

    ResultSetNode getSubquery() {
        return this.subquery;
    }

    @Override
    FromTable getFromTableByName(String name, String schemaName, boolean exactMatch) throws StandardException {
        if (schemaName != null && this.origTableName != null && !schemaName.equals(this.origTableName.schemaName)) {
            return null;
        }
        if (this.getExposedName().equals(name)) {
            return this;
        }
        return null;
    }

    @Override
    ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromListParam) throws StandardException {
        if (this.tableNumber == -1) {
            this.tableNumber = this.getCompilerContext().getNextTableNumber();
        }
        this.subquery = this.subquery.bindNonVTITables(dataDictionary, fromListParam);
        return this;
    }

    @Override
    ResultSetNode bindVTITables(FromList fromListParam) throws StandardException {
        this.subquery = this.subquery.bindVTITables(fromListParam);
        return this;
    }

    @Override
    void rejectParameters() throws StandardException {
        this.subquery.rejectParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void bindExpressions(FromList fromListParam) throws StandardException {
        FromList emptyFromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
        ResultColumnList derivedRCL = this.getResultColumns();
        if (this.orderByList != null) {
            this.orderByList.pullUpOrderByColumns(this.subquery);
        }
        FromList nestedFromList = emptyFromList;
        CompilerContext compilerContext = this.getCompilerContext();
        if (this.origCompilationSchema != null) {
            compilerContext.pushCompilationSchema(this.origCompilationSchema);
        }
        CollectNodesVisitor<FromVTI> nestedVTIs = new CollectNodesVisitor<FromVTI>(FromVTI.class);
        this.subquery.accept(nestedVTIs);
        for (FromVTI ref : nestedVTIs.getList()) {
            ref.addOuterFromList(fromListParam);
        }
        try {
            this.subquery.bindExpressions(nestedFromList);
            this.subquery.bindResultColumns(nestedFromList);
        }
        finally {
            if (this.origCompilationSchema != null) {
                compilerContext.popCompilationSchema();
            }
        }
        if (this.orderByList != null) {
            this.orderByList.bindOrderByColumns(this.subquery);
        }
        FromSubquery.bindOffsetFetch(this.offset, this.fetchFirst);
        ResultColumnList subqueryRCL = this.subquery.getResultColumns();
        if (this.getResultColumns() != null && this.getResultColumns().getCountMismatchAllowed() && this.getResultColumns().size() < subqueryRCL.size()) {
            for (int index = subqueryRCL.size() - 1; index >= this.getResultColumns().size(); --index) {
                subqueryRCL.removeElementAt(index);
            }
        }
        ResultColumnList newRcl = subqueryRCL.copyListAndObjects();
        newRcl.genVirtualColumnNodes(this.subquery, this.subquery.getResultColumns());
        this.setResultColumns(newRcl);
        if (derivedRCL != null) {
            this.getResultColumns().propagateDCLInfo(derivedRCL, this.correlationName);
        }
    }

    @Override
    ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        ResultColumn resultColumn = null;
        String columnsTableName = columnReference.getTableName();
        if (columnReference.getGeneratedToReplaceAggregate()) {
            resultColumn = this.getResultColumns().getResultColumn(columnReference.getColumnName());
        } else if (columnsTableName == null || columnsTableName.equals(this.correlationName)) {
            resultColumn = this.getResultColumns().getAtMostOneResultColumn(columnReference, this.correlationName, false);
        }
        if (resultColumn != null) {
            columnReference.setTableNumber(this.tableNumber);
            columnReference.setColumnNumber(resultColumn.getColumnPosition());
        }
        return resultColumn;
    }

    @Override
    ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        this.subquery.pushQueryExpressionSuffix();
        if (this.orderByList != null) {
            if (this.orderByList.size() > 1) {
                this.orderByList.removeDupColumns();
            }
            this.subquery.pushOrderByList(this.orderByList);
            this.orderByList = null;
        }
        this.subquery.pushOffsetFetchFirst(this.offset, this.fetchFirst, this.hasJDBClimitClause);
        this.subquery = this.subquery.preprocess(numTables, gbl, fromList);
        if ((gbl == null || gbl.size() == 0) && this.tableProperties == null && this.subquery.flattenableInFromSubquery(fromList)) {
            this.setReferencedTableMap(this.subquery.getReferencedTableMap());
            return this;
        }
        return this.extractSubquery(numTables);
    }

    ResultSetNode extractSubquery(int numTables) throws StandardException {
        ProjectRestrictNode newPRN = new ProjectRestrictNode(this.subquery, this.getResultColumns(), null, null, null, null, this.tableProperties, this.getContextManager());
        JBitSet newJBS = new JBitSet(numTables);
        newJBS.set(this.tableNumber);
        newPRN.setReferencedTableMap(newJBS);
        ((FromTable)newPRN).setTableNumber(this.tableNumber);
        return newPRN;
    }

    @Override
    FromList flatten(ResultColumnList rcl, PredicateList outerPList, SubqueryList sql, GroupByList gbl, ValueNode havingClause) throws StandardException {
        FromList fromList = null;
        this.getResultColumns().setRedundant();
        this.subquery.getResultColumns().setRedundant();
        if (this.subquery instanceof SelectNode) {
            SelectNode selectNode = (SelectNode)this.subquery;
            fromList = selectNode.getFromList();
            if (selectNode.getWherePredicates().size() > 0) {
                outerPList.destructiveAppend(selectNode.getWherePredicates());
            }
            if (selectNode.getWhereSubquerys().size() > 0) {
                sql.destructiveAppend(selectNode.getWhereSubquerys());
            }
        } else if (!(this.subquery instanceof RowResultSetNode)) {
            SanityManager.THROWASSERT("subquery expected to be either a SelectNode or a RowResultSetNode, but is a " + this.subquery.getClass().getName());
        }
        rcl.remapColumnReferencesToExpressions();
        outerPList.remapColumnReferencesToExpressions();
        if (gbl != null) {
            gbl.remapColumnReferencesToExpressions();
        }
        if (havingClause != null) {
            havingClause.remapColumnReferencesToExpressions();
        }
        return fromList;
    }

    @Override
    String getExposedName() {
        return this.correlationName;
    }

    @Override
    ResultColumnList getAllResultColumns(TableName allTableName) throws StandardException {
        TableName toCompare = allTableName != null ? this.makeTableName(allTableName.getSchemaName(), this.correlationName) : this.makeTableName(null, this.correlationName);
        if (allTableName != null && !allTableName.equals(toCompare)) {
            return null;
        }
        TableName exposedName = this.makeTableName(null, this.correlationName);
        ResultColumnList rcList = new ResultColumnList(this.getContextManager());
        int rclSize = this.getResultColumns().visibleSize();
        for (int index = 0; index < rclSize; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.getResultColumns().elementAt(index);
            if (resultColumn.isGenerated()) continue;
            String columnName = resultColumn.getName();
            boolean isNameGenerated = resultColumn.isNameGenerated();
            TableName tableName = exposedName;
            ColumnReference valueNode = new ColumnReference(columnName, tableName, this.getContextManager());
            resultColumn = new ResultColumn(columnName, (ValueNode)valueNode, this.getContextManager());
            resultColumn.setNameGenerated(isNameGenerated);
            rcList.addResultColumn(resultColumn);
        }
        return rcList;
    }

    @Override
    boolean referencesTarget(String name, boolean baseTable) throws StandardException {
        return this.subquery.referencesTarget(name, baseTable);
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.subquery.referencesSessionSchema();
    }

    @Override
    void bindUntypedNullsToResultColumns(ResultColumnList bindingRCL) throws StandardException {
        this.subquery.bindUntypedNullsToResultColumns(bindingRCL);
    }

    @Override
    void decrementLevel(int decrement) {
        super.decrementLevel(decrement);
        this.subquery.decrementLevel(decrement);
    }

    void setOrigCompilationSchema(SchemaDescriptor sd) {
        this.origCompilationSchema = sd;
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        this.subquery.accept(v);
        if (this.orderByList != null) {
            this.orderByList.accept(v);
        }
        if (this.offset != null) {
            this.offset.accept(v);
        }
        if (this.fetchFirst != null) {
            this.fetchFirst.accept(v);
        }
    }
}

