/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.nstest.init;

import java.io.PrintWriter;
import java.net.InetAddress;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.system.nstest.NsTest;

public class NWServerThread
extends Thread {
    InetAddress inetaddr = null;
    String address = "localhost";
    int port = 1900;

    public NWServerThread(String address, int port) throws Exception {
        if (address != null && !address.equals("")) {
            this.address = address;
        }
        if (port > 0) {
            this.port = port;
        }
        try {
            this.inetaddr = InetAddress.getByName(address);
        }
        catch (Exception e) {
            NsTest.logger.println("Invalid host address passed, cannot start server");
            if (NsTest.justCountErrors()) {
                NsTest.printException(NWServerThread.class.getName(), e);
            } else {
                e.printStackTrace(NsTest.logger);
            }
            throw e;
        }
    }

    @Override
    public void run() {
        try {
            NetworkServerControl nsw = new NetworkServerControl(this.inetaddr, this.port);
            nsw.start(new PrintWriter(NsTest.logger));
            NsTest.logger.println("===> Derby Network Server on " + this.address + ":" + this.port + " <===");
        }
        catch (Exception e) {
            if (NsTest.justCountErrors()) {
                NsTest.printException(NWServerThread.class.getName(), e);
            }
            e.printStackTrace(NsTest.logger);
        }
    }
}

