/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;

public class StatementPlanCacheTest
extends BaseJDBCTestCase {
    private static int CACHE_SIZE;
    private int statmentCacheSize = CACHE_SIZE;
    private PreparedStatement cacheInPlanPS_ID;
    private PreparedStatement cacheInPlanPS_TEXT;

    public StatementPlanCacheTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("StatementPlanCacheTest");
        CACHE_SIZE = 100;
        suite.addTest(StatementPlanCacheTest.baseSuite("default"));
        suite.addTest(StatementPlanCacheTest.suiteWithSizeSet(5));
        suite.addTest(StatementPlanCacheTest.suiteWithSizeSet(140));
        suite.addTest(DatabasePropertyTestSetup.singleProperty((Test)new StatementPlanCacheTest("noCachingTest"), "derby.language.statementCacheSize", "0", true));
        return new CleanDatabaseTestSetup((Test)suite);
    }

    private static Test suiteWithSizeSet(int cacheSize) {
        CACHE_SIZE = cacheSize;
        String cs = Integer.toString(cacheSize);
        return DatabasePropertyTestSetup.singleProperty(StatementPlanCacheTest.baseSuite(cs), "derby.language.statementCacheSize", cs, true);
    }

    private static Test baseSuite(String name) {
        BaseTestSuite suite = new BaseTestSuite("StatementPlanCacheTest:derby.language.statementCacheSize=" + name);
        suite.addTestSuite(StatementPlanCacheTest.class);
        return suite;
    }

    protected void setUp() throws SQLException {
        this.cacheInPlanPS_ID = this.prepareStatement("SELECT COUNT(ID) FROM SYSCS_DIAG.STATEMENT_CACHE WHERE ID = ?");
        this.cacheInPlanPS_TEXT = this.prepareStatement("SELECT COUNT(ID) FROM SYSCS_DIAG.STATEMENT_CACHE WHERE SCHEMANAME = ? AND SQL_TEXT = ?");
        this.emptyStatementCache();
    }

    @Override
    protected void tearDown() throws Exception {
        this.cacheInPlanPS_ID.close();
        this.cacheInPlanPS_ID = null;
        this.cacheInPlanPS_TEXT.close();
        this.cacheInPlanPS_TEXT = null;
        super.tearDown();
    }

    public void noCachingTest() throws SQLException {
        String schema = this.getTestConfiguration().getUserName();
        String sql = "VALUES 1";
        Statement s = this.createStatement();
        s.executeQuery(sql).close();
        s.close();
        StatementPlanCacheTest.assertFalse((String)sql, (boolean)this.isPlanInCache(schema, sql));
        this.prepareStatement(sql).close();
        StatementPlanCacheTest.assertFalse((String)sql, (boolean)this.isPlanInCache(schema, sql));
        sql = "CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(0)";
        this.prepareCall(sql).close();
        StatementPlanCacheTest.assertFalse((String)sql, (boolean)this.isPlanInCache(schema, sql));
    }

    public void testAcrossStatementObjects() throws SQLException {
        String schema = this.getTestConfiguration().getUserName();
        String sql = "CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(0)";
        sql = "CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(0)";
        Statement s = this.createStatement();
        s.execute(sql);
        s.close();
        StatementPlanCacheTest.assertTrue((String)sql, (boolean)this.isPlanInCache(schema, sql));
        PreparedStatement ps = this.prepareStatement(sql);
        StatementPlanCacheTest.assertTrue((String)sql, (boolean)this.isPlanInCache(ps));
        CallableStatement cs = this.prepareCall(sql);
        StatementPlanCacheTest.assertTrue((String)sql, (boolean)this.isPlanInCache(cs));
        StatementPlanCacheTest.assertEquals((String)ps.toString(), (String)cs.toString());
        ps.close();
        cs.close();
    }

    public void testCompileFailuresNotInCache() throws SQLException {
        String schema = this.getTestConfiguration().getUserName();
        String sql = "TO BE OR NOT TO BE";
        this.assertCompileError("42X01", sql);
        StatementPlanCacheTest.assertFalse((String)sql, (boolean)this.isPlanInCache(schema, sql));
        sql = "CREATE PROCEDURE BAD_PROC() EXTERNAL NAME 'lll' LANGUAGE JAVA";
        this.assertCompileError("42X01", sql);
        StatementPlanCacheTest.assertFalse((String)sql, (boolean)this.isPlanInCache(schema, sql));
        sql = "SELECT * FROM NO_SUCH_TABLE_EXISTS";
        this.assertCompileError("42X05", sql);
        StatementPlanCacheTest.assertFalse((String)sql, (boolean)this.isPlanInCache(schema, sql));
    }

    public void testPreparedStatementPlanCaching() throws SQLException {
        this.checkPreparedPlanInCache(this.statmentCacheSize, "VALUES &");
    }

    public void testCallableStatementPlanCaching() throws SQLException {
        this.checkPreparedPlanInCache(this.statmentCacheSize, "CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(&)");
    }

    private void checkPreparedPlanInCache(int number, String sqlBase) throws SQLException {
        PreparedStatement ps;
        int i;
        boolean isCall = sqlBase.startsWith("CALL ");
        String[] sql = new String[number];
        String[] firstCompileID = new String[sql.length];
        for (i = 0; i < firstCompileID.length; ++i) {
            sql[i] = StatementPlanCacheTest.getSQL(sqlBase, i);
            ps = isCall ? this.prepareCall(sql[i]) : this.prepareStatement(sql[i]);
            StatementPlanCacheTest.assertTrue((String)sql[i], (boolean)this.isPlanInCache(ps));
            firstCompileID[i] = ps.toString();
            ps.close();
        }
        for (i = 0; i < firstCompileID.length; ++i) {
            ps = isCall ? this.prepareCall(sql[i]) : this.prepareStatement(sql[i]);
            PreparedStatement ps2 = isCall ? this.prepareCall(sql[i]) : this.prepareStatement(sql[i]);
            StatementPlanCacheTest.assertTrue((String)sql[i], (boolean)this.isPlanInCache(ps));
            StatementPlanCacheTest.assertEquals((String)sql[i], (String)firstCompileID[i], (String)ps.toString());
            StatementPlanCacheTest.assertEquals((String)sql[i], (String)ps.toString(), (String)ps2.toString());
            ps.close();
            ps2.close();
            Connection c2 = this.openDefaultConnection();
            PreparedStatement psD = isCall ? c2.prepareCall(sql[i]) : c2.prepareStatement(sql[i]);
            StatementPlanCacheTest.assertEquals((String)sql[i], (String)firstCompileID[i], (String)psD.toString());
            psD.close();
            c2.close();
        }
        String schema = this.getTestConfiguration().getUserName();
        for (int n = firstCompileID.length; n < firstCompileID.length * 2; ++n) {
            String sqlN = StatementPlanCacheTest.getSQL(sqlBase, n);
            PreparedStatement ps2 = isCall ? this.prepareCall(sqlN) : this.prepareStatement(sqlN);
            StatementPlanCacheTest.assertTrue((String)sqlN, (boolean)this.isPlanInCache(ps2));
            ps2.close();
        }
        boolean thrownOut = false;
        for (int i2 = 0; i2 < sql.length; ++i2) {
            if (this.isPlanInCache(schema, sql[i2])) continue;
            thrownOut = true;
            break;
        }
        StatementPlanCacheTest.assertTrue((String)"Expect a plan to thrown out", (boolean)thrownOut);
    }

    private static String getSQL(String sqlBase, int i) {
        StringBuffer sb = new StringBuffer();
        int rp = sqlBase.indexOf(38);
        sb.append(sqlBase.substring(0, rp));
        sb.append(i);
        if (rp + 1 < sqlBase.length()) {
            sb.append(sqlBase.substring(rp + 1));
        }
        return sb.toString();
    }

    private boolean isPlanInCache(PreparedStatement ps) throws SQLException {
        this.cacheInPlanPS_ID.setString(1, ps.toString());
        ResultSet rs = this.cacheInPlanPS_ID.executeQuery();
        rs.next();
        int count = rs.getInt(1);
        rs.close();
        StatementPlanCacheTest.assertTrue((String)"Statement in cache multiple times ", (count <= 1 ? 1 : 0) != 0);
        return count == 1;
    }

    private boolean isPlanInCache(String schema, String sql) throws SQLException {
        this.cacheInPlanPS_TEXT.setString(1, schema);
        this.cacheInPlanPS_TEXT.setString(2, sql);
        ResultSet rs = this.cacheInPlanPS_TEXT.executeQuery();
        rs.next();
        int count = rs.getInt(1);
        rs.close();
        StatementPlanCacheTest.assertTrue((String)"Statement in cache multiple times ", (count <= 1 ? 1 : 0) != 0);
        this.cacheInPlanPS_TEXT.clearParameters();
        return count == 1;
    }
}

