/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class InPredicateTest
extends BaseJDBCTestCase {
    public InPredicateTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(InPredicateTest.class));
    }

    public void testDuplicateConstantsMixedTypes() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.executeUpdate("create table t1(b bigint)");
        String[][] allRows = new String[][]{{Long.toString(0x7FFFFFFFFFFFFFFDL)}, {Long.toString(0x7FFFFFFFFFFFFFFEL)}, {Long.toString(Long.MAX_VALUE)}};
        PreparedStatement insert = this.prepareStatement("insert into t1 values ?");
        for (int i = 0; i < allRows.length; ++i) {
            insert.setString(1, allRows[i][0]);
            insert.executeUpdate();
        }
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 where b in (9223372036854775805, 9223372036854775806, 9223372036854775807, 9.223372036854776E18)"), allRows);
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 where b in (values 9223372036854775805, 9223372036854775806, 9223372036854775807, 9.223372036854776E18)"), allRows);
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 where b = any (values 9223372036854775805, 9223372036854775806, 9223372036854775807, 9.223372036854776E18)"), allRows);
    }

    public void testMixedTypes() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.executeUpdate("create table t2(b1 bigint, b2 bigint, d double)");
        s.executeUpdate("insert into t2 values (9223372036854775805, 9223372036854775806, 1)");
        JDBC.assertSingleValueResultSet(s.executeQuery("select true from t2 where b1 in (b2, d)"), "true");
        JDBC.assertSingleValueResultSet(s.executeQuery("select true from t2 where b1 in (values b2, d)"), "true");
        JDBC.assertSingleValueResultSet(s.executeQuery("select true from t2 where b1 = any (values b2, d)"), "true");
        s.executeUpdate("create table t3 (i1 int, r1 real, r2 real)");
        s.executeUpdate("insert into t3 values (2147483645, 2147483645, 2147483645), (2147483645, 2147483645, 0)");
        Object[][] expectedRows = new Object[][]{{0x7FFFFFFD, Float.valueOf(2.1474836E9f), Float.valueOf(2.1474836E9f)}};
        JDBC.assertFullResultSet(s.executeQuery("select * from t3 where r1 in (i1, r2)"), expectedRows, false);
        JDBC.assertFullResultSet(s.executeQuery("select * from t3 where r1 in (values i1, r2)"), expectedRows, false);
        JDBC.assertFullResultSet(s.executeQuery("select * from t3 where r1 = any (values i1, r2)"), expectedRows, false);
    }
}

