/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.oe.run;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBCPerfTestCase;
import org.apache.derbyTesting.system.oe.util.HandleCheckError;
import org.apache.derbyTesting.system.oe.util.OEChecks;

public class Checks
extends JDBCPerfTestCase {
    private short scale = 1;
    private OEChecks check = null;

    public Checks(String string) {
        super(string);
    }

    public Checks(String string, short s) {
        super(string);
        this.scale = s;
    }

    public void setUp() throws Exception {
        this.check = new OEChecks();
        this.check.initialize(new HandleCheckError(this){

            @Override
            public void handleCheckError(String string) {
                Assert.fail((String)string);
            }
        }, this.getConnection(), this.scale);
    }

    public static Test checkAllRowCounts(short s) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Order Entry -Check Row Counts");
        baseTestSuite.addTest((Test)new Checks("testWarehouseRows", s));
        baseTestSuite.addTest((Test)new Checks("testStockRows", s));
        baseTestSuite.addTest((Test)new Checks("testItemRows", s));
        baseTestSuite.addTest((Test)new Checks("testCustomerRows", s));
        baseTestSuite.addTest((Test)new Checks("testDistrictRows", s));
        baseTestSuite.addTest((Test)new Checks("testOrdersRows", s));
        baseTestSuite.addTest((Test)new Checks("testNewOrdersRows", s));
        baseTestSuite.addTest((Test)new Checks("testOrderLineRows", s));
        baseTestSuite.addTest((Test)new Checks("testHistoryRows", s));
        return baseTestSuite;
    }

    public static Test consistencyChecks() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Order Entry -Consistency checks");
        baseTestSuite.addTest((Test)new Checks("testCondition1"));
        baseTestSuite.addTest((Test)new Checks("testCondition2"));
        baseTestSuite.addTest((Test)new Checks("testCondition3"));
        baseTestSuite.addTest((Test)new Checks("testCondition4"));
        return baseTestSuite;
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("OrderEntry - checks");
        baseTestSuite.addTest(Checks.checkAllRowCounts((short)1));
        baseTestSuite.addTest(Checks.consistencyChecks());
        return baseTestSuite;
    }

    public void testCondition1() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT W.W_ID,W.W_YTD, SUM(D.D_YTD) from WAREHOUSE W , DISTRICT D where W.W_ID=D.D_W_ID GROUP BY W.W_ID,W.W_YTD");
        while (resultSet.next()) {
            Checks.println("W_ID" + resultSet.getShort(1) + "W_YTD)=" + resultSet.getString(2) + "SUM(D_YTD)=" + resultSet.getString(3));
            Assert.assertEquals((String)("Condition#1: W_YTD = sum(D_YTD) not satisfied for W_ID=" + resultSet.getShort(1)), (String)resultSet.getString(2), (String)resultSet.getString(3));
        }
        this.commit();
        resultSet.close();
        statement.close();
    }

    public void testCondition2() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT D.D_ID, D.D_W_ID,D.D_NEXT_O_ID, MAX(O.O_ID),MAX(N.NO_O_ID) FROM NEWORDERS N, DISTRICT D, ORDERS O WHERE D.D_W_ID=O.O_W_ID AND D.D_W_ID = N.NO_W_ID AND D.D_ID = O.O_D_ID AND D.D_ID = N.NO_D_ID GROUP BY D.D_ID,D.D_W_ID,D.D_NEXT_O_ID");
        while (resultSet.next()) {
            Checks.println("D_ID=" + resultSet.getShort(1) + "D_W_ID=" + resultSet.getShort(2) + "D_NEXT_O_ID=" + resultSet.getInt(3) + "MAX(O.O_ID)=" + resultSet.getInt(4) + "MAX(N.NO_O_ID)=" + resultSet.getInt(5));
            Assert.assertEquals((String)("Condition#2 (a), (D_NEXT_O_ID -1) = MAX(O_ID) not satisfied for D_ID=" + resultSet.getShort(1) + "D_W_ID=" + resultSet.getShort(2)), (int)(resultSet.getInt(3) - 1), (int)resultSet.getInt(4));
            Assert.assertEquals((String)("Condition#2 (b), (D_NEXT_O_ID -1 = MAX(NO_O_ID) not satisfied for D_ID=" + resultSet.getShort(1) + " D_W_ID=" + resultSet.getShort(2)), (int)(resultSet.getInt(3) - 1), (int)resultSet.getInt(5));
            Assert.assertEquals((String)("Condition#2 (c), MAX(O_ID) = MAX(NO_O_ID)  not satisfied for D_ID=" + resultSet.getShort(1) + " D_W_ID=" + resultSet.getShort(2)), (int)resultSet.getInt(4), (int)resultSet.getInt(5));
        }
        this.commit();
        resultSet.close();
        statement.close();
    }

    public void testCondition3() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT NO_W_ID,NO_D_ID,MAX(NO_O_ID) - MIN(NO_O_ID) +1, COUNT(*) FROM NEWORDERS GROUP BY NO_W_ID,NO_D_ID");
        while (resultSet.next()) {
            Checks.println("NO_W_ID=" + resultSet.getShort(1) + ",NO_D_ID=" + resultSet.getShort(2) + "Max(NO_O_ID)-MIN(NO_O_ID)+1 =" + resultSet.getInt(3) + " Num_rows_NO for this district=" + resultSet.getInt(4));
            Assert.assertEquals((String)("Condition#3 (max(NO_O_ID) - min(NO_O_ID) + 1) = [number of rows in the NEW-ORDER table for district] not satisfied for NO_W_ID=" + resultSet.getShort(1) + " NO_D_ID=" + resultSet.getShort(2)), (int)resultSet.getInt(3), (int)resultSet.getInt(4));
        }
        this.commit();
        resultSet.close();
        statement.close();
    }

    public void testCondition4() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT T1.SUM_OL_CNT,T2.NUM_OL_ROWS, T1.O_W_ID,T1.O_D_ID FROM (SELECT O.O_W_ID, O.O_D_ID, SUM(CAST(O.O_OL_CNT AS BIGINT)) AS SUM_OL_CNT FROM ORDERS O GROUP BY O.O_W_ID,O.O_D_ID) T1 ,(SELECT OL_W_ID,OL_D_ID,COUNT(*) AS NUM_OL_ROWS FROM ORDERLINE OL GROUP BY OL.OL_W_ID,OL.OL_D_ID) T2 WHERE (T1.O_W_ID = T2.OL_W_ID) AND (T1.O_D_ID = T2.OL_D_ID)");
        while (resultSet.next()) {
            Checks.println("Sum of ol_cnt" + resultSet.getLong(1) + " Num_rows_OL=" + resultSet.getInt(1));
            Assert.assertEquals((String)("Condition#4 sum(O_OL_CNT) = [number of rows in the ORDER-LINE table for this district]not satisfiedfor O_W_ID=" + resultSet.getShort(3) + ",O_D_ID=" + resultSet.getShort(4)), (long)resultSet.getLong(1), (long)resultSet.getLong(2));
        }
        this.commit();
        resultSet.close();
        statement.close();
    }

    public void testWarehouseRows() throws Exception {
        this.check.testWarehouseRows();
    }

    public void testStockRows() throws Exception {
        this.check.testStockRows();
    }

    public void testOrdersRows() throws Exception {
        this.check.testOrdersRows();
    }

    public void testDistrictRows() throws Exception {
        this.check.testDistrictRows();
    }

    public void testCustomerRows() throws Exception {
        this.check.testCustomerRows();
    }

    public void testItemRows() throws Exception {
        this.check.testItemRows();
    }

    public void testNewOrdersRows() throws Exception {
        this.check.testNewOrdersRows();
    }

    public void testHistoryRows() throws Exception {
        this.check.testHistoryRows();
    }

    public void testOrderLineRows() throws Exception {
        this.check.testOrderLineRows();
    }
}

