/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class Triggers {
    private static final String RESULT_SET_NOT_OPEN = "XCL16";

    private Triggers() {
    }

    public static int doNothingInt() throws Throwable {
        return 1;
    }

    public static void doNothing() throws Throwable {
    }

    public static int doConnCommitInt() throws Throwable {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        connection.commit();
        return 1;
    }

    public static void doConnCommit() throws Throwable {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        connection.commit();
    }

    public static void doConnRollback() throws Throwable {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        connection.rollback();
    }

    public static void doConnectionSetIsolation() throws Throwable {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        connection.setTransactionIsolation(8);
    }

    public static int doConnStmtIntNoRS(String string) throws Throwable {
        Triggers.doConnStmtNoRS(string);
        return 1;
    }

    public static void doConnStmtNoRS(String string) throws Throwable {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        statement.execute(string);
    }

    public static int doConnStmtInt(String string) throws Throwable {
        Triggers.doConnStmt(string);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doConnStmt(String string) throws Throwable {
        Statement statement;
        Connection connection;
        block8: {
            connection = DriverManager.getConnection("jdbc:default:connection");
            statement = connection.createStatement();
            if (statement.execute(string)) {
                try (ResultSet resultSet = statement.getResultSet();){
                    while (resultSet.next()) {
                    }
                }
            }
        }
        statement.close();
        connection.close();
    }

    public static void getConnection() throws Throwable {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        connection.close();
        System.out.println("getConnection() called");
    }

    static void zipThroughRs(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            return;
        }
        while (resultSet.next()) {
        }
    }

    public static long returnPrimLong(long l) {
        return l;
    }

    public static Long returnLong(Long l) {
        return l;
    }
}

