/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Random;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;

public class LobSortTest
extends BaseJDBCTestCase {
    private static final long SEED = System.currentTimeMillis();

    public LobSortTest(String string) {
        super(string);
    }

    public String getName() {
        return super.getName() + "-" + SEED;
    }

    public void testBlobMixed() throws SQLException {
        this.fetchIterateGetLengthBlob("select blen, b from MIXED_LOBS order by length(b)");
    }

    public void testBlobSmall() throws SQLException {
        this.fetchIterateGetLengthBlob("select blen, b from MIXED_LOBS where blen < 2000 order by length(b)");
    }

    public void testBlobLarge() throws SQLException {
        this.fetchIterateGetLengthBlob("select blen, b from MIXED_LOBS where blen > 34000 order by length(b)");
    }

    public void testBlobClob() throws SQLException {
        this.fetchIterateGetLengthBlob("select blen, b from MIXED_LOBS order by length(c), length(b)");
    }

    public void testBlobRandom() throws SQLException {
        this.fetchIterateGetLengthBlob("select blen, b from MIXED_LOBS order by rnd");
    }

    public void testClobMixed() throws SQLException {
        this.fetchIterateGetLengthClob("select clen, c from MIXED_LOBS order by length(c)");
    }

    public void testClobSmall() throws SQLException {
        this.fetchIterateGetLengthClob("select clen, c from MIXED_LOBS where clen < 2000 order by length(c)");
    }

    public void testClobLarge() throws SQLException {
        this.fetchIterateGetLengthClob("select clen, c from MIXED_LOBS where clen > 34000 order by length(c)");
    }

    public void testClobBlob() throws SQLException {
        this.fetchIterateGetLengthClob("select clen, c from MIXED_LOBS order by length(b), length(c)");
    }

    public void testClobRandom() throws SQLException {
        this.fetchIterateGetLengthClob("select clen, c from MIXED_LOBS order by rnd");
    }

    private void fetchIterateGetLengthBlob(String string) throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            LobSortTest.assertEquals((int)resultSet.getInt(1), (int)resultSet.getBytes(2).length);
        }
        resultSet.close();
        resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            LobSortTest.assertEquals((int)resultSet.getInt(1), (int)((int)resultSet.getBlob(2).length()));
        }
        resultSet.close();
        statement.close();
    }

    private void fetchIterateGetLengthClob(String string) throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            LobSortTest.assertEquals((int)resultSet.getInt(1), (int)resultSet.getString(2).length());
        }
        resultSet.close();
        resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            LobSortTest.assertEquals((int)resultSet.getInt(1), (int)((int)resultSet.getClob(2).length()));
        }
        resultSet.close();
        statement.close();
    }

    public static Test suite() {
        Properties properties = new Properties();
        properties.setProperty("derby.storage.sortBufferMax", "4");
        BaseTestSuite baseTestSuite = new BaseTestSuite(LobSortTest.class, "LobSortTestEmbedded");
        return new CleanDatabaseTestSetup((Test)new SystemPropertyTestSetup((Test)baseTestSuite, properties, true)){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                Random random = new Random(SEED);
                Connection connection = statement.getConnection();
                connection.setAutoCommit(false);
                statement.executeUpdate("create table MIXED_LOBS (c clob, clen int, b blob, blen int, rnd int)");
                PreparedStatement preparedStatement = connection.prepareStatement("insert into MIXED_LOBS values (?,?,?,?,?)");
                preparedStatement.setString(1, "");
                preparedStatement.setInt(2, 0);
                preparedStatement.setBytes(3, new byte[0]);
                preparedStatement.setInt(4, 0);
                preparedStatement.setInt(5, random.nextInt());
                preparedStatement.executeUpdate();
                for (int i = 0; i < 100; ++i) {
                    CharAlphabet charAlphabet = this.getCharAlphabet(1 + random.nextInt(3));
                    int n = (int)(random.nextDouble() * 64.0 * 1024.0);
                    if (random.nextInt(1000) < 500) {
                        preparedStatement.setCharacterStream(1, (Reader)new LoopingAlphabetReader((long)n, charAlphabet), n);
                    } else {
                        preparedStatement.setCharacterStream(1, new LoopingAlphabetReader((long)n, charAlphabet));
                    }
                    preparedStatement.setInt(2, n);
                    n = (int)(random.nextDouble() * 64.0 * 1024.0);
                    if (random.nextInt(1000) < 500) {
                        preparedStatement.setBinaryStream(3, (InputStream)new LoopingAlphabetStream(n), n);
                    } else {
                        preparedStatement.setBinaryStream(3, new LoopingAlphabetStream(n));
                    }
                    preparedStatement.setInt(4, n);
                    preparedStatement.setInt(5, random.nextInt());
                    preparedStatement.executeUpdate();
                }
                connection.commit();
                preparedStatement.close();
            }

            private CharAlphabet getCharAlphabet(int n) {
                switch (n) {
                    case 1: {
                        return CharAlphabet.modernLatinLowercase();
                    }
                    case 2: {
                        return CharAlphabet.tamil();
                    }
                    case 3: {
                        return CharAlphabet.cjkSubset();
                    }
                }
                1.fail((String)("Unknown alphabet identifier: " + n));
                return null;
            }
        };
    }
}

