/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.sttest;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Random;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.system.sttest.tools.MemCheck;
import org.apache.derbyTesting.system.sttest.utils.Datatypes;
import org.apache.derbyTesting.system.sttest.utils.Setup;
import org.apache.derbyTesting.system.sttest.utils.StStatus;

public class Sttest
extends Thread {
    static int loops = 200;
    static int rowcount = 0;
    static int testcount = 0;
    static int connections_to_make = 250;
    static Random rand;
    static boolean increase;
    static boolean not_finished;
    static int targetmax;
    static int targetmin;
    static int insertsize;
    static int updatesize;
    static int deletesize;
    static boolean fatal;
    static int rows;
    static boolean countlock;
    static int delete_freq;
    static int locker_id;
    static final int INIT = 0;
    static final int GROW = 1;
    static final int SHRINK = 2;
    static int mode;
    static int count_timer;
    static int inserts_to_try;
    static final int INITIAL_CONNECTIONS = 2;
    static boolean startByIJ;
    static String dbURL;
    static String driver;
    static StStatus status;
    int thread_id;
    int ind = 0;

    public static void main(String[] stringArray) throws SQLException, IOException, InterruptedException, Exception, Throwable {
        System.getProperties().put("derby.locks.deadlockTimeout", "60");
        System.getProperties().put("derby.locks.waitTimeout", "200");
        System.out.println("Test Sttest starting");
        System.getProperties().put("derby.infolog.append", "true");
        System.getProperties().put("derby.stream.error.logSeverityLevel", "0");
        Sttest.userProperties();
        Class<?> clazz = Class.forName(driver);
        clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        if (!Setup.doit(dbURL)) {
            System.exit(1);
        }
        status = new StStatus();
        Sttest.sttTop();
    }

    static void userProperties() throws Throwable {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream("Sttest.properties");
        }
        catch (Exception exception) {
            System.out.println("user control file 'Sttest.properties' not found; using defaults");
        }
        if (fileInputStream != null) {
            Properties properties = new Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
            String string = null;
            string = properties.getProperty("connections");
            if (string != null) {
                connections_to_make = Integer.parseInt(string);
            }
            if ((string = properties.getProperty("dbURL")) != null) {
                dbURL = string;
            }
            if ((string = properties.getProperty("driver")) != null) {
                driver = string;
            }
            Properties properties2 = System.getProperties();
            Enumeration<?> enumeration = properties.propertyNames();
            String string2 = null;
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                properties2.put(string2, properties.getProperty(string2));
            }
        }
        System.out.println("driver = " + driver);
        System.out.println("dbURL = " + dbURL);
        System.out.println("connections = " + connections_to_make);
    }

    public static void sttTop() throws SQLException, IOException, InterruptedException, Exception, Throwable {
        int n;
        Datatypes.Rn = rand = new Random();
        delete_freq = 1 + connections_to_make % 5;
        Sttest.initial_data();
        Date date = new Date();
        status.firstMessage(connections_to_make, date);
        MemCheck memCheck = new MemCheck(200000);
        memCheck.start();
        Sttest[] sttestArray = new Sttest[connections_to_make];
        for (n = 0; n < connections_to_make; ++n) {
            sttestArray[n] = new Sttest(n);
            sttestArray[n].start();
            Sttest.sleep(3000L);
        }
        for (n = 0; n < connections_to_make; ++n) {
            sttestArray[n].join();
        }
        memCheck.stopNow = true;
        memCheck.join();
    }

    Sttest(int n) throws SQLException {
        this.thread_id = n;
    }

    static synchronized void reset_loops(int n) {
        if (n == loops) {
            --loops;
        }
    }

    static synchronized void locksync() {
    }

    static synchronized boolean get_countlock() {
        Sttest.locksync();
        return countlock;
    }

    static synchronized boolean set_countlock(boolean bl) {
        Sttest.locksync();
        if (bl && countlock) {
            return false;
        }
        countlock = bl;
        return true;
    }

    static synchronized void changerowcount(int n) {
        rowcount += n;
    }

    static synchronized void changerowcount2zero() {
        rowcount = 0;
    }

    static void initial_data() throws Exception, Throwable {
        int n;
        Connection connection = null;
        int n2 = 0;
        connection = Sttest.mystartJBMS();
        int n3 = Datatypes.get_table_count(connection);
        if (n3 != -1) {
            n2 = n3;
        }
        if (connection != null) {
            connection.commit();
            connection.close();
        }
        rowcount = n2;
        if (n2 >= targetmin) {
            mode = 1;
            System.out.println("initial data not needed");
            return;
        }
        inserts_to_try = targetmin - n2;
        Sttest[] sttestArray = new Sttest[2];
        for (n = 0; n < 2; ++n) {
            sttestArray[n] = new Sttest(n);
            sttestArray[n].start();
        }
        for (n = 0; n < 2; ++n) {
            sttestArray[n].join();
        }
        mode = 1;
        System.out.println("complete initial data");
    }

    @Override
    public void run() {
        Connection connection = null;
        Date date = null;
        try {
            connection = Sttest.mystartJBMS();
        }
        catch (Throwable throwable) {
            return;
        }
        int n = 0;
        int n2 = loops;
        while (not_finished && loops > 0) {
            n2 = loops;
            if (fatal || mode == 0 && inserts_to_try <= 0) break;
            if (mode == 1 && rowcount > targetmax) {
                System.out.println("hit targetmax with " + rowcount + " " + date);
                date = new Date();
                mode = 2;
                Sttest.reset_loops(n2);
                insertsize = 1;
                deletesize = 12;
                if (Sttest.set_countlock(true)) {
                    try {
                        Sttest.checkrowcount(connection);
                        MemCheck.showmem();
                        status.updateStatus();
                    }
                    catch (Exception exception) {
                        System.out.println("unexpected exception in rowcount");
                        Sttest.set_countlock(false);
                        System.exit(1);
                    }
                    MemCheck.showmem();
                }
                Sttest.set_countlock(false);
                Thread.yield();
            } else if (mode == 1 && rowcount >= targetmax) {
                date = new Date();
                System.out.println("hit targetmax with " + rowcount + " " + date);
                mode = 2;
                insertsize = 1;
                deletesize = 12;
            } else if (mode == 2 && rowcount <= targetmin) {
                date = new Date();
                System.out.println("hit targetmin with " + rowcount + " " + date);
                mode = 1;
                Sttest.reset_loops(n2);
                insertsize = 8;
                deletesize = 1;
                if (Sttest.set_countlock(true)) {
                    try {
                        Sttest.checkrowcount(connection);
                        MemCheck.showmem();
                        status.updateStatus();
                    }
                    catch (Exception exception) {
                        System.out.println("unexpected exception in rowcount");
                        Sttest.set_countlock(false);
                        System.exit(1);
                    }
                    MemCheck.showmem();
                    try {
                        Sttest.compress(connection);
                    }
                    catch (Exception exception) {
                        System.out.println("unexpected exception during compress");
                    }
                }
                Sttest.set_countlock(false);
                Thread.yield();
            }
            while (Sttest.get_countlock()) {
                try {
                    Sttest.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("unexpected sleep interruption");
                    break;
                }
            }
            try {
                this.ind = mode == 0 ? 0 : Math.abs(rand.nextInt() % 3);
                switch (this.ind) {
                    case 0: {
                        int n3;
                        n = Math.abs(rand.nextInt() % insertsize);
                        int n4 = 0;
                        for (n3 = 0; n3 <= n; ++n3) {
                            Datatypes.add_one_row(connection, this.thread_id);
                            ++n4;
                            connection.commit();
                            if (mode == 0) {
                                --inserts_to_try;
                            }
                            Thread.yield();
                            Sttest.changerowcount(1);
                        }
                        System.out.println(n4 + "  Rows inserted");
                        break;
                    }
                    case 1: {
                        int n5;
                        n = Math.abs(rand.nextInt() % updatesize);
                        int n3 = 0;
                        for (n5 = 0; n5 <= n; ++n5) {
                            Datatypes.update_one_row(connection, this.thread_id);
                            ++n3;
                            connection.commit();
                            Thread.yield();
                        }
                        System.out.println(n3 + "  rows updated");
                        break;
                    }
                    case 2: {
                        n = Math.abs(rand.nextInt() % deletesize);
                        int n5 = 0;
                        n5 = Datatypes.delete_some(connection, this.thread_id, n + 1);
                        Thread.yield();
                        Sttest.changerowcount(-1 * n5);
                        System.out.println(n5 + " rows deleted");
                    }
                }
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState() == null) {
                    sQLException.printStackTrace();
                }
                if (sQLException.getSQLState().equals("40001")) {
                    System.out.println("t" + this.thread_id + " deadlock op = " + this.ind);
                    continue;
                }
                if (sQLException.getSQLState().equals("40XL1")) {
                    System.out.println("t" + this.thread_id + " timeout op = " + this.ind);
                    continue;
                }
                if (sQLException.getSQLState().equals("23500")) {
                    System.out.println("t" + this.thread_id + " duplicate key violation\n");
                    continue;
                }
                if (sQLException.getSQLState().equals("23505")) {
                    System.out.println("t" + this.thread_id + " duplicate key violation\n");
                    continue;
                }
                System.out.println("t" + this.thread_id + " FAIL -- unexpected exception:");
                JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)sQLException);
                fatal = true;
                break;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                if (throwable.getMessage().equals("java.lang.ThreadDeath")) {
                    System.out.println("caught threaddeath and continuing\n");
                    continue;
                }
                fatal = true;
                throwable.printStackTrace();
            }
        }
        try {
            connection.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        System.out.println("Thread finished: " + this.thread_id);
    }

    static synchronized void checkrowcount(Connection connection) throws Exception {
        int n = Datatypes.get_table_count(connection);
        if (n == -1) {
            System.out.println("table count timed out");
        } else {
            System.out.println("rowcount by select: " + n + " client rowcount = " + rowcount);
            Sttest.changerowcount(n - rowcount);
        }
        connection.commit();
    }

    public static Connection mystartJBMS() throws Throwable {
        Connection connection = null;
        if (startByIJ) {
            connection = ij.startJBMS();
        } else {
            try {
                connection = DriverManager.getConnection(dbURL + ";create=false");
                connection.setAutoCommit(false);
                connection.setHoldability(2);
            }
            catch (SQLException sQLException) {
                System.out.println("connect failed  for " + dbURL);
                JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)sQLException);
            }
        }
        return connection;
    }

    static synchronized void compress(Connection connection) throws Exception {
        System.out.println("compressing table");
        boolean bl = connection.getAutoCommit();
        try {
            connection.setAutoCommit(true);
            CallableStatement callableStatement = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?, ?, ?, ?, ?)");
            callableStatement.setString(1, "APP");
            callableStatement.setString(2, "DATATYPES");
            callableStatement.setShort(3, (short)1);
            callableStatement.setShort(4, (short)1);
            callableStatement.setShort(5, (short)1);
            callableStatement.execute();
            callableStatement.close();
        }
        catch (SQLException sQLException) {
            System.out.println("compress table: FAIL -- unexpected exception:");
            JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)sQLException);
            sQLException.printStackTrace();
        }
        connection.setAutoCommit(bl);
    }

    static {
        increase = true;
        not_finished = true;
        targetmax = 100000;
        targetmin = 90000;
        insertsize = 7;
        updatesize = 1;
        deletesize = 1;
        fatal = false;
        rows = 0;
        countlock = false;
        delete_freq = 1;
        locker_id = -1;
        mode = 0;
        count_timer = 0;
        inserts_to_try = 0;
        startByIJ = false;
        dbURL = "jdbc:derby:testDB";
        driver = "org.apache.derby.jdbc.EmbeddedDriver";
        status = null;
    }
}

