/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.clients;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.derbyTesting.perf.clients.BackToBackLoadGenerator;
import org.apache.derbyTesting.perf.clients.BankAccountFiller;
import org.apache.derbyTesting.perf.clients.BankTransactionClient;
import org.apache.derbyTesting.perf.clients.Client;
import org.apache.derbyTesting.perf.clients.DBFiller;
import org.apache.derbyTesting.perf.clients.GroupByClient;
import org.apache.derbyTesting.perf.clients.IndexJoinClient;
import org.apache.derbyTesting.perf.clients.LoadGenerator;
import org.apache.derbyTesting.perf.clients.PoissonLoadGenerator;
import org.apache.derbyTesting.perf.clients.SequenceGeneratorConcurrency;
import org.apache.derbyTesting.perf.clients.SingleRecordFiller;
import org.apache.derbyTesting.perf.clients.SingleRecordSelectClient;
import org.apache.derbyTesting.perf.clients.SingleRecordUpdateClient;
import org.apache.derbyTesting.perf.clients.WisconsinFiller;

public class Runner {
    private static final String DERBY_EMBEDDED_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String DEFAULT_URL = "jdbc:derby:db;create=true";
    private static String driver = "org.apache.derby.jdbc.EmbeddedDriver";
    private static String url = "jdbc:derby:db;create=true";
    private static String user = "test";
    private static String password = "test";
    private static boolean init = false;
    private static String load;
    private static final HashMap<String, String> loadOpts;
    private static String generator;
    private static int threads;
    private static int requestsPerSecond;
    private static int warmupSec;
    private static int steadySec;
    private static final String USAGE = "Valid parameters:\n  -driver: JDBC driver class, default: org.apache.derby.jdbc.EmbeddedDriver\n  -url: JDBC connection url, default: jdbc:derby:db;create=true\n  -user: JDBC user name, default: test\n  -pass: JDBC user password, default: test\n  -init: initialize database (otherwise, reuse database)\n  -load: type of load, required argument, valid types:\n      * sr_select - single-record (primary key) select from table with\n                    100 000 rows. It accepts the following load-specific\n                    options (see also -load_opts):\n            - blob or clob: use BLOB or CLOB data instead of VARCHAR\n            - secondary: select on a column with a secondary (non-unique)\n              index instead of the primary key\n            - nonIndexed: select on a non-indexed column instead of the\n              primary key\n      * sr_update - single-record (primary key) update on table with\n                    100 000 rows. It accepts the same load-specific\n                    options as sr_select.\n      * sr_select_big - single-record (primary key) select from table with\n                    100 000 000 rows\n      * sr_update_big - single-record (primary key) update on table with\n                    100 000 000 rows\n      * sr_select_multi - single-record select from a random table\n                    (32 tables with a single row each)\n      * sr_update_multi - single-record update on a random table\n                    (32 tables with a single row each)\n      * index_join - join of two tables (using indexed columns)\n      * group_by - GROUP BY queries against TENKTUP1\n      * bank_tx - emulate simple bank transactions, similar to TPC-B. The\n                  following load-specific options are accepted:\n            - branches=NN: specifies the number of branches in the db\n                           (default: 1)\n            - tellersPerBranch=NN: specifies how many tellers each branch\n              in the database has (default: 10)\n            - accountsPerBranch=NN: specifies the number of accounts in\n              each branch (default: 100000)\n      * seq_gen - sequence generator concurrency. Accepts\n                    the following load-specific options (see also -load_opts):\n            - numberOfGenerators: number of sequences to create\n            - tablesPerGenerator: number of tables to create per sequence\n            - insertsPerTransaction: number of inserts to perform per transaction\n            - debugging: 1 means print debug chatter, 0 means do not print the chatter\n            - identityTest: 1 means do identity column testing, any other number \n                    means do sequence generator testing. If no identityTest is specified \n                    then sequence generator testing will be done by default \n  -load_opts: comma-separated list of load-specific options\n  -gen: load generator, default: b2b, valid types:\n      * b2b - clients perform operations back-to-back\n      * poisson - load is Poisson distributed\n  -threads: number of threads performing operations, default: 1\n  -rate: average number of transactions per second to inject when\n         load generator is \"poisson\", default: 100\n  -wt: warmup time in seconds, default: 30\n  -rt: time in seconds to collect results, default: 60";

    public static void main(String[] stringArray) throws Exception {
        Client[] clientArray;
        try {
            Runner.parseArgs(stringArray);
        }
        catch (Exception exception) {
            System.err.println(exception);
            Runner.printUsage(System.err);
            System.exit(1);
        }
        Class<?> clazz = Class.forName(driver);
        clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        if (init) {
            clientArray = Runner.getDBFiller();
            Connection connection = DriverManager.getConnection(url, user, password);
            System.out.println("initializing database...");
            clientArray.fill(connection);
            connection.close();
        }
        clientArray = new Client[threads];
        for (int i = 0; i < clientArray.length; ++i) {
            Connection connection = DriverManager.getConnection(url, user, password);
            connection.setTransactionIsolation(2);
            clientArray[i] = Runner.newClient();
            clientArray[i].init(connection);
        }
        LoadGenerator loadGenerator = Runner.getLoadGenerator();
        loadGenerator.init(clientArray);
        System.out.println("starting warmup...");
        loadGenerator.startWarmup();
        Thread.sleep(1000L * (long)warmupSec);
        System.out.println("entering steady state...");
        loadGenerator.startSteadyState();
        Thread.sleep(1000L * (long)steadySec);
        System.out.println("stopping threads...");
        loadGenerator.stop();
        loadGenerator.printReport(System.out);
        Runner.shutdownDatabase();
    }

    private static void parseArgs(String[] stringArray) throws Exception {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-driver")) {
                driver = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-url")) {
                url = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-user")) {
                user = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-pass")) {
                password = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-init")) {
                init = true;
                continue;
            }
            if (stringArray[i].equals("-load")) {
                load = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-load_opts")) {
                Runner.parseLoadOpts(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-gen")) {
                generator = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-threads")) {
                threads = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-rate")) {
                requestsPerSecond = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-wt")) {
                warmupSec = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-rt")) {
                steadySec = Integer.parseInt(stringArray[++i]);
                continue;
            }
            throw new Exception("invalid argument: " + stringArray[i]);
        }
        if (load == null) {
            throw new Exception("required parameter -load not specified");
        }
    }

    private static void parseLoadOpts(String string) {
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("=", 2);
            if (stringArray2.length == 2) {
                loadOpts.put(stringArray2[0], stringArray2[1]);
                continue;
            }
            loadOpts.put(stringArray[i], null);
        }
    }

    private static boolean hasOption(String string) {
        return loadOpts.keySet().contains(string);
    }

    static int getLoadOpt(String string, int n) {
        String string2 = loadOpts.get(string);
        return string2 == null ? n : Integer.parseInt(string2);
    }

    private static void printUsage(PrintStream printStream) {
        printStream.println(USAGE);
    }

    private static int getTextType() {
        boolean bl = Runner.hasOption("blob");
        boolean bl2 = Runner.hasOption("clob");
        if (bl && bl2) {
            System.err.println("Cannot specify both 'blob' and 'clob'");
            Runner.printUsage(System.err);
            System.exit(1);
        }
        if (bl) {
            return 2004;
        }
        if (bl2) {
            return 2005;
        }
        return 12;
    }

    private static DBFiller getDBFiller() {
        if (load.equals("sr_select") || load.equals("sr_update")) {
            return new SingleRecordFiller(100000, 1, Runner.getTextType(), Runner.hasOption("secondary"), Runner.hasOption("nonIndexed"));
        }
        if (load.equals("sr_select_big") || load.equals("sr_update_big")) {
            return new SingleRecordFiller(100000000, 1);
        }
        if (load.equals("sr_select_multi") || load.equals("sr_update_multi")) {
            return new SingleRecordFiller(1, 32);
        }
        if (load.equals("index_join")) {
            return new WisconsinFiller();
        }
        if (load.equals("group_by")) {
            return new WisconsinFiller(Runner.getLoadOpt("numRows", 10000));
        }
        if (load.equals("bank_tx")) {
            return new BankAccountFiller(Runner.getLoadOpt("branches", 1), Runner.getLoadOpt("tellersPerBranch", 10), Runner.getLoadOpt("accountsPerBranch", 100000));
        }
        if (load.equals("seq_gen")) {
            return new SequenceGeneratorConcurrency.Filler();
        }
        System.err.println("unknown load: " + load);
        Runner.printUsage(System.err);
        System.exit(1);
        return null;
    }

    private static Client newClient() {
        if (load.equals("sr_select")) {
            return new SingleRecordSelectClient(100000, 1, Runner.getTextType(), Runner.hasOption("secondary"), Runner.hasOption("nonIndexed"));
        }
        if (load.equals("sr_update")) {
            return new SingleRecordUpdateClient(100000, 1, Runner.getTextType(), Runner.hasOption("secondary"), Runner.hasOption("nonIndexed"));
        }
        if (load.equals("sr_select_big")) {
            return new SingleRecordSelectClient(100000000, 1);
        }
        if (load.equals("sr_update_big")) {
            return new SingleRecordUpdateClient(100000000, 1);
        }
        if (load.equals("sr_select_multi")) {
            return new SingleRecordSelectClient(1, 32);
        }
        if (load.equals("sr_update_multi")) {
            return new SingleRecordUpdateClient(1, 32);
        }
        if (load.equals("index_join")) {
            return new IndexJoinClient();
        }
        if (load.equals("group_by")) {
            return new GroupByClient();
        }
        if (load.equals("bank_tx")) {
            return new BankTransactionClient(Runner.getLoadOpt("branches", 1), Runner.getLoadOpt("tellersPerBranch", 10), Runner.getLoadOpt("accountsPerBranch", 100000));
        }
        if (load.equals("seq_gen")) {
            return new SequenceGeneratorConcurrency.SGClient();
        }
        System.err.println("unknown load: " + load);
        Runner.printUsage(System.err);
        System.exit(1);
        return null;
    }

    private static LoadGenerator getLoadGenerator() {
        if (generator.equals("b2b")) {
            return new BackToBackLoadGenerator();
        }
        if (generator.equals("poisson")) {
            double d = 1000.0 * (double)threads / (double)requestsPerSecond;
            return new PoissonLoadGenerator(d);
        }
        System.err.println("unknown load generator: " + generator);
        Runner.printUsage(System.err);
        System.exit(1);
        return null;
    }

    private static void shutdownDatabase() throws SQLException {
        block3: {
            if (driver.equals(DERBY_EMBEDDED_DRIVER)) {
                try {
                    DriverManager.getConnection(url + ";shutdown=true");
                    System.err.println("WARNING: Shutdown of database didn't throw expected exception");
                }
                catch (SQLException sQLException) {
                    if ("08006".equals(sQLException.getSQLState())) break block3;
                    System.err.println("WARNING: Shutdown of database threw unexpected exception");
                    sQLException.printStackTrace();
                }
            }
        }
    }

    static {
        loadOpts = new HashMap();
        generator = "b2b";
        threads = 1;
        requestsPerSecond = 100;
        warmupSec = 30;
        steadySec = 60;
    }
}

