/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class EncryptionAESTest
extends BaseJDBCTestCase {
    private static final String TABLE = "encryptionkeytestdata";
    private static final int[] DATA = new int[]{9, 4, 2, 34, 6543, 3, 123, 434, 5436, -123, 0, 123};

    public EncryptionAESTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Encryption AES suite");
        baseTestSuite.addTest(TestConfiguration.embeddedSuite(EncryptionAESTest.class));
        return new SupportFilesSetup((Test)baseTestSuite);
    }

    public void testFeedbackModes() throws SQLException {
        String[] stringArray = new String[]{"CBC", "ECB", "OFB", "CFB", "ABC"};
        for (int i = 0; i < stringArray.length; ++i) {
            this.runTestFeedbackModes(stringArray[i]);
        }
    }

    protected void runTestFeedbackModes(String string) throws SQLException {
        String string2 = "encryptedDB_Feedback" + string;
        String string3 = "AES/" + string + "/NoPadding";
        String[] stringArray = new String[]{"bootPassword=Thursday"};
        if (string == "ABC") {
            this.assertNoDBCreated("XBCXI", string2, string3, stringArray);
            return;
        }
        Connection connection = this.createAndPopulateDB(string2, string3, stringArray);
        this.validateDBContents(connection);
        connection.close();
        this.shutdown(string2);
        connection = this.getConnection(string2, string3, stringArray);
        this.validateDBContents(connection);
        connection.close();
        this.shutdown(string2);
    }

    public void testUnsupportedPadding() throws SQLException {
        this.assertNoDBCreated("XBCXB", "badPadDB", "AES/ECB/PKCS5Padding", new String[]{"bootPassword=Thursday"});
    }

    public void testEncryptionKeyLengths() throws SQLException {
        String[] stringArray = new String[]{"128", "192", "256"};
        for (int i = 0; i < stringArray.length; ++i) {
            this.runTestEncryptionKeyLengths(stringArray[i]);
        }
        this.assertNoDBCreated("XJ001", "badKeyLengthDB", "AES/ECB/NoPadding", new String[]{"encryptionKeyLength=512", "bootPassword=Thursday"});
    }

    protected void runTestEncryptionKeyLengths(String string) throws SQLException {
        String string2 = "encrKeyLength" + string + "DB";
        String string3 = "AES/CBC/NoPadding";
        String[] stringArray = new String[]{"encryptionKeyLength=" + string, "bootPassword=Thursday"};
        Connection connection = this.createAndPopulateDB(string2, string3, stringArray);
        if (connection == null) {
            if (TestConfiguration.getCurrent().doTrace()) {
                System.out.println("no unrestricted policy jars; cannot test AES encryption with encryptionKeyLengths 192 nor 256");
            }
            return;
        }
        this.validateDBContents(connection);
        connection.close();
        this.shutdown(string2);
        connection = this.getConnection(string2, string3, stringArray);
        this.validateDBContents(connection);
        connection.close();
        connection = this.getDriverManagerConnection(string2, string3, stringArray);
        this.validateDBContents(connection);
        connection.close();
        this.shutdown(string2);
        String[] stringArray2 = new String[]{"128", "192", "256", "512"};
        for (int i = 0; i < stringArray2.length; ++i) {
            if (string.equals(stringArray2[i])) continue;
            stringArray = new String[]{"encryptionKeyLength=" + stringArray2[i], "bootPassword=Thursday"};
            this.runMismatchKeyLength(string2, string3, string, stringArray);
        }
        stringArray = new String[]{"encryptionKeyLength=" + string, "bootPassword=Thursday", "newBootPassword=Saturday"};
        connection = this.getDriverManagerConnection(string2, string3, stringArray);
        this.validateDBContents(connection);
        connection.close();
        this.shutdown(string2);
        stringArray = new String[]{"encryptionKeyLength=" + string, "bootPassword=Saturday"};
        connection = this.getDriverManagerConnection(string2, string3, stringArray);
        this.validateDBContents(connection);
        connection.close();
        this.shutdown(string2);
    }

    public void runMismatchKeyLength(String string, String string2, String string3, String[] stringArray) throws SQLException {
        Connection connection = null;
        try {
            connection = this.getConnection(string, string2, stringArray);
            this.validateDBContents(connection);
            connection.close();
            this.shutdown(string);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            connection.close();
            this.shutdown(string);
            EncryptionAESTest.assertSQLState("XBM06", sQLException);
        }
    }

    private String obtainDbName(String string) {
        File file = new File(string);
        return PrivilegedFileOpsForTests.getAbsolutePath(new File("extinout", file.getPath()));
    }

    protected void assertNoDBCreated(String string, String string2, String string3, String[] stringArray) throws SQLException {
        try {
            this.getConnection(string2, string3, stringArray);
            EncryptionAESTest.fail((String)"expected error message re unsupported functionality");
        }
        catch (SQLException sQLException) {
            EncryptionAESTest.assertSQLState(string, sQLException);
        }
    }

    protected Connection createAndPopulateDB(String string, String string2, String[] stringArray) throws SQLException {
        try {
            Connection connection = this.getConnection(string, string2, stringArray);
            SQLWarning sQLWarning = connection.getWarnings();
            if (sQLWarning != null && "01J01".equals(sQLWarning.getSQLState())) {
                EncryptionAESTest.fail((String)("Refusing to continue, database already exists <" + sQLWarning.getMessage() + ">"));
            }
            Statement statement = connection.createStatement();
            statement.executeUpdate("CREATE TABLE encryptionkeytestdata (id int NOT NULL, val int NOT NULL, PRIMARY KEY(id))");
            statement.close();
            PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO encryptionkeytestdata (id, val) VALUES (?,?)");
            for (int i = 0; i < DATA.length; ++i) {
                preparedStatement.setInt(1, i);
                preparedStatement.setInt(2, DATA[i]);
                preparedStatement.executeUpdate();
            }
            preparedStatement.close();
            return connection;
        }
        catch (SQLException sQLException) {
            EncryptionAESTest.assertSQLState("XJ001", sQLException);
            return null;
        }
    }

    private Connection getConnection(String string, String string2, String[] stringArray) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource(this.obtainDbName(string));
        StringBuffer stringBuffer = new StringBuffer(75);
        JDBCDataSource.setBeanProperty(dataSource, "CreateDatabase", "create");
        stringBuffer.append("dataEncryption=true;");
        stringBuffer.append("encryptionAlgorithm=");
        stringBuffer.append(string2);
        stringBuffer.append(";");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(";");
        }
        JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", stringBuffer.toString());
        return dataSource.getConnection();
    }

    private Connection getDriverManagerConnection(String string, String string2, String[] stringArray) throws SQLException {
        Object object;
        Object object2 = TestConfiguration.getCurrent().getJDBCUrl(this.obtainDbName(string));
        object2 = (String)object2 + ";create=true;dataEncryption=true;encryptionAlgorithm=" + string2 + ";";
        for (int i = 0; i < stringArray.length; ++i) {
            object2 = (String)object2 + stringArray[i] + ";";
        }
        String string3 = this.getTestConfiguration().getJDBCClient().getJDBCDriverName();
        try {
            object = Class.forName(string3);
            ((Class)object).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            EncryptionAESTest.fail((String)("\nUnable to load the JDBC driver " + string3));
        }
        catch (InstantiationException instantiationException) {
            EncryptionAESTest.fail((String)("\nUnable to instantiate the JDBC driver " + string3));
        }
        catch (IllegalAccessException illegalAccessException) {
            EncryptionAESTest.fail((String)("\nNot allowed to access the JDBC driver " + string3));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            EncryptionAESTest.fail((String)("\nNo such constructor for the JDBC driver " + string3));
        }
        catch (InvocationTargetException invocationTargetException) {
            EncryptionAESTest.fail((String)("\nCannot invoke the constructor for the the JDBC driver " + string3));
        }
        object = DriverManager.getConnection((String)object2);
        return object;
    }

    protected void shutdown(String string) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource(this.obtainDbName(string));
        JDBCDataSource.shutdownDatabase(dataSource);
    }

    protected void validateDBContents(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT id, val FROM encryptionkeytestdata ORDER BY id");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"0", "9"}, {"1", "4"}, {"2", "2"}, {"3", "34"}, {"4", "6543"}, {"5", "3"}, {"6", "123"}, {"7", "434"}, {"8", "5436"}, {"9", "-123"}, {"10", "0"}, {"11", "123"}});
        resultSet.close();
        statement.close();
    }
}

